DROP TABLE IF EXISTS `DELETE_comments`;

CREATE TABLE `DELETE_comments` (
  `id` mediumint(6) unsigned NOT NULL auto_increment,
  `father_id` mediumint(6) unsigned NOT NULL default '0',
  `ans_kom` mediumint(6) unsigned NOT NULL default '0',
  `user_id` mediumint(6) unsigned NOT NULL default '0',
  `user_name` varchar(25) collate utf8_unicode_ci NOT NULL,
  `site_email` varchar(30) collate utf8_unicode_ci NOT NULL,
  `text` text collate utf8_unicode_ci NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `visible` enum('0','1','2') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `DELETE_imgroups`;

CREATE TABLE `DELETE_imgroups` (
  `id` smallint(3) unsigned NOT NULL auto_increment,
  `name_uk` varchar(30) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(30) collate utf8_unicode_ci NOT NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Групи категорій цін';

DROP TABLE IF EXISTS `DELETE_imkatalog`;

CREATE TABLE `DELETE_imkatalog` (
  `id` mediumint(5) unsigned NOT NULL auto_increment,
  `url` varchar(255) collate utf8_unicode_ci NOT NULL,
  `fathercode` mediumint(5) NOT NULL default '0',
  `sort` smallint(5) unsigned NOT NULL default '0',
  `name_uk` varchar(50) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(50) collate utf8_unicode_ci NOT NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `DELETE_imod_vumiru`;

CREATE TABLE `DELETE_imod_vumiru` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name_uk` varchar(40) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(40) collate utf8_unicode_ci NOT NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name_uk` (`name_uk`),
  UNIQUE KEY `name_ru` (`name_ru`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Одиниці виміру';

DROP TABLE IF EXISTS `DELETE_imorderbody`;

CREATE TABLE `DELETE_imorderbody` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `order_id` int(6) unsigned NOT NULL default '0',
  `tovar_id` mediumint(6) unsigned NOT NULL default '0',
  `price` decimal(6,2) NOT NULL default '0.00',
  `kilkist` mediumint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `DELETE_imorderhead`;

CREATE TABLE `DELETE_imorderhead` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `price_group` varchar(15) collate utf8_unicode_ci NOT NULL,
  `user_id` mediumint(6) unsigned NOT NULL default '0',
  `guest_id` varchar(6) collate utf8_unicode_ci NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `pay_method` enum('0','1','2','3') collate utf8_unicode_ci NOT NULL default '0',
  `status` enum('0','1','2','3','4','5') collate utf8_unicode_ci NOT NULL default '0',
  `comment` varchar(255) collate utf8_unicode_ci NOT NULL,
  `fio` varchar(70) collate utf8_unicode_ci NOT NULL,
  `tel` bigint(12) unsigned NOT NULL,
  `dostavka_oblast` tinyint(2) unsigned NOT NULL,
  `dostavka_rajon` varchar(30) collate utf8_unicode_ci NOT NULL,
  `dostavka_city` varchar(30) collate utf8_unicode_ci NOT NULL,
  `dostavka_vylutsia` varchar(35) collate utf8_unicode_ci NOT NULL,
  `dostavka_bydunok` varchar(5) collate utf8_unicode_ci NOT NULL,
  `dostavka_kvartura` varchar(3) collate utf8_unicode_ci NOT NULL,
  `email` varchar(40) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `DELETE_impictures`;

CREATE TABLE `DELETE_impictures` (
  `id` mediumint(6) unsigned NOT NULL auto_increment,
  `fathercode` mediumint(6) unsigned NOT NULL,
  `sort` tinyint(2) unsigned NOT NULL default '0',
  `w` smallint(5) unsigned NOT NULL default '0',
  `h` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `DELETE_imprices`;

CREATE TABLE `DELETE_imprices` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `id_group` smallint(3) unsigned NOT NULL,
  `id_product` mediumint(6) unsigned NOT NULL,
  `price` decimal(6,2) unsigned NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `DELETE_improducts`;

CREATE TABLE `DELETE_improducts` (
  `id` mediumint(6) unsigned NOT NULL auto_increment,
  `fathercode` mediumint(5) NOT NULL default '0',
  `sort` smallint(5) unsigned NOT NULL default '0',
  `valyta` tinyint(1) NOT NULL default '1',
  `name_uk` varchar(255) collate utf8_unicode_ci NOT NULL,
  `opus_uk` text collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(255) collate utf8_unicode_ci NOT NULL,
  `opus_ru` text collate utf8_unicode_ci NOT NULL,
  `picture` mediumint(5) NOT NULL default '0',
  `stocks` mediumint(5) NOT NULL default '0',
  `status_stocks` enum('0','1','2') collate utf8_unicode_ci NOT NULL default '0',
  `new_product` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  `action` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  `recommended` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  `discount` tinyint(2) NOT NULL default '0',
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `DELETE_imspecifications`;

CREATE TABLE `DELETE_imspecifications` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name_uk` varchar(30) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(30) collate utf8_unicode_ci NOT NULL,
  `sort` mediumint(5) unsigned NOT NULL default '0',
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Список всіх характеристик ТОВАРІВ';

DROP TABLE IF EXISTS `DELETE_imspecifications_values`;

CREATE TABLE `DELETE_imspecifications_values` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `id_product` mediumint(6) unsigned NOT NULL,
  `id_specification` smallint(5) unsigned NOT NULL,
  `value` varchar(30) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='значення самих характеристик для конкретної одиниці товару';

DROP TABLE IF EXISTS `DELETE_imsvaz_katalog_specifications`;

CREATE TABLE `DELETE_imsvaz_katalog_specifications` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `katalog_id` smallint(5) unsigned NOT NULL,
  `specification_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Привязка характеристик до категорій';

DROP TABLE IF EXISTS `DELETE_imvalytu`;

CREATE TABLE `DELETE_imvalytu` (
  `id` tinyint(1) NOT NULL auto_increment,
  `name_uk` varchar(10) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(10) collate utf8_unicode_ci NOT NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Грошові одиниці виміру';

DROP TABLE IF EXISTS `DELETE_kontragent_poslyga`;

CREATE TABLE `DELETE_kontragent_poslyga` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `id_kontragent` smallint(5) unsigned NOT NULL,
  `id_poslyga` smallint(5) unsigned NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2777 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Список послуг які привязані до певного клієнта';

INSERT INTO `DELETE_kontragent_poslyga` VALUES 
(1,1,1),
(2,1,3),
(3,1,4),
(4,1,6),
(5,1,8),
(6,2,2),
(7,2,3),
(8,2,10),
(9,3,1),
(10,3,2),
(11,3,3),
(12,3,6),
(13,3,8),
(14,3,11),
(15,4,1),
(16,4,3),
(17,4,4),
(18,4,6),
(19,4,7),
(20,4,8),
(21,4,11),
(22,5,1),
(23,5,7),
(24,5,10),
(25,6,2),
(26,6,3),
(27,7,1),
(28,7,4),
(29,7,5),
(30,7,6),
(31,7,7),
(32,7,8),
(33,8,1),
(34,8,6),
(35,8,11),
(36,9,1),
(37,9,2),
(38,9,7),
(39,9,8),
(40,9,11),
(41,9,12),
(1219,10,8),
(1218,10,6),
(1217,10,3),
(1216,10,1),
(46,11,2),
(47,11,3),
(48,11,5),
(49,12,2),
(50,12,3),
(51,12,6),
(52,13,1),
(53,13,2),
(54,13,3),
(55,13,7),
(56,13,8),
(57,15,2),
(58,15,6),
(59,15,7),
(60,15,11),
(61,16,2),
(62,16,3),
(63,16,4),
(64,16,5),
(65,16,7),
(66,17,1),
(67,17,2),
(68,17,3),
(69,17,5),
(70,17,6),
(71,17,11),
(72,18,1),
(73,18,2),
(74,18,3),
(75,18,4),
(76,18,5),
(77,18,6),
(78,18,7),
(79,18,8),
(80,18,9),
(81,18,11),
(82,18,12),
(83,19,1),
(84,19,2),
(85,19,3),
(86,19,6),
(87,19,11),
(88,20,1),
(89,20,4),
(90,20,6),
(91,20,8),
(92,21,1),
(93,21,4),
(94,21,5),
(95,21,6),
(96,21,8),
(97,22,1),
(98,22,2),
(99,22,11),
(100,23,2),
(101,23,3),
(102,23,8),
(103,24,1),
(104,24,2),
(105,24,3),
(106,24,6),
(107,24,7),
(108,24,10),
(109,24,11),
(110,24,12),
(2773,25,9),
(2772,25,8),
(2771,25,6),
(2770,25,5),
(1514,26,8),
(1513,26,7),
(1512,26,5),
(119,27,1),
(120,27,3),
(121,27,4),
(122,27,6),
(123,27,7),
(124,27,12),
(125,28,1),
(126,28,2),
(127,28,3),
(128,28,6),
(129,28,8),
(130,28,11),
(131,29,1),
(132,29,5),
(133,29,11),
(134,29,12),
(135,30,2),
(136,30,3),
(137,30,7),
(138,31,1),
(139,31,2),
(140,31,3),
(141,31,5),
(142,31,7),
(143,31,8),
(144,31,9),
(145,31,11),
(146,31,12),
(147,32,1),
(148,32,2),
(149,32,3),
(150,32,6),
(151,32,8),
(1611,33,8),
(1610,33,6),
(1609,33,3),
(1608,33,2),
(1607,33,1),
(157,0,1),
(158,0,2),
(159,0,3),
(160,0,6),
(161,0,8),
(162,34,1),
(163,34,4),
(164,34,5),
(165,34,6),
(166,35,10),
(167,36,1),
(168,36,4),
(169,36,7),
(170,36,8),
(171,37,1),
(172,37,2),
(173,37,3),
(174,37,5),
(175,37,6),
(176,37,7),
(177,37,11),
(178,38,1),
(179,38,4),
(180,38,5),
(181,38,6),
(182,38,8),
(183,38,12),
(184,39,1),
(185,39,4),
(186,39,6),
(187,39,8),
(188,40,2),
(189,40,3),
(190,40,7),
(191,41,1),
(192,41,2),
(193,41,3),
(194,41,4),
(195,41,7),
(196,41,10),
(197,41,11),
(198,42,1),
(199,42,2),
(200,42,3),
(201,42,8),
(202,42,11),
(203,42,12),
(2738,43,6),
(2737,43,1),
(206,45,1),
(207,45,2),
(208,45,3),
(209,45,4),
(210,45,6),
(211,46,1),
(212,46,2),
(213,46,3),
(214,46,4),
(215,46,5),
(216,46,6),
(217,46,7),
(218,46,8),
(219,46,10),
(220,46,11),
(221,47,1),
(222,47,5),
(223,47,6),
(224,47,7),
(225,47,12),
(226,48,1),
(227,48,2),
(228,48,3),
(229,48,6),
(230,48,12),
(231,49,1),
(232,49,2),
(233,49,4),
(234,49,6),
(235,49,8),
(236,49,11),
(237,50,1),
(238,50,4),
(239,50,8),
(240,51,1),
(241,51,2),
(242,51,3),
(243,51,4),
(244,51,5),
(245,51,7),
(246,51,10),
(247,51,11),
(248,52,1),
(249,52,6),
(250,52,7),
(251,52,11),
(252,53,4),
(253,53,6),
(254,54,3),
(255,54,6),
(256,54,7),
(257,54,8),
(258,54,11),
(259,54,12),
(260,55,5),
(261,55,8),
(262,56,4),
(263,56,6),
(264,56,7),
(265,56,10),
(266,56,12),
(267,57,1),
(268,57,3),
(269,57,4),
(270,57,7),
(271,57,11),
(272,58,2),
(273,58,3),
(274,58,4),
(275,58,6),
(276,58,8),
(277,59,2),
(278,59,3),
(279,59,4),
(280,59,6),
(281,59,11),
(282,60,1),
(283,60,3),
(284,60,5),
(285,60,9),
(286,60,11),
(287,60,12),
(288,61,1),
(289,61,2),
(290,61,3),
(291,61,4),
(292,61,7),
(293,62,1),
(294,62,2),
(295,62,3),
(296,62,4),
(297,62,5),
(298,62,6),
(299,62,7),
(300,62,10),
(1152,63,10),
(1151,63,7),
(1150,63,6),
(1149,63,5),
(1148,63,3),
(1147,63,2),
(1146,63,1),
(308,64,1),
(309,64,6),
(310,65,1),
(311,65,4),
(312,65,5),
(313,65,6),
(314,65,7),
(315,65,8),
(316,65,10),
(317,66,1),
(318,66,4),
(319,66,6),
(320,66,7),
(321,66,9),
(322,66,10),
(323,66,11),
(324,67,2),
(325,67,3),
(326,67,4),
(327,67,6),
(328,67,8),
(329,67,10),
(330,67,11),
(331,68,1),
(332,68,3),
(333,68,4),
(334,68,8),
(335,68,11),
(336,69,1),
(337,69,2),
(338,69,4),
(339,69,6),
(340,69,7),
(341,69,8),
(342,69,12),
(1120,70,10),
(1119,70,6),
(1118,70,6),
(346,71,1),
(347,71,4),
(348,71,11),
(349,71,12),
(350,72,2),
(351,72,3),
(352,72,6),
(353,73,1),
(354,73,2),
(355,73,3),
(356,73,4),
(357,73,7),
(358,73,8),
(359,74,1),
(360,74,3),
(361,74,4),
(362,74,6),
(363,74,8),
(364,75,1),
(365,75,4),
(366,75,6),
(367,75,12),
(368,76,1),
(369,76,5),
(370,76,10),
(371,77,2),
(372,77,3),
(373,77,4),
(374,77,6),
(375,78,1),
(376,78,2),
(377,78,6),
(378,78,8),
(2122,79,8),
(2121,79,6),
(2120,79,4),
(382,80,1),
(383,80,6),
(384,80,7),
(385,81,1),
(386,81,2),
(387,81,5),
(388,81,8),
(389,82,1),
(390,82,3),
(391,82,6),
(392,82,8),
(393,82,11),
(394,82,12),
(395,83,1),
(396,83,2),
(397,83,3),
(398,83,4),
(399,83,5),
(400,83,6),
(401,83,9),
(402,83,12),
(403,84,1),
(404,84,5),
(405,84,7),
(406,84,11),
(407,84,12),
(408,85,1),
(409,85,2),
(410,85,3),
(411,85,6),
(412,85,8),
(413,85,11),
(414,86,1),
(415,86,2),
(416,86,3),
(417,86,4),
(418,86,5),
(419,86,6),
(420,86,7),
(421,86,8),
(422,86,10),
(423,86,11),
(424,86,12),
(425,87,2),
(426,87,3),
(427,87,4),
(428,87,6),
(429,87,10),
(430,87,11),
(431,88,1),
(432,88,2),
(433,88,3),
(434,88,5),
(435,88,7),
(436,88,8),
(437,88,10),
(438,89,1),
(439,89,2),
(440,89,3),
(441,89,6),
(442,89,7),
(443,89,10),
(444,90,1),
(445,90,2),
(446,90,5),
(447,91,1),
(448,91,2),
(449,91,3),
(450,91,4),
(451,91,6),
(452,91,12),
(453,92,1),
(454,92,2),
(455,92,3),
(456,92,7),
(457,92,11),
(458,93,1),
(459,93,2),
(460,93,3),
(461,93,4),
(462,93,6),
(463,93,8),
(464,93,11),
(465,93,12),
(466,94,2),
(467,94,3),
(468,94,4),
(469,95,1),
(470,95,2),
(471,95,3),
(472,95,4),
(473,95,6),
(474,95,7),
(475,95,8),
(476,95,10),
(477,95,11),
(478,96,1),
(479,96,2),
(480,96,3),
(481,96,4),
(482,96,7),
(483,96,9),
(484,96,10),
(485,96,12),
(486,97,1),
(487,97,2),
(488,97,3),
(489,97,6),
(490,97,7),
(491,98,2),
(492,98,3),
(493,98,4),
(494,98,6),
(495,98,7),
(496,98,8),
(497,98,9),
(498,99,4),
(499,99,7),
(500,99,8),
(501,100,1);

INSERT INTO `DELETE_kontragent_poslyga` VALUES 
(502,100,2),
(503,100,3),
(504,100,4),
(505,100,6),
(506,100,7),
(507,100,8),
(508,100,11),
(509,101,2),
(510,101,3),
(511,101,6),
(512,101,8),
(513,101,11),
(514,102,1),
(515,102,2),
(516,102,3),
(517,102,6),
(518,103,3),
(519,103,6),
(520,104,2),
(521,104,3),
(522,104,5),
(523,104,6),
(524,104,7),
(525,104,8),
(526,105,1),
(527,105,4),
(528,105,5),
(529,105,6),
(541,106,12),
(540,106,11),
(539,106,7),
(538,106,3),
(537,106,2),
(536,106,1),
(542,107,1),
(543,107,5),
(544,107,7),
(545,108,1),
(546,108,2),
(547,108,3),
(548,108,11),
(549,109,1),
(550,109,4),
(551,109,7),
(552,109,12),
(553,110,1),
(554,110,2),
(555,110,3),
(556,110,6),
(557,110,7),
(558,111,1),
(559,111,6),
(560,111,8),
(561,112,1),
(562,112,4),
(563,112,6),
(564,112,7),
(565,113,1),
(566,113,2),
(567,113,3),
(568,113,11),
(569,114,1),
(570,114,2),
(571,114,3),
(572,114,8),
(1848,115,11),
(1847,115,10),
(1846,115,8),
(1845,115,7),
(1844,115,6),
(1843,115,3),
(1842,115,2),
(1841,115,1),
(581,116,1),
(582,116,3),
(583,116,5),
(584,116,6),
(585,116,10),
(586,117,2),
(587,117,4),
(588,117,8),
(589,117,12),
(590,118,1),
(591,118,2),
(592,118,7),
(593,118,8),
(594,119,1),
(595,119,2),
(596,119,5),
(597,119,7),
(598,119,8),
(599,119,12),
(600,120,2),
(601,120,3),
(602,120,6),
(603,121,1),
(604,121,2),
(605,121,3),
(606,121,4),
(607,121,6),
(608,121,8),
(609,121,11),
(610,121,12),
(1253,122,11),
(1252,122,6),
(1251,122,4),
(1250,122,3),
(1249,122,2),
(616,123,1),
(617,123,4),
(618,123,7),
(1896,124,8),
(1895,124,6),
(1894,124,2),
(622,125,1),
(623,125,2),
(624,125,3),
(625,125,5),
(626,125,6),
(627,125,7),
(628,125,9),
(629,125,10),
(630,125,12),
(631,126,1),
(632,126,5),
(633,126,6),
(634,126,7),
(635,127,4),
(636,127,5),
(637,127,6),
(638,127,8),
(639,127,9),
(640,127,11),
(641,128,1),
(642,128,3),
(643,128,6),
(644,128,11),
(645,129,1),
(646,129,4),
(647,129,8),
(648,129,11),
(649,130,4),
(650,130,5),
(651,130,6),
(652,130,10),
(653,130,11),
(654,131,1),
(655,131,2),
(656,131,3),
(657,131,6),
(2776,132,6),
(2775,132,3),
(2774,132,1),
(662,133,2),
(663,133,4),
(664,133,12),
(665,134,1),
(666,134,3),
(667,134,6),
(668,134,8),
(669,134,10),
(670,135,2),
(671,135,7),
(672,135,10),
(673,135,12),
(674,136,1),
(675,136,6),
(676,136,7),
(677,136,10),
(678,137,5),
(679,137,6),
(680,137,7),
(681,137,8),
(682,137,10),
(683,138,2),
(684,138,4),
(685,139,1),
(686,139,5),
(687,139,12),
(688,140,1),
(689,140,5),
(690,140,7),
(691,140,8),
(692,140,11),
(693,141,1),
(694,141,2),
(695,141,3),
(696,141,4),
(697,141,7),
(698,141,8),
(699,141,12),
(700,142,2),
(701,142,3),
(2769,143,11),
(2768,143,8),
(2767,143,6),
(2766,143,5),
(2765,143,3),
(2764,143,2),
(2763,143,1),
(710,144,1),
(711,144,2),
(712,144,3),
(713,144,5),
(714,144,6),
(715,144,7),
(716,144,8),
(717,144,10),
(718,144,11),
(719,144,12),
(720,145,1),
(721,145,5),
(722,146,6),
(723,146,7),
(724,146,10),
(725,146,11),
(726,147,1),
(727,147,2),
(728,147,5),
(1353,148,8),
(1352,148,6),
(1351,148,5),
(1350,148,1),
(733,149,2),
(734,149,6),
(735,150,1),
(736,150,2),
(737,150,3),
(738,150,5),
(987,202,2),
(986,202,1),
(741,152,1),
(742,152,3),
(743,152,6),
(744,152,7),
(745,153,1),
(746,153,2),
(747,153,6),
(748,153,8),
(749,154,1),
(750,154,2),
(751,154,6),
(752,154,7),
(753,154,8),
(754,155,1),
(755,155,3),
(756,155,6),
(757,155,8),
(758,155,9),
(759,156,2),
(760,156,3),
(761,156,8),
(762,156,11),
(763,157,1),
(764,157,2),
(765,157,3),
(766,158,2),
(767,158,3),
(768,159,2),
(769,159,3),
(770,159,8),
(1467,160,11),
(1466,160,6),
(1465,160,2),
(774,161,3),
(775,161,4),
(776,161,6),
(777,162,1),
(778,162,2),
(779,162,3),
(780,162,6),
(781,162,8),
(782,162,11),
(2736,163,11),
(2735,163,8),
(2734,163,6),
(2733,163,3),
(2732,163,2),
(788,164,2),
(789,164,3),
(790,165,1),
(791,165,2),
(792,165,4),
(793,165,6),
(794,165,8),
(795,166,6),
(796,166,7),
(797,166,8),
(798,166,9),
(799,167,1),
(800,167,6),
(801,167,7),
(802,167,12),
(803,168,1),
(804,168,2),
(805,168,3),
(806,168,4),
(807,168,5),
(808,168,6),
(809,168,7),
(810,168,8),
(811,168,9),
(812,168,10),
(813,169,4),
(814,169,8),
(815,170,2),
(816,170,3),
(817,170,4),
(818,170,5),
(819,170,6),
(820,170,7),
(821,171,1),
(822,171,2),
(823,171,6),
(824,172,1),
(825,172,3),
(826,172,4),
(827,172,6),
(828,172,7),
(829,172,8),
(830,172,11),
(831,172,12),
(832,173,1),
(833,173,2),
(834,173,4),
(835,173,7),
(836,174,1),
(837,174,2),
(838,174,3),
(839,174,4),
(840,174,6),
(841,174,7),
(842,174,8),
(843,174,11),
(844,174,12),
(845,175,2),
(846,175,3),
(847,175,5),
(848,175,6),
(849,176,2),
(850,176,3),
(851,176,6),
(852,176,7),
(853,177,4),
(854,178,1),
(855,178,2),
(856,178,3),
(857,178,4),
(858,178,5),
(859,178,6),
(860,178,7),
(861,178,8),
(862,178,11),
(863,178,12),
(864,179,2),
(865,179,5),
(866,180,2),
(867,180,3),
(868,180,11),
(869,181,2),
(870,181,3),
(871,182,6),
(872,182,7),
(873,182,11),
(874,182,12),
(875,183,1),
(876,183,4),
(877,183,6),
(878,183,8),
(879,184,1),
(880,184,2),
(881,184,3),
(882,184,11),
(883,185,1),
(884,185,2),
(885,185,3),
(886,185,4),
(887,185,5),
(888,185,6),
(889,185,7),
(890,185,8),
(891,185,9),
(892,185,10),
(893,185,11),
(894,185,12),
(895,186,1),
(896,186,3),
(897,186,6),
(898,186,7),
(2091,187,12),
(2090,187,10),
(2089,187,7),
(2088,187,6),
(2087,187,5),
(2086,187,3),
(2085,187,2),
(2084,187,1),
(907,188,1),
(908,188,3),
(909,188,5),
(910,188,7),
(911,188,8),
(912,189,1),
(913,189,7),
(914,189,8),
(915,189,10),
(916,189,11),
(917,190,1),
(918,190,2),
(919,190,3),
(920,190,4),
(921,190,5),
(922,190,6),
(923,190,7),
(924,190,8),
(925,190,11),
(926,190,12),
(927,191,1),
(928,191,2),
(929,191,3),
(930,191,5),
(931,191,7),
(932,191,8),
(933,191,9),
(934,191,10),
(1511,192,6),
(1510,192,3),
(1509,192,2),
(938,193,1),
(939,193,2),
(940,193,4),
(941,193,7),
(942,193,11),
(943,193,12),
(944,194,1),
(945,194,2),
(946,194,6),
(947,195,1),
(948,195,2),
(949,195,3),
(950,195,4),
(951,195,5),
(952,195,6),
(953,195,7),
(954,195,8),
(955,195,9),
(956,195,10),
(957,195,11),
(1402,196,10),
(1401,196,4),
(960,197,1),
(961,197,4),
(962,197,8),
(963,198,1),
(964,198,6),
(965,198,8),
(966,198,9),
(967,198,10),
(968,198,11),
(969,198,12),
(970,199,1),
(971,199,2),
(972,199,3),
(973,200,2),
(974,200,6),
(975,200,7),
(976,200,8),
(985,151,10),
(984,151,5),
(981,201,6),
(982,201,8),
(983,201,11),
(988,202,4),
(989,202,7),
(990,203,1),
(991,203,5),
(992,203,6),
(993,203,8),
(994,203,11),
(2706,204,11),
(2705,204,10),
(2704,204,5),
(2703,204,3),
(2702,204,1),
(1002,205,1),
(1003,205,2),
(1004,205,10),
(1005,206,2),
(1006,206,8),
(1007,206,10),
(1008,207,1),
(1009,207,2),
(1010,207,3),
(1011,207,6),
(1012,207,7),
(1013,207,8),
(1014,208,3),
(1015,209,3),
(1016,209,5),
(1017,209,8);

INSERT INTO `DELETE_kontragent_poslyga` VALUES 
(1018,210,1),
(1019,210,4),
(1020,210,8),
(1021,211,4),
(1022,211,8),
(1023,212,1),
(1024,212,3),
(1025,212,5),
(1026,212,9),
(1027,212,11),
(1028,213,1),
(1029,213,5),
(1030,213,8),
(1031,213,11),
(1032,214,1),
(1033,214,2),
(1034,214,3),
(1035,214,6),
(1036,214,7),
(1420,215,12),
(1419,215,11),
(1418,215,8),
(1417,215,7),
(1416,215,6),
(1415,215,4),
(1414,215,3),
(1413,215,1),
(1045,216,1),
(1046,216,2),
(1047,216,3),
(1048,216,4),
(1049,217,1),
(1050,217,2),
(1051,217,3),
(1052,217,6),
(1053,217,7),
(1054,218,1),
(1055,218,2),
(1056,218,3),
(1057,219,1),
(1058,219,2),
(1059,219,3),
(1060,219,4),
(1061,219,5),
(1062,219,6),
(1063,219,11),
(1064,220,1),
(1065,220,2),
(1066,220,3),
(1067,220,4),
(1068,220,5),
(1069,220,6),
(1070,221,1),
(1071,221,7),
(1072,222,1),
(1073,222,2),
(1074,222,3),
(1075,222,4),
(1076,222,5),
(1077,223,1),
(1078,223,2),
(1079,223,3),
(1080,223,4),
(1081,223,5),
(1082,223,6),
(1083,223,7),
(1084,223,8),
(1085,223,9),
(1086,223,10),
(1087,223,11),
(1088,223,12),
(1089,224,1),
(1090,224,7),
(1091,224,10),
(1092,224,11),
(1093,225,1),
(1094,225,3),
(1095,225,6),
(1096,225,11),
(1097,226,1),
(1098,226,3),
(1099,226,4),
(1100,226,6),
(1101,226,8),
(1201,227,7),
(1200,227,4),
(1199,227,3),
(1105,228,1),
(1106,228,2),
(1107,228,3),
(1108,228,4),
(1109,228,5),
(1110,228,6),
(1111,229,1),
(1112,229,2),
(1113,229,3),
(1114,229,4),
(1115,229,6),
(1116,229,11),
(1117,229,12),
(1121,70,10),
(1122,70,12),
(1123,70,12),
(1124,230,2),
(1125,230,4),
(1126,230,6),
(1127,230,7),
(1128,230,10),
(1875,231,8),
(1874,231,7),
(1873,231,6),
(1872,231,3),
(1871,231,2),
(1870,231,1),
(2762,232,11),
(2761,232,6),
(2760,232,5),
(2759,232,4),
(2758,232,3),
(2757,232,2),
(1167,233,11),
(1166,233,8),
(1165,233,6),
(1164,233,4),
(1163,233,1),
(1153,234,2),
(1154,234,3),
(1155,234,4),
(1156,234,6),
(1157,234,8),
(1168,235,6),
(1169,235,7),
(1170,235,8),
(1171,236,1),
(1172,236,3),
(1173,236,6),
(1174,236,11),
(1175,237,5),
(1176,237,6),
(1177,237,8),
(1178,238,2),
(1179,238,3),
(1180,238,6),
(1181,239,1),
(1182,239,4),
(1183,239,6),
(1184,239,7),
(1185,239,8),
(1186,239,11),
(1187,239,12),
(1191,240,1),
(1192,240,2),
(1193,240,3),
(1194,240,6),
(1195,240,8),
(1202,241,1),
(1203,241,8),
(1204,241,11),
(1205,242,1),
(1206,242,3),
(1207,242,6),
(1208,242,7),
(1209,242,11),
(1210,243,1),
(1211,243,3),
(1212,243,4),
(1213,243,6),
(1214,243,7),
(1215,243,11),
(1220,244,1),
(1221,244,2),
(1222,244,3),
(1223,244,4),
(1224,244,5),
(1225,244,6),
(1226,244,7),
(1227,244,11),
(1228,244,12),
(1229,245,3),
(1230,245,4),
(1231,245,5),
(1232,245,6),
(1233,245,8),
(1234,245,9),
(1235,245,11),
(1236,0,1),
(1237,0,2),
(1238,0,3),
(1239,0,4),
(1240,0,6),
(1241,0,8),
(1242,0,11),
(1243,0,12),
(1254,246,1),
(1255,246,6),
(1256,246,11),
(1257,247,1),
(1258,247,2),
(1259,247,3),
(1260,247,7),
(1261,247,11),
(1262,248,1),
(1263,248,2),
(1264,248,3),
(1265,248,4),
(1266,248,6),
(1267,248,7),
(1268,248,8),
(1269,248,9),
(1270,248,11),
(1271,248,12),
(1272,249,1),
(1273,249,2),
(1274,249,3),
(1275,249,4),
(1276,249,6),
(1277,249,7),
(1278,249,8),
(1279,249,9),
(1280,249,10),
(1281,249,11),
(1282,249,12),
(1283,250,1),
(1284,250,5),
(1285,250,8),
(1286,250,9),
(1287,250,12),
(1288,251,1),
(1289,251,2),
(1290,251,3),
(1291,251,4),
(1292,251,5),
(1293,251,6),
(1294,251,7),
(1295,251,8),
(1296,251,12),
(1297,252,1),
(1298,252,2),
(1299,252,3),
(1300,252,6),
(1301,252,11),
(1302,0,1),
(1303,0,2),
(1304,0,3),
(1305,0,6),
(1306,0,11),
(1307,253,1),
(1308,253,3),
(1309,253,6),
(1310,253,11),
(1311,254,1),
(1312,254,2),
(1313,254,3),
(1314,254,6),
(1315,254,8),
(1316,254,11),
(1317,255,1),
(1318,0,1),
(1319,255,3),
(1320,0,3),
(1321,255,4),
(1322,0,4),
(1323,255,6),
(1324,0,6),
(1325,0,7),
(1326,255,7),
(1327,0,8),
(1328,255,8),
(1329,0,11),
(1330,255,11),
(1331,0,12),
(1332,255,12),
(1333,256,1),
(1334,256,2),
(1335,256,3),
(1336,256,6),
(1337,256,11),
(1338,257,1),
(1339,257,2),
(1340,257,3),
(1341,257,4),
(1342,257,5),
(1343,257,6),
(1344,257,7),
(1345,257,8),
(1346,257,9),
(1347,257,10),
(1348,257,11),
(1349,257,12),
(1354,0,1),
(1355,0,2),
(1356,0,3),
(1357,0,4),
(1358,0,6),
(1359,0,8),
(1360,0,11),
(1361,0,12),
(1362,0,1),
(1363,0,2),
(1364,0,3),
(1365,0,4),
(1366,0,5),
(1367,0,6),
(1368,0,7),
(1369,0,11),
(1370,0,12),
(1371,0,3),
(1372,0,6),
(1373,0,7),
(1374,0,8),
(1375,0,11),
(1376,0,12),
(1377,0,3),
(1378,0,6),
(1379,0,7),
(1380,0,8),
(1381,0,11),
(1382,0,12),
(1383,0,1),
(1384,0,2),
(1385,0,3),
(1386,0,4),
(1387,0,6),
(1388,0,7),
(1389,0,10),
(1390,0,11),
(1391,0,12),
(1396,0,2),
(1397,0,3),
(1398,0,4),
(1399,0,6),
(1400,0,11),
(1403,0,6),
(1404,0,9),
(1405,0,11),
(1406,0,12),
(1407,0,1),
(1408,0,2),
(1409,0,3),
(1410,0,4),
(1411,0,5),
(1412,0,6),
(1421,0,1),
(1422,0,2),
(1423,0,3),
(1424,0,7),
(1425,0,8),
(1426,0,10),
(1427,0,11),
(1428,0,12),
(1429,0,1),
(1430,0,4),
(1431,0,6),
(1432,0,8),
(1433,0,4),
(1434,0,6),
(1435,0,8),
(1436,0,12),
(1437,0,2),
(1438,0,3),
(1439,0,5),
(1440,0,6),
(1441,0,10),
(1442,0,1),
(1443,0,2),
(1444,0,3),
(1445,0,5),
(1446,0,6),
(1447,0,8),
(1448,0,11),
(1449,0,12),
(1450,0,1),
(1451,0,2),
(1452,0,3),
(1453,0,4),
(1454,0,8),
(1455,0,11),
(1468,0,2),
(1469,0,3),
(1470,0,6),
(1471,0,11),
(1472,0,3),
(1473,0,4),
(1474,0,6),
(1475,0,8),
(1476,0,11),
(1477,0,3),
(1478,0,4),
(1479,0,6),
(1480,0,8),
(1481,0,11),
(1482,0,1),
(1483,0,3),
(1484,0,4),
(1485,0,5),
(1486,0,6),
(1487,0,7),
(1488,0,8),
(1489,0,11),
(1490,0,1),
(1491,0,3),
(1492,0,4),
(1493,0,5),
(1494,0,6),
(1495,0,7),
(1496,0,8),
(1497,0,11),
(1498,0,2),
(1499,0,4),
(1500,0,6),
(1501,0,7),
(1502,0,11),
(1503,0,2),
(1504,0,3),
(1505,0,6),
(1506,0,7),
(1507,0,11),
(1508,0,12),
(1515,0,1),
(1516,0,2),
(1517,0,4),
(1518,0,6),
(1519,0,7),
(1520,0,8),
(1521,0,11),
(1522,0,1),
(1523,0,2),
(1524,0,3),
(1525,0,7),
(1526,0,11),
(1527,0,12),
(1528,0,1),
(1529,0,2),
(1530,0,3),
(1531,0,4),
(1532,0,6),
(1533,0,7),
(1534,0,8),
(1535,0,11),
(1536,0,1),
(1537,0,6),
(1538,0,12),
(1539,0,1),
(1540,0,2),
(1541,0,3),
(1542,0,4),
(1543,0,6),
(1544,0,11),
(1545,0,1),
(1546,0,2),
(1547,0,3),
(1548,0,5),
(1549,0,7),
(1550,0,8),
(1551,0,1),
(1552,0,2),
(1553,0,3),
(1554,0,6),
(1555,0,7),
(1556,0,8),
(1557,0,10),
(1558,0,11),
(1559,0,12),
(1560,0,1),
(1561,0,2),
(1562,0,3),
(1563,0,4),
(1564,0,6),
(1565,0,1),
(1566,0,8),
(1567,0,11),
(1568,0,1),
(1569,0,8),
(1570,0,11),
(1571,0,1),
(1572,0,8),
(1573,0,11),
(1574,0,1),
(1575,0,8),
(1576,0,11),
(1577,0,1),
(1578,0,2),
(1579,0,3),
(1580,0,4),
(1581,0,6),
(1582,0,10),
(1583,0,11),
(1584,0,1),
(1585,0,3),
(1586,0,4),
(1587,0,6),
(1588,0,7),
(1589,0,8),
(1590,0,10),
(1591,0,11),
(1592,0,2),
(1593,0,3),
(1594,0,5),
(1595,0,6),
(1596,0,11);

INSERT INTO `DELETE_kontragent_poslyga` VALUES 
(1597,0,12),
(1598,0,3),
(1599,0,6),
(1600,0,1),
(1601,0,5),
(1602,0,6),
(1603,0,7),
(1604,0,8),
(1605,0,10),
(1606,0,12),
(1612,0,1),
(1613,0,2),
(1614,0,3),
(1615,0,6),
(1616,0,8),
(1617,0,1),
(1618,0,2),
(1619,0,3),
(1620,0,4),
(1621,0,5),
(1622,0,6),
(1623,0,7),
(1624,0,8),
(1625,0,11),
(1626,0,1),
(1627,0,2),
(1628,0,3),
(1629,0,4),
(1630,0,5),
(1631,0,6),
(1632,0,8),
(1633,0,9),
(1634,0,10),
(1635,0,11),
(1636,0,12),
(1637,0,2),
(1638,0,3),
(1639,0,5),
(1640,0,6),
(1641,0,1),
(1642,0,3),
(1643,0,5),
(1644,0,6),
(1645,0,7),
(1646,0,8),
(1647,0,10),
(1648,0,11),
(1649,0,12),
(1650,0,2),
(1651,0,3),
(1652,0,5),
(1653,0,6),
(1654,0,1),
(1655,0,2),
(1656,0,3),
(1657,0,4),
(1658,0,6),
(1659,0,7),
(1893,298,7),
(1892,298,6),
(1891,298,4),
(1890,298,3),
(1889,298,2),
(1888,298,1),
(1666,0,1),
(1667,0,2),
(1668,0,3),
(1669,0,6),
(1670,0,1),
(1671,0,2),
(1672,0,3),
(1673,0,6),
(1674,0,11),
(1675,0,1),
(1676,0,2),
(1677,0,3),
(1678,0,8),
(1679,0,11),
(1680,0,1),
(1681,0,2),
(1682,0,3),
(1683,0,4),
(1684,0,5),
(1685,0,6),
(1686,0,7),
(1687,0,8),
(1688,0,9),
(1689,0,10),
(1690,0,11),
(1691,0,12),
(1692,0,1),
(1693,0,3),
(1694,0,6),
(1695,0,7),
(1696,0,11),
(1697,0,3),
(1698,0,5),
(1699,0,6),
(1700,0,3),
(1701,0,5),
(1702,0,6),
(1703,0,7),
(1704,0,1),
(1705,0,2),
(1706,0,3),
(1707,0,8),
(1708,0,9),
(1709,0,11),
(1710,0,1),
(1711,0,4),
(1712,0,6),
(1713,0,7),
(1714,0,9),
(1715,0,11),
(1716,0,12),
(1717,0,1),
(1718,0,5),
(1719,0,6),
(1720,0,7),
(1721,0,8),
(1722,0,9),
(1723,0,11),
(1724,0,1),
(1725,0,2),
(1726,0,3),
(1727,0,4),
(1728,0,5),
(1729,0,6),
(1730,0,8),
(1731,0,11),
(1732,0,1),
(1733,0,2),
(1734,0,3),
(1735,0,7),
(1736,0,11),
(1737,0,12),
(1738,0,1),
(1739,0,4),
(1740,0,6),
(1741,0,7),
(1742,0,8),
(1743,0,11),
(1744,0,12),
(1745,0,1),
(1746,0,6),
(1747,0,7),
(1748,0,1),
(1749,0,2),
(1750,0,3),
(1751,0,6),
(1752,0,8),
(1753,0,1),
(1754,0,2),
(1755,0,3),
(1756,0,6),
(1757,0,8),
(1758,0,1),
(1759,0,2),
(1760,0,3),
(1761,0,6),
(1762,0,8),
(1763,0,1),
(1764,0,6),
(1765,0,8),
(1766,0,11),
(1767,0,1),
(1768,0,2),
(1769,0,3),
(1770,0,6),
(1771,0,7),
(1772,0,11),
(1773,0,12),
(1774,0,1),
(1775,0,2),
(1776,0,3),
(1777,0,6),
(1778,0,7),
(1779,0,1),
(1780,0,2),
(1781,0,3),
(1782,0,8),
(1783,0,3),
(1784,0,6),
(1785,0,9),
(1786,0,12),
(1839,0,3),
(1838,0,2),
(1789,0,1),
(1790,0,2),
(1791,0,3),
(1792,0,4),
(1793,0,5),
(1794,0,6),
(1795,0,7),
(1796,0,8),
(1797,0,9),
(1798,0,11),
(1799,0,12),
(1802,0,1),
(1803,0,2),
(1804,0,3),
(1805,0,4),
(1806,0,5),
(1807,0,6),
(1808,0,7),
(1809,0,8),
(1810,0,9),
(1811,0,10),
(1812,0,11),
(1813,0,12),
(1816,0,2),
(1817,0,3),
(1818,0,7),
(1819,0,8),
(1820,0,11),
(1823,0,1),
(1824,0,6),
(1825,0,8),
(1826,0,1),
(1827,0,2),
(1828,0,3),
(1829,0,6),
(1830,0,8),
(1833,0,4),
(1834,0,6),
(1835,0,8),
(1836,0,9),
(1837,0,11),
(1840,0,6),
(1867,0,2),
(1868,0,3),
(1869,0,6),
(1897,0,1),
(1898,0,2),
(1899,0,3),
(1900,0,4),
(1901,0,5),
(1902,0,6),
(1903,0,11),
(1904,0,2),
(1905,0,3),
(1906,0,4),
(1907,0,5),
(1908,0,6),
(1909,0,1),
(1910,0,2),
(1911,0,3),
(1912,0,4),
(1913,0,5),
(1914,0,6),
(1915,0,7),
(1916,0,8),
(1917,0,11),
(1918,0,7),
(1919,0,1),
(1920,0,2),
(1921,0,6),
(1922,0,11),
(1923,0,12),
(1924,314,1),
(1925,314,2),
(1926,314,3),
(1927,314,6),
(1928,314,11),
(1929,314,12),
(1930,0,1),
(1931,0,2),
(1932,0,3),
(1933,0,4),
(1934,0,5),
(1935,0,6),
(1936,0,7),
(1937,0,8),
(1938,0,11),
(1939,0,1),
(1940,0,2),
(1941,0,3),
(1942,0,4),
(1943,0,5),
(1944,0,6),
(1945,0,7),
(1946,0,8),
(1947,0,11),
(1948,0,1),
(1949,0,2),
(1950,0,3),
(1951,0,4),
(1952,0,6),
(1953,0,11),
(1954,0,1),
(1955,0,3),
(1956,0,4),
(1957,0,5),
(1958,0,7),
(1959,0,1),
(1960,0,2),
(1961,0,3),
(1962,0,6),
(1963,0,10),
(1964,0,11),
(1965,0,1),
(1966,0,2),
(1967,0,3),
(1968,0,4),
(1969,0,6),
(1970,0,8),
(1971,0,11),
(1972,0,6),
(1973,0,7),
(1974,0,8),
(1975,0,10),
(1976,0,11),
(1977,0,11),
(1978,0,11),
(1979,0,1),
(1980,0,2),
(1981,0,3),
(1982,0,4),
(1983,0,6),
(1984,0,10),
(1985,0,11),
(1986,0,12),
(1987,0,4),
(1988,0,5),
(1989,0,7),
(1990,0,8),
(1991,0,9),
(1992,0,10),
(1993,0,11),
(1994,0,2),
(1995,0,3),
(1996,0,4),
(1997,0,6),
(1998,0,1),
(1999,0,2),
(2000,0,3),
(2001,0,4),
(2002,0,6),
(2003,0,7),
(2004,0,8),
(2005,0,11),
(2006,0,12),
(2007,0,1),
(2008,0,3),
(2009,0,6),
(2010,0,4),
(2011,0,6),
(2012,0,8),
(2013,0,1),
(2014,0,2),
(2015,0,3),
(2016,0,6),
(2017,0,8),
(2018,0,10),
(2019,0,11),
(2020,0,1),
(2021,0,2),
(2022,0,3),
(2023,0,4),
(2024,0,6),
(2025,0,7),
(2026,0,8),
(2027,0,11),
(2028,0,3),
(2029,0,4),
(2030,0,6),
(2031,0,8),
(2032,0,11),
(2033,0,1),
(2034,0,2),
(2035,0,3),
(2036,0,8),
(2037,0,11),
(2038,0,12),
(2039,0,1),
(2040,0,2),
(2041,0,3),
(2042,0,4),
(2043,0,5),
(2044,0,6),
(2045,0,7),
(2046,0,8),
(2047,0,9),
(2048,0,10),
(2049,0,11),
(2050,0,12),
(2051,0,1),
(2052,0,3),
(2053,0,4),
(2054,0,6),
(2055,0,11),
(2056,0,1),
(2057,0,2),
(2058,0,3),
(2059,0,6),
(2060,0,11),
(2061,0,1),
(2062,0,2),
(2063,0,10),
(2064,0,11),
(2065,0,1),
(2066,0,2),
(2067,0,3),
(2068,0,4),
(2069,0,5),
(2070,0,6),
(2071,0,7),
(2072,0,8),
(2073,0,9),
(2074,0,10),
(2075,0,11),
(2076,0,12),
(2077,0,1),
(2078,0,6),
(2079,0,8),
(2080,0,1),
(2081,0,4),
(2082,0,6),
(2083,0,8),
(2092,0,1),
(2093,0,2),
(2094,0,3),
(2095,0,4),
(2096,0,5),
(2097,0,6),
(2098,0,8),
(2099,0,10),
(2100,0,11),
(2101,0,1),
(2102,0,4),
(2103,0,8),
(2104,0,1),
(2105,0,2),
(2106,0,3),
(2107,0,4),
(2108,0,5),
(2109,0,6),
(2110,0,7),
(2111,0,8),
(2112,0,9),
(2113,0,10),
(2114,0,11),
(2115,0,12),
(2116,0,2),
(2117,0,3),
(2118,0,6),
(2119,0,8),
(2123,0,1),
(2124,0,2),
(2125,0,3),
(2126,0,6),
(2127,0,8),
(2128,0,9),
(2129,0,11),
(2130,0,1),
(2131,0,2),
(2132,0,3),
(2133,0,4),
(2134,0,5),
(2135,0,6),
(2136,0,7),
(2137,0,8),
(2138,0,9),
(2139,0,11),
(2140,0,12),
(2141,0,1),
(2142,0,2),
(2143,0,3),
(2144,0,4),
(2145,0,6),
(2146,0,1),
(2147,0,4),
(2148,0,5),
(2149,0,8),
(2150,0,2),
(2151,0,3),
(2152,0,4),
(2153,0,5),
(2154,0,7),
(2155,0,8),
(2156,0,9),
(2157,0,10),
(2158,0,11),
(2159,0,12),
(2160,0,1),
(2161,0,4),
(2162,0,6),
(2163,0,8),
(2164,0,9),
(2165,0,11),
(2166,0,3),
(2167,0,6),
(2168,0,7),
(2169,0,1),
(2170,0,2),
(2171,0,6),
(2172,0,12),
(2173,0,1),
(2174,0,3),
(2175,0,11);

INSERT INTO `DELETE_kontragent_poslyga` VALUES 
(2176,0,1),
(2177,0,2),
(2178,0,3),
(2179,0,6),
(2180,0,12),
(2181,0,1),
(2182,0,2),
(2183,0,3),
(2184,0,6),
(2185,0,12),
(2186,0,2),
(2187,0,3),
(2188,0,6),
(2189,0,8),
(2190,0,12),
(2191,0,5),
(2192,0,8),
(2193,0,5),
(2194,0,8),
(2195,0,5),
(2196,0,8),
(2197,0,1),
(2198,0,3),
(2199,0,8),
(2200,0,2),
(2201,0,6),
(2202,0,9),
(2203,0,12),
(2204,0,3),
(2205,0,6),
(2206,0,11),
(2207,0,3),
(2208,0,6),
(2209,0,11),
(2210,0,1),
(2211,0,3),
(2212,0,5),
(2213,0,11),
(2214,0,12),
(2215,0,1),
(2216,0,3),
(2217,0,5),
(2218,0,8),
(2219,0,9),
(2220,0,11),
(2221,0,12),
(2222,0,1),
(2223,0,2),
(2224,0,3),
(2225,0,4),
(2226,0,5),
(2227,0,6),
(2228,0,7),
(2229,0,8),
(2230,0,9),
(2231,0,10),
(2232,0,11),
(2233,0,12),
(2234,0,1),
(2235,0,2),
(2236,0,6),
(2237,0,8),
(2238,0,11),
(2239,0,1),
(2240,0,2),
(2241,0,3),
(2242,0,4),
(2243,0,6),
(2244,0,7),
(2245,0,8),
(2246,0,9),
(2247,0,10),
(2248,0,11),
(2249,0,12),
(2250,0,2),
(2251,0,3),
(2252,0,4),
(2253,0,6),
(2254,0,7),
(2255,0,8),
(2256,0,9),
(2257,0,11),
(2258,0,12),
(2259,0,1),
(2260,0,1),
(2261,0,2),
(2262,0,2),
(2263,0,3),
(2264,0,3),
(2265,0,4),
(2266,0,4),
(2267,0,5),
(2268,0,5),
(2269,0,6),
(2270,0,6),
(2271,0,8),
(2272,0,8),
(2273,0,10),
(2274,0,10),
(2275,0,11),
(2276,0,11),
(2277,0,12),
(2278,0,12),
(2279,0,1),
(2280,0,2),
(2281,0,3),
(2282,0,4),
(2283,0,6),
(2284,0,7),
(2285,0,8),
(2286,0,9),
(2287,0,10),
(2288,0,11),
(2289,0,12),
(2290,0,1),
(2291,0,2),
(2292,0,3),
(2293,0,4),
(2294,0,6),
(2295,0,7),
(2296,0,8),
(2297,0,9),
(2298,0,10),
(2299,0,11),
(2300,0,12),
(2301,0,1),
(2302,0,2),
(2303,0,3),
(2304,0,6),
(2305,0,1),
(2306,0,2),
(2307,0,3),
(2308,0,4),
(2309,0,6),
(2310,0,7),
(2311,0,9),
(2312,0,10),
(2313,0,11),
(2314,0,12),
(2315,0,2),
(2316,0,3),
(2317,0,5),
(2318,0,9),
(2319,0,11),
(2320,0,1),
(2321,0,4),
(2322,0,7),
(2323,0,11),
(2324,0,1),
(2325,0,2),
(2326,0,4),
(2327,0,1),
(2328,0,2),
(2329,0,3),
(2330,0,4),
(2331,0,5),
(2332,0,6),
(2333,0,7),
(2334,0,8),
(2335,0,9),
(2336,0,10),
(2337,0,11),
(2338,0,12),
(2339,0,1),
(2340,0,2),
(2341,0,3),
(2342,0,4),
(2343,0,6),
(2344,0,7),
(2345,0,11),
(2346,0,12),
(2347,0,1),
(2348,0,2),
(2349,0,4),
(2350,0,6),
(2351,0,7),
(2352,0,8),
(2353,0,10),
(2354,0,11),
(2355,0,2),
(2356,0,3),
(2357,0,4),
(2358,0,5),
(2359,0,6),
(2360,0,7),
(2361,0,11),
(2362,0,12),
(2363,0,2),
(2364,0,3),
(2365,0,4),
(2366,0,5),
(2367,0,6),
(2368,0,7),
(2369,0,11),
(2370,0,12),
(2371,0,1),
(2372,0,2),
(2373,0,3),
(2374,0,4),
(2375,0,6),
(2376,0,7),
(2377,0,8),
(2378,0,9),
(2379,0,11),
(2380,0,12),
(2381,0,1),
(2382,0,5),
(2383,0,7),
(2384,0,8),
(2385,0,11),
(2386,0,12),
(2387,0,1),
(2388,0,4),
(2389,0,10),
(2390,0,1),
(2391,0,2),
(2392,0,3),
(2393,0,11),
(2394,0,1),
(2395,0,2),
(2396,0,3),
(2397,0,4),
(2398,0,6),
(2399,0,7),
(2400,0,9),
(2401,0,10),
(2402,0,11),
(2403,0,12),
(2404,0,1),
(2405,0,2),
(2406,0,4),
(2407,0,1),
(2408,0,2),
(2409,0,3),
(2410,0,4),
(2411,0,6),
(2412,0,7),
(2413,0,9),
(2414,0,11),
(2415,0,12),
(2416,0,1),
(2417,0,2),
(2418,0,4),
(2419,0,8),
(2420,0,10),
(2421,0,12),
(2422,0,1),
(2423,0,7),
(2424,0,1),
(2425,0,2),
(2426,0,4),
(2427,0,6),
(2428,0,7),
(2429,0,11),
(2430,0,12),
(2431,0,1),
(2432,0,5),
(2433,0,6),
(2434,0,11),
(2435,0,12),
(2436,0,1),
(2437,0,2),
(2438,0,3),
(2439,0,4),
(2440,0,6),
(2441,0,10),
(2442,0,11),
(2443,0,12),
(2444,0,1),
(2445,0,2),
(2446,0,3),
(2447,0,4),
(2448,0,6),
(2449,0,8),
(2450,0,10),
(2451,0,11),
(2452,0,1),
(2453,0,2),
(2454,0,3),
(2455,0,4),
(2456,0,6),
(2457,0,7),
(2458,0,8),
(2459,0,11),
(2460,0,12),
(2461,0,1),
(2462,0,2),
(2463,0,3),
(2464,0,4),
(2465,0,6),
(2466,0,8),
(2467,0,9),
(2468,0,11),
(2469,0,12),
(2470,0,1),
(2471,0,2),
(2472,0,3),
(2473,0,4),
(2474,0,6),
(2475,0,9),
(2476,0,11),
(2477,0,1),
(2478,0,8),
(2479,0,11),
(2480,0,1),
(2481,0,4),
(2482,0,6),
(2483,0,1),
(2484,0,2),
(2485,0,3),
(2486,0,6),
(2487,0,7),
(2488,0,11),
(2489,0,12),
(2490,0,1),
(2491,0,2),
(2492,0,3),
(2493,0,6),
(2494,0,7),
(2495,0,8),
(2496,0,9),
(2497,0,10),
(2498,0,11),
(2499,0,12),
(2500,0,1),
(2501,0,2),
(2502,0,3),
(2503,0,4),
(2504,0,8),
(2505,0,12),
(2506,0,1),
(2507,0,4),
(2508,0,6),
(2509,0,7),
(2510,0,8),
(2511,0,11),
(2512,0,12),
(2513,0,1),
(2514,0,4),
(2515,0,6),
(2516,0,7),
(2517,0,8),
(2518,0,11),
(2519,0,12),
(2520,0,1),
(2521,0,2),
(2522,0,3),
(2523,0,6),
(2524,0,7),
(2525,0,8),
(2526,0,9),
(2527,0,10),
(2528,0,11),
(2529,0,12),
(2530,0,1),
(2531,0,2),
(2532,0,3),
(2533,0,4),
(2534,0,6),
(2535,0,7),
(2536,0,8),
(2537,0,11),
(2538,0,1),
(2539,0,2),
(2540,0,3),
(2541,0,4),
(2542,0,8),
(2543,0,11),
(2544,0,1),
(2545,0,2),
(2546,0,3),
(2547,0,4),
(2548,0,6),
(2549,0,7),
(2550,0,8),
(2551,0,9),
(2552,0,10),
(2553,0,11),
(2554,0,12),
(2555,0,1),
(2556,0,2),
(2557,0,3),
(2558,0,4),
(2559,0,8),
(2560,0,1),
(2561,0,2),
(2562,0,3),
(2563,0,4),
(2564,0,6),
(2565,0,7),
(2566,0,8),
(2567,0,9),
(2568,0,10),
(2569,0,11),
(2570,0,12),
(2571,0,1),
(2572,0,2),
(2573,0,3),
(2574,0,4),
(2575,0,6),
(2576,0,7),
(2577,0,8),
(2578,0,9),
(2579,0,10),
(2580,0,11),
(2581,0,12),
(2582,0,1),
(2583,0,2),
(2584,0,3),
(2585,0,4),
(2586,0,5),
(2587,0,6),
(2588,0,7),
(2589,0,8),
(2590,0,10),
(2591,0,11),
(2592,0,12),
(2593,0,1),
(2594,0,2),
(2595,0,3),
(2596,0,4),
(2597,0,6),
(2598,0,7),
(2599,0,8),
(2600,0,9),
(2601,0,10),
(2602,0,11),
(2603,0,12),
(2604,0,1),
(2605,0,2),
(2606,0,3),
(2607,0,4),
(2608,0,6),
(2609,0,7),
(2610,0,8),
(2611,0,9),
(2612,0,10),
(2613,0,11),
(2614,0,12),
(2615,0,1),
(2616,0,2),
(2617,0,3),
(2618,0,4),
(2619,0,6),
(2620,0,7),
(2621,0,8),
(2622,0,9),
(2623,0,10),
(2624,0,11),
(2625,0,12),
(2626,0,1),
(2627,0,2),
(2628,0,3),
(2629,0,4),
(2630,0,5),
(2631,0,6),
(2632,0,7),
(2633,0,8),
(2634,0,10),
(2635,0,11),
(2636,0,12),
(2637,0,1),
(2638,0,2),
(2639,0,3),
(2640,0,6),
(2641,0,7),
(2642,0,8),
(2643,0,11),
(2644,0,12),
(2645,0,1),
(2646,0,2),
(2647,0,4),
(2648,0,8),
(2649,0,1),
(2650,0,6),
(2651,0,2),
(2652,0,3),
(2653,0,7),
(2654,0,8),
(2655,0,1),
(2656,0,4),
(2657,0,6),
(2658,0,11),
(2659,0,1),
(2660,0,2),
(2661,0,3),
(2662,0,4),
(2663,0,5),
(2664,0,6),
(2665,0,7),
(2666,0,8),
(2667,0,9),
(2668,0,10),
(2669,0,11),
(2670,0,12),
(2671,0,1),
(2672,0,2),
(2673,0,3),
(2674,0,5),
(2675,0,6);

INSERT INTO `DELETE_kontragent_poslyga` VALUES 
(2676,0,1),
(2677,0,2),
(2678,0,3),
(2679,0,4),
(2680,0,5),
(2681,0,6),
(2682,0,7),
(2683,0,8),
(2684,0,9),
(2685,0,10),
(2686,0,11),
(2687,0,12),
(2688,0,1),
(2689,0,2),
(2690,0,4),
(2691,0,6),
(2692,0,11),
(2693,0,1),
(2694,0,2),
(2695,0,3),
(2696,0,4);

DROP TABLE IF EXISTS `DELETE_lang_articles`;

CREATE TABLE `DELETE_lang_articles` (
  `id` smallint(4) NOT NULL auto_increment,
  `url` varchar(255) collate utf8_unicode_ci NOT NULL,
  `type` smallint(4) NOT NULL default '0',
  `pidtype` smallint(4) NOT NULL default '0',
  `script_verh` text collate utf8_unicode_ci NOT NULL,
  `script_nuz` text collate utf8_unicode_ci NOT NULL,
  `menu_derevo` mediumint(5) NOT NULL default '0',
  `comentari` smallint(1) NOT NULL default '1',
  `title_uk` varchar(255) collate utf8_unicode_ci NOT NULL,
  `keywords_uk` text collate utf8_unicode_ci NOT NULL,
  `description_uk` text collate utf8_unicode_ci NOT NULL,
  `korotko_uk` text collate utf8_unicode_ci NOT NULL,
  `text_uk` text collate utf8_unicode_ci NOT NULL,
  `title_ru` varchar(255) collate utf8_unicode_ci NOT NULL,
  `keywords_ru` text collate utf8_unicode_ci NOT NULL,
  `description_ru` text collate utf8_unicode_ci NOT NULL,
  `korotko_ru` text collate utf8_unicode_ci NOT NULL,
  `text_ru` text collate utf8_unicode_ci NOT NULL,
  `title_en` varchar(255) collate utf8_unicode_ci NOT NULL,
  `keywords_en` text collate utf8_unicode_ci NOT NULL,
  `description_en` text collate utf8_unicode_ci NOT NULL,
  `korotko_en` text collate utf8_unicode_ci NOT NULL,
  `text_en` text collate utf8_unicode_ci NOT NULL,
  `time` int(10) NOT NULL default '0',
  `reklama` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `url` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci PACK_KEYS=0;

DROP TABLE IF EXISTS `DELETE_lang_menu_derevo`;

CREATE TABLE `DELETE_lang_menu_derevo` (
  `id` mediumint(5) NOT NULL auto_increment,
  `url` varchar(255) collate utf8_unicode_ci NOT NULL default '/',
  `fathercode` mediumint(6) NOT NULL default '0',
  `name_uk` varchar(120) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(120) collate utf8_unicode_ci NOT NULL,
  `name_en` varchar(120) collate utf8_unicode_ci NOT NULL,
  `sort` smallint(4) NOT NULL default '0',
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `DELETE_lang_pidtypes`;

CREATE TABLE `DELETE_lang_pidtypes` (
  `id` smallint(4) NOT NULL auto_increment,
  `type_id` smallint(4) NOT NULL default '0',
  `uk` varchar(60) collate utf8_unicode_ci NOT NULL,
  `ru` varchar(60) collate utf8_unicode_ci NOT NULL,
  `en` varchar(60) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Підтипи до табл lang_articles (стовпчик pidtype)';

DROP TABLE IF EXISTS `DELETE_lang_types`;

CREATE TABLE `DELETE_lang_types` (
  `id` smallint(4) NOT NULL auto_increment,
  `uk` varchar(60) collate utf8_unicode_ci NOT NULL,
  `ru` varchar(60) collate utf8_unicode_ci NOT NULL,
  `en` varchar(60) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='типи для таблиці lang_articles (стовпчик type)';

DROP TABLE IF EXISTS `DELETE_menu`;

CREATE TABLE `DELETE_menu` (
  `id` smallint(5) NOT NULL auto_increment,
  `fathercode` smallint(5) NOT NULL default '0',
  `sort` smallint(5) NOT NULL default '0',
  `url` varchar(255) collate utf8_unicode_ci NOT NULL,
  `name_uk` varchar(40) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(40) collate utf8_unicode_ci NOT NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Меню сайту';

DROP TABLE IF EXISTS `DELETE_pictures_adds`;

CREATE TABLE `DELETE_pictures_adds` (
  `id` smallint(4) NOT NULL auto_increment,
  `name` varchar(40) collate utf8_unicode_ci NOT NULL,
  `alt` varchar(120) collate utf8_unicode_ci NOT NULL,
  `w` smallint(4) NOT NULL default '200',
  `h` smallint(4) NOT NULL default '200',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Таблиця для того щоб добавляти катринки';

INSERT INTO `DELETE_pictures_adds` VALUES 
(12,'8.jpg','',1920,1080);

DROP TABLE IF EXISTS `DELETE_realizatsia`;

CREATE TABLE `DELETE_realizatsia` (
  `id` mediumint(5) NOT NULL auto_increment,
  `id_kontragent` varchar(5) collate utf8_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `time` int(10) NOT NULL default '0',
  `price_check` decimal(6,2) NOT NULL default '0.00',
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1738 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Документи Реалізація товарів і послуг ';

INSERT INTO `DELETE_realizatsia` VALUES 
(1,'1','2016-08-30',1472545975,407.00,'0'),
(2,'2','2016-08-30',1472549016,572.00,'0'),
(3,'5','2016-08-30',1472549844,1683.00,'0'),
(4,'7','2016-08-30',1472550307,427.00,'0'),
(5,'11','2016-08-30',1472551067,49.00,'0'),
(6,'13','2016-08-30',1472551500,437.00,'0'),
(7,'16','2016-08-30',1472551860,78.00,'0'),
(8,'17','2016-08-30',1472551974,1727.00,'0'),
(9,'19','2016-08-30',1472553202,1688.00,'0'),
(10,'21','2016-08-30',1472553382,487.00,'0'),
(11,'23','2016-08-30',1472553839,1285.00,'0'),
(12,'24','2016-08-30',1472553972,2668.00,'0'),
(13,'25','2016-08-30',1472554197,5219.00,'0'),
(14,'25','2016-08-30',1472554221,200.00,'0'),
(15,'26','2016-08-30',1472555481,2231.00,'0'),
(16,'32','2016-08-30',1472556042,466.00,'0'),
(17,'33','2016-08-30',1472556180,2022.00,'0'),
(18,'37','2016-08-30',1472556572,281.00,'0'),
(19,'38','2016-08-30',1472556685,660.00,'0'),
(20,'41','2016-08-30',1472556974,999.00,'0'),
(21,'43','2016-08-30',1472561575,703.00,'0'),
(22,'46','2016-08-30',1472562291,1465.00,'0'),
(23,'54','2016-08-30',1472564567,141.00,'0'),
(24,'56','2016-08-30',1472564784,272.00,'0'),
(25,'58','2016-08-30',1472565116,136.00,'0'),
(26,'60','2016-08-30',1472565318,698.00,'0'),
(27,'62','2016-08-30',1472565584,126.00,'0'),
(28,'63','2016-08-30',1472565691,698.00,'0'),
(29,'65','2016-08-30',1472565869,1959.00,'0'),
(30,'67','2016-08-30',1472566090,543.00,'0'),
(31,'68','2016-08-30',1472566337,2008.00,'0'),
(32,'72','2016-08-30',1472568164,475.00,'0'),
(33,'74','2016-08-30',1472568381,223.00,'0'),
(34,'79','2016-08-30',1472569005,296.00,'0'),
(35,'81','2016-08-30',1472569210,2663.00,'0'),
(36,'83','2016-08-30',1472569416,301.00,'0'),
(37,'88','2016-08-30',1472569934,2425.00,'0'),
(38,'89','2016-08-30',1472570043,1256.00,'0'),
(39,'90','2016-08-30',1472570152,991.00,'0'),
(40,'91','2016-08-30',1472566952,5088.00,'0'),
(41,'92','2016-08-30',1472567049,262.00,'0'),
(42,'93','2016-08-30',1472567146,2959.00,'0'),
(43,'94','2016-08-30',1472567249,1630.00,'0'),
(44,'96','2016-08-30',1472567406,315.00,'0'),
(45,'98','2016-08-30',1472567570,1882.00,'0'),
(46,'99','2016-08-30',1472567679,951.00,'0'),
(47,'102','2016-08-30',1472567896,170.00,'0'),
(48,'104','2016-08-30',1472568182,1649.00,'0'),
(49,'105','2016-08-30',1472568250,190.00,'0'),
(50,'108','2016-08-30',1472568528,514.00,'0'),
(51,'109','2016-08-30',1472568598,194.00,'0'),
(52,'110','2016-08-30',1472568711,349.00,'0'),
(53,'111','2016-08-30',1472568792,1009.00,'0'),
(54,'112','2016-08-30',1472568887,146.00,'0'),
(55,'114','2016-08-30',1472569047,631.00,'0'),
(56,'115','2016-08-30',1472569189,4093.00,'0'),
(57,'116','2016-08-30',1472569283,485.00,'0'),
(58,'118','2016-08-30',1472569422,29.00,'0'),
(59,'122','2016-08-30',1472569753,388.00,'0'),
(60,'124','2016-08-30',1472569980,417.00,'0'),
(61,'125','2016-08-30',1472570062,514.00,'0'),
(62,'126','2016-08-30',1472570512,179.00,'0'),
(63,'128','2016-08-31',1472625613,776.00,'0'),
(64,'129','2016-08-31',1472625704,262.00,'0'),
(65,'130','2016-08-31',1472625889,4396.00,'0'),
(66,'131','2016-08-31',1472626016,272.00,'0'),
(67,'132','2016-08-31',1472626242,1556.00,'0'),
(68,'133','2016-08-31',1472626311,466.00,'0'),
(69,'135','2016-08-31',1472626479,1271.00,'0'),
(70,'136','2016-08-31',1472626841,1285.00,'0'),
(71,'137','2016-08-31',1472627013,3007.00,'0'),
(72,'138','2016-08-31',1472627113,1989.00,'0'),
(73,'139','2016-08-31',1472627192,1693.00,'0'),
(74,'140','2016-08-31',1472627297,922.00,'0'),
(75,'143','2016-08-31',1472627533,5015.00,'0'),
(76,'144','2016-08-31',1472627617,2532.00,'0'),
(77,'148','2016-08-31',1472627970,204.00,'0'),
(78,'149','2016-08-31',1472628061,3555.00,'0'),
(79,'150','2016-08-31',1472628360,1387.00,'0'),
(80,'151','2016-08-31',1472628437,1368.00,'0'),
(81,'152','2016-08-31',1472628627,1459.00,'0'),
(82,'153','2016-08-31',1472628712,795.00,'0'),
(83,'154','2016-08-31',1472628790,2086.00,'0'),
(84,'155','2016-08-31',1472629251,969.00,'0'),
(85,'156','2016-08-31',1472629390,1814.00,'0'),
(86,'159','2016-08-31',1472629813,987.00,'0'),
(87,'160','2016-08-31',1472629951,1436.00,'0'),
(88,'163','2016-08-31',1472630353,354.00,'0'),
(89,'176','2016-08-31',1472631605,6506.00,'0'),
(90,'177','2016-08-31',1472631665,146.00,'0'),
(91,'178','2016-08-31',1472631751,340.00,'0'),
(92,'65','2016-08-31',1472631877,247.00,'0'),
(93,'180','2016-08-31',1472632018,272.00,'0'),
(94,'182','2016-08-31',1472632413,427.00,'0'),
(95,'183','2016-08-31',1472632644,4598.00,'0'),
(96,'184','2016-08-31',1472632710,291.00,'0'),
(97,'186','2016-08-31',1472632838,291.00,'0'),
(98,'187','2016-08-31',1472632935,3563.00,'0'),
(99,'188','2016-08-31',1472633059,4234.00,'0'),
(100,'191','2016-08-31',1472633462,1562.00,'0'),
(101,'193','2016-08-31',1472633602,2173.00,'0'),
(102,'196','2016-08-31',1472634536,1251.00,'0'),
(103,'198','2016-08-31',1472634703,989.00,'0'),
(104,'149','2016-08-31',1472634732,150.00,'0'),
(105,'151','2016-08-31',1472635418,213.00,'0'),
(106,'203','2016-08-31',1472636746,5548.00,'0'),
(107,'204','2016-08-31',1472636823,1319.00,'0'),
(108,'206','2016-08-31',1472637018,485.00,'0'),
(109,'209','2016-08-31',1472638249,1749.00,'0'),
(110,'210','2016-08-31',1472638321,1237.00,'0'),
(111,'212','2016-08-31',1472638473,2155.00,'0'),
(112,'214','2016-08-31',1472638689,393.00,'0'),
(113,'215','2016-08-31',1472638782,2586.00,'0'),
(114,'219','2016-08-31',1472639067,2483.00,'0'),
(115,'220','2016-08-31',1472639136,1366.00,'0'),
(116,'187','2016-08-31',1472639275,291.00,'0'),
(117,'222','2016-08-31',1472639309,698.00,'0'),
(118,'223','2016-08-31',1472639409,194.00,'0'),
(119,'228','2016-08-31',1472639872,238.00,'0'),
(120,'15','2016-08-31',1472643876,194.00,'0'),
(121,'91','2016-08-31',1472650739,233.00,'0'),
(122,'31','2016-08-31',1472653434,155.00,'0'),
(123,'215','2016-08-31',1472656247,194.00,'0'),
(124,'79','2016-09-01',1472709396,49.00,'0'),
(125,'70','2016-09-01',1472723176,204.00,'0'),
(126,'187','2016-09-01',1472728172,213.00,'0'),
(127,'187','2016-09-01',1472728248,49.00,'0'),
(128,'230','2016-09-01',1472730699,485.00,'0'),
(129,'167','2016-09-01',1472731378,78.00,'0'),
(130,'19','2016-09-01',1472741467,175.00,'0'),
(131,'191','2016-09-01',1472743456,485.00,'0'),
(132,'125','2016-09-01',1472750818,272.00,'0'),
(133,'212','2016-09-02',1472799137,194.00,'0'),
(134,'68','2016-09-02',1472804846,310.00,'0'),
(135,'137','2016-09-02',1472807295,272.00,'0'),
(136,'232','2016-09-02',1472814042,650.00,'0'),
(137,'68','2016-09-02',1472816104,437.00,'0'),
(138,'96','2016-09-02',1472816875,194.00,'0'),
(139,'137','2016-09-02',1472824416,136.00,'0'),
(140,'63','2016-09-02',1472827860,213.00,'0'),
(141,'171','2016-09-03',1472883974,514.00,'0'),
(142,'173','2016-09-03',1472888913,485.00,'0'),
(143,'163','2016-09-03',1472895881,388.00,'0'),
(144,'57','2016-09-03',1472896779,155.00,'0'),
(145,'231','2016-09-03',1472896985,514.00,'0'),
(146,'72','2016-09-03',1472898370,470.00,'0'),
(147,'15','2016-09-03',1472899904,233.00,'0'),
(148,'25','2016-09-03',1472902541,238.00,'0'),
(149,'65','2016-09-03',1472904181,310.00,'0'),
(150,'223','2016-09-03',1472904906,175.00,'0'),
(151,'130','2016-09-03',1472904974,335.00,'0'),
(152,'36','2016-09-03',1472906359,199.00,'0'),
(153,'19','2016-09-03',1472906928,194.00,'0'),
(154,'17','2016-09-03',1472916235,252.00,'0'),
(155,'233','2016-09-04',1472966456,553.00,'0'),
(156,'153','2016-09-05',1473062211,306.00,'0'),
(157,'152','2016-09-05',1473074530,155.00,'0'),
(158,'230','2016-09-05',1473079640,155.00,'0'),
(159,'198','2016-09-05',1473082410,150.00,'0'),
(160,'31','2016-09-05',1473085928,213.00,'0'),
(161,'60','2016-09-05',1473086136,194.00,'0'),
(162,'176','2016-09-06',1473151300,504.00,'0'),
(163,'204','2016-09-06',1473154471,223.00,'0'),
(164,'33','2016-09-06',1473160647,179.00,'0'),
(165,'54','2016-09-06',1473165326,155.00,'0'),
(166,'150','2016-09-06',1473174689,243.00,'0'),
(167,'107','2016-09-07',1473238443,504.00,'0'),
(168,'46','2016-09-07',1473239639,175.00,'0'),
(169,'77','2016-09-07',1473241115,407.00,'0'),
(170,'156','2016-09-07',1473241260,718.00,'0'),
(171,'111','2016-09-07',1473247170,310.00,'0'),
(172,'81','2016-09-07',1473251751,175.00,'0'),
(173,'46','2016-09-07',1473252265,165.00,'0'),
(174,'239','2016-09-07',1473256797,407.00,'0'),
(175,'26','2016-09-07',1473260011,243.00,'0'),
(176,'111','2016-09-08',1473315635,136.00,'0'),
(177,'77','2016-09-08',1473315778,563.00,'0'),
(178,'227','2016-09-08',1473327031,310.00,'0'),
(179,'175','2016-09-08',1473332747,155.00,'0'),
(180,'139','2016-09-08',1473340027,344.00,'0'),
(181,'126','2016-09-08',1473355020,204.00,'0'),
(182,'131','2016-09-09',1473403093,301.00,'0'),
(183,'26','2016-09-09',1473405792,184.00,'0'),
(184,'209','2016-09-09',1473414238,572.00,'0'),
(185,'37','2016-09-09',1473417748,238.00,'0'),
(186,'106','2016-09-10',1473494695,68.00,'0'),
(187,'138','2016-09-10',1473498973,150.00,'0'),
(188,'143','2016-09-10',1473504398,770.00,'0'),
(189,'203','2016-09-10',1473505294,67.00,'0'),
(190,'203','2016-09-10',1473505314,171.00,'0'),
(191,'174','2016-09-10',1473515705,68.00,'0'),
(192,'91','2016-09-13',1473751772,428.00,'0'),
(193,'183','2016-09-13',1473760254,49.00,'0'),
(194,'115','2016-09-13',1473764990,194.00,'0'),
(195,'90','2016-09-13',1473770213,213.00,'0'),
(196,'176','2016-09-13',1473772632,190.00,'0'),
(197,'34','2016-09-13',1473774874,286.00,'0'),
(198,'34','2016-09-13',1473774926,68.00,'0'),
(199,'9','2016-09-13',1473778505,529.00,'0'),
(200,'25','2016-09-14',1473843129,258.00,'0'),
(201,'79','2016-09-14',1473852189,616.00,'0'),
(202,'56','2016-09-14',1473859926,146.00,'0'),
(203,'48','2016-09-14',1473861524,68.00,'0'),
(204,'21','2016-09-15',1473918689,194.00,'0'),
(205,'101','2016-09-15',1473934154,340.00,'0'),
(206,'219','2016-09-15',1473945769,378.00,'0'),
(207,'210','2016-09-15',1473947636,175.00,'0'),
(208,'75','2016-09-15',1473947899,272.00,'0'),
(209,'131','2016-09-15',1473960831,155.00,'0'),
(210,'193','2016-09-16',1474018950,126.00,'0'),
(211,'207','2016-09-16',1474023637,1591.00,'0'),
(212,'175','2016-09-16',1474029457,204.00,'0'),
(213,'112','2016-09-16',1474038433,291.00,'0'),
(214,'252','2016-09-17',1474089133,340.00,'0'),
(215,'248','2016-09-17',1474094632,611.00,'0'),
(216,'21','2016-09-17',1474100492,131.00,'0'),
(217,'209','2016-09-17',1474101501,194.00,'0'),
(218,'143','2016-09-17',1474104353,238.00,'0'),
(219,'44','2016-09-17',1474113891,470.00,'0'),
(220,'112','2016-09-17',1474113981,141.00,'0'),
(221,'81','2016-09-17',1474118909,272.00,'0'),
(222,'174','2016-09-17',1474123833,310.00,'0'),
(223,'119','2016-09-19',1474281372,194.00,'0'),
(224,'66','2016-09-19',1474291641,126.00,'0'),
(225,'67','2016-09-20',1474357031,223.00,'0'),
(226,'214','2016-09-20',1474365109,49.00,'0'),
(227,'173','2016-09-20',1474371355,267.00,'0'),
(228,'183','2016-09-20',1474377565,150.00,'0'),
(229,'48','2016-09-20',1474379485,310.00,'0'),
(230,'38','2016-09-20',1474382327,213.00,'0'),
(231,'191','2016-09-20',1474383984,97.00,'0'),
(232,'152','2016-09-20',1474386343,175.00,'0'),
(233,'19','2016-09-20',1474386538,175.00,'0'),
(234,'176','2016-09-21',1474444259,242.00,'0'),
(235,'203','2016-09-21',1474450964,318.00,'0'),
(236,'148','2016-09-21',1474462073,272.00,'0'),
(237,'215','2016-09-21',1474467924,155.00,'0'),
(238,'188','2016-09-21',1474468770,223.00,'0'),
(239,'66','2016-09-21',1474470439,262.00,'0'),
(240,'257','2016-09-22',1474528023,194.00,'0'),
(241,'257','2016-09-22',1474533014,223.00,'0'),
(242,'231','2016-09-22',1474537964,126.00,'0'),
(243,'132','2016-09-22',1474539166,475.00,'0'),
(244,'94','2016-09-22',1474544327,854.00,'0'),
(245,'188','2016-09-22',1474550713,306.00,'0'),
(246,'133','2016-09-23',1474615512,243.00,'0'),
(247,'149','2016-09-23',1474617928,291.00,'0'),
(248,'149','2016-09-23',1474621791,291.00,'0'),
(249,'193','2016-09-23',1474632611,170.00,'0'),
(250,'246','2016-09-24',1474697936,679.00,'0'),
(251,'247','2016-09-24',1474697985,485.00,'0'),
(252,'73','2016-09-24',1474702360,68.00,'0'),
(253,'193','2016-09-24',1474702498,340.00,'0'),
(254,'188','2016-09-24',1474706912,437.00,'0'),
(255,'47','2016-09-24',1474715903,184.00,'0'),
(256,'215','2016-09-24',1474719478,146.00,'0'),
(257,'99','2016-09-24',1474733953,228.00,'0'),
(258,'231','2016-09-26',1474881352,199.00,'0'),
(259,'231','2016-09-26',1474881409,184.00,'0'),
(260,'215','2016-09-26',1474884506,1048.00,'0'),
(261,'34','2016-09-26',1474887868,243.00,'0'),
(262,'227','2016-09-26',1474887907,211.00,'0'),
(263,'65','2016-09-26',1474888210,504.00,'0'),
(264,'31','2016-09-26',1474892549,175.00,'0'),
(265,'187','2016-09-26',1474892598,194.00,'0'),
(266,'196','2016-09-26',1474899186,170.00,'0'),
(267,'251','2016-09-27',1474956404,160.00,'0'),
(268,'91','2016-09-27',1474965742,138.00,'0'),
(269,'212','2016-09-27',1474970666,398.00,'0'),
(270,'15','2016-09-27',1474989216,407.00,'0'),
(271,'60','2016-09-28',1475044738,194.00,'0'),
(272,'56','2016-09-28',1475060931,281.00,'0'),
(273,'197','2016-09-28',1475065504,275.00,'0'),
(274,'93','2016-09-29',1475136446,252.00,'0'),
(275,'258','2016-09-29',1475138085,68.00,'0'),
(276,'122','2016-09-29',1475149399,141.00,'0'),
(277,'137','2016-09-29',1475149595,204.00,'0'),
(278,'33','2016-09-29',1475154730,354.00,'0'),
(279,'31','2016-09-29',1475158374,437.00,'0'),
(280,'173','2016-09-30',1475216092,44.00,'0'),
(281,'176','2016-09-30',1475218105,171.00,'0'),
(282,'126','2016-09-30',1475230668,150.00,'0'),
(283,'255','2016-09-30',1475231915,44.00,'0'),
(284,'131','2016-09-30',1475234109,247.00,'0'),
(285,'98','2016-09-30',1475238565,383.00,'0'),
(286,'63','2016-09-30',1475245708,970.00,'0'),
(287,'160','2016-10-01',1475306103,247.00,'0'),
(288,'156','2016-10-01',1475313823,524.00,'0'),
(289,'163','2016-10-01',1475314394,320.00,'0'),
(290,'163','2016-10-01',1475314582,640.00,'0'),
(291,'148','2016-10-01',1475315871,49.00,'0'),
(292,'148','2016-10-01',1475315897,155.00,'0'),
(293,'143','2016-10-01',1475321728,304.00,'0'),
(294,'143','2016-10-01',1475321770,128.00,'0'),
(295,'232','2016-10-01',1475321849,204.00,'0'),
(296,'122','2016-10-01',1475323486,155.00,'0'),
(297,'267','2016-10-01',1475323720,97.00,'0'),
(298,'203','2016-10-01',1475326664,428.00,'0'),
(299,'138','2016-10-01',1475328470,218.00,'0'),
(300,'15','2016-10-03',1475476706,218.00,'0'),
(301,'153','2016-10-03',1475482381,209.00,'0'),
(302,'203','2016-10-04',1475568176,171.00,'0'),
(303,'68','2016-10-04',1475573303,82.00,'0'),
(304,'15','2016-10-04',1475581918,78.00,'0'),
(305,'77','2016-10-04',1475584287,262.00,'0'),
(306,'67','2016-10-04',1475584554,524.00,'0'),
(307,'215','2016-10-05',1475648180,213.00,'0'),
(308,'204','2016-10-05',1475654875,204.00,'0'),
(309,'239','2016-10-05',1475657702,218.00,'0'),
(310,'70','2016-10-05',1475661654,194.00,'0'),
(311,'257','2016-10-05',1475675137,175.00,'0'),
(312,'169','2016-10-05',1475679263,291.00,'0'),
(313,'176','2016-10-06',1475737023,190.00,'0'),
(314,'31','2016-10-06',1475739192,213.00,'0'),
(315,'137','2016-10-06',1475741695,131.00,'0'),
(316,'104','2016-10-06',1475745056,243.00,'0'),
(317,'63','2016-10-06',1475751960,233.00,'0'),
(318,'104','2016-10-06',1475754868,131.00,'0'),
(319,'11','2016-10-06',1475756398,698.00,'0'),
(320,'239','2016-10-06',1475759821,68.00,'0'),
(321,'55','2016-10-06',1475764893,223.00,'0'),
(322,'81','2016-10-07',1475824366,184.00,'0'),
(323,'196','2016-10-07',1475825914,243.00,'0'),
(324,'149','2016-10-07',1475829938,441.00,'0'),
(325,'79','2016-10-07',1475840750,155.00,'0'),
(326,'250','2016-10-07',1475843312,349.00,'0'),
(327,'245','2016-10-07',1475854168,437.00,'0'),
(328,'143','2016-10-08',1475917915,67.00,'0'),
(329,'68','2016-10-08',1475918628,325.00,'0'),
(330,'209','2016-10-08',1475919162,412.00,'0'),
(331,'233','2016-10-08',1475919312,558.00,'0'),
(332,'17','2016-10-08',1475922633,213.00,'0'),
(333,'167','2016-10-08',1475925255,485.00,'0'),
(334,'68','2016-10-08',1475925607,310.00,'0'),
(335,'31','2016-10-08',1475932154,485.00,'0'),
(336,'91','2016-10-10',1476083188,266.00,'0'),
(337,'231','2016-10-10',1476093826,301.00,'0'),
(338,'198','2016-10-10',1476095926,160.00,'0'),
(339,'81','2016-10-11',1476171208,223.00,'0'),
(340,'132','2016-10-11',1476176248,364.00,'0'),
(341,'90','2016-10-11',1476180033,194.00,'0'),
(342,'203','2016-10-11',1476186803,409.00,'0'),
(343,'150','2016-10-11',1476194640,184.00,'0'),
(344,'192','2016-10-11',1476197681,97.00,'0'),
(345,'192','2016-10-11',1476197722,301.00,'0'),
(346,'152','2016-10-11',1476197960,184.00,'0'),
(347,'152','2016-10-11',1476197974,291.00,'0'),
(348,'26','2016-10-12',1476259713,184.00,'0'),
(349,'32','2016-10-12',1476260014,223.00,'0'),
(350,'253','2016-10-12',1476267473,170.00,'0'),
(351,'203','2016-10-12',1476269756,371.00,'0'),
(352,'212','2016-10-12',1476279529,97.00,'0'),
(353,'175','2016-10-12',1476281279,184.00,'0'),
(354,'212','2016-10-13',1476340482,160.00,'0'),
(355,'19','2016-10-13',1476347196,170.00,'0'),
(356,'212','2016-10-13',1476352843,68.00,'0'),
(357,'184','2016-10-13',1476366375,330.00,'0'),
(358,'21','2016-10-14',1476440101,194.00,'0'),
(359,'210','2016-10-14',1476442454,175.00,'0'),
(360,'160','2016-10-15',1476509410,272.00,'0'),
(361,'67','2016-10-15',1476511430,209.00,'0'),
(362,'138','2016-10-15',1476511510,150.00,'0'),
(363,'138','2016-10-15',1476512563,611.00,'0'),
(364,'36','2016-10-15',1476522554,78.00,'0'),
(365,'67','2016-10-15',1476528782,466.00,'0'),
(366,'130','2016-10-15',1476534027,243.00,'0'),
(367,'111','2016-10-18',1476771202,466.00,'0'),
(368,'115','2016-10-18',1476774421,228.00,'0'),
(369,'264','2016-10-18',1476791107,160.00,'0'),
(370,'223','2016-10-18',1476805141,160.00,'0'),
(371,'144','2016-10-18',1476805972,340.00,'0'),
(372,'261','2016-10-19',1476862577,155.00,'0'),
(373,'26','2016-10-19',1476862590,184.00,'0'),
(374,'231','2016-10-19',1476870770,184.00,'0'),
(375,'203','2016-10-19',1476871928,266.00,'0'),
(376,'133','2016-10-20',1476943158,223.00,'0'),
(377,'93','2016-10-20',1476948550,194.00,'0'),
(378,'93','2016-10-20',1476949106,49.00,'0'),
(379,'137','2016-10-20',1476953294,272.00,'0'),
(380,'188','2016-10-20',1476970721,266.00,'0'),
(381,'66','2016-10-20',1476974046,233.00,'0'),
(382,'188','2016-10-20',1476977742,171.00,'0'),
(383,'79','2016-10-21',1477038062,398.00,'0'),
(384,'47','2016-10-21',1477048766,194.00,'0'),
(385,'174','2016-10-21',1477061547,175.00,'0'),
(386,'209','2016-10-22',1477117703,437.00,'0'),
(387,'72','2016-10-22',1477125931,175.00,'0'),
(388,'143','2016-10-22',1477131041,380.00,'0'),
(389,'19','2016-10-22',1477134492,68.00,'0'),
(390,'275','2016-10-22',1477140781,320.00,'0'),
(391,'130','2016-10-22',1477140824,272.00,'0'),
(392,'203','2016-10-22',1477145120,238.00,'0'),
(393,'152','2016-10-22',1477150091,485.00,'0'),
(394,'268','2016-10-24',1477293417,155.00,'0'),
(395,'176','2016-10-24',1477294389,171.00,'0'),
(396,'263','2016-10-24',1477299539,204.00,'0'),
(397,'282','2016-10-24',1477306055,141.00,'0'),
(398,'56','2016-10-24',1477310037,141.00,'0'),
(399,'119','2016-10-25',1477381926,194.00,'0'),
(400,'205','2016-10-25',1477386189,243.00,'0'),
(401,'219','2016-10-25',1477396672,373.00,'0'),
(402,'203','2016-10-25',1477401019,171.00,'0'),
(403,'79','2016-10-25',1477401341,146.00,'0'),
(404,'151','2016-10-25',1477406020,262.00,'0'),
(405,'251','2016-10-25',1477407567,194.00,'0'),
(406,'15','2016-10-26',1477459932,218.00,'0'),
(407,'91','2016-10-26',1477466423,138.00,'0'),
(408,'167','2016-10-26',1477467732,68.00,'0'),
(409,'196','2016-10-26',1477471084,141.00,'0'),
(410,'173','2016-10-26',1477478733,218.00,'0'),
(411,'251','2016-10-26',1477491408,175.00,'0'),
(412,'93','2016-10-27',1477552746,68.00,'0'),
(413,'38','2016-10-27',1477569289,204.00,'0'),
(414,'153','2016-10-27',1477575384,68.00,'0'),
(415,'267','2016-10-27',1477576055,175.00,'0'),
(416,'31','2016-10-27',1477576724,369.00,'0'),
(417,'65','2016-10-28',1477658368,310.00,'0'),
(418,'65','2016-10-28',1477658397,204.00,'0'),
(419,'268','2016-10-28',1477666029,238.00,'0'),
(420,'267','2016-10-28',1477675084,248.00,'0'),
(421,'277','2016-10-29',1477730613,160.00,'0'),
(422,'99','2016-10-29',1477731514,223.00,'0'),
(423,'232','2016-10-31',1477919393,262.00,'0'),
(424,'140','2016-11-01',1477991040,359.00,'0'),
(425,'139','2016-11-01',1478009574,272.00,'0'),
(426,'191','2016-11-01',1478012485,606.00,'0'),
(427,'6','2016-11-01',1478017707,335.00,'0'),
(428,'227','2016-11-02',1478081106,97.00,'0'),
(429,'51','2016-11-02',1478082820,349.00,'0'),
(430,'131','2016-11-02',1478083358,432.00,'0'),
(431,'292','2016-11-02',1478087405,310.00,'0'),
(432,'176','2016-11-02',1478088880,214.00,'0'),
(433,'79','2016-11-02',1478093594,223.00,'0'),
(434,'68','2016-11-02',1478095433,335.00,'0'),
(435,'280','2016-11-03',1478157140,141.00,'0'),
(436,'68','2016-11-03',1478166000,221.00,'0'),
(437,'68','2016-11-03',1478166011,310.00,'0'),
(438,'222','2016-11-03',1478182757,78.00,'0'),
(439,'81','2016-11-04',1478270567,461.00,'0'),
(440,'272','2016-11-05',1478326878,179.00,'0'),
(441,'72','2016-11-05',1478330300,179.00,'0'),
(442,'60','2016-11-05',1478334628,194.00,'0'),
(443,'132','2016-11-05',1478343471,354.00,'0'),
(444,'17','2016-11-05',1478354956,252.00,'0'),
(445,'17','2016-11-05',1478354956,252.00,'0'),
(446,'53','2016-11-05',1478359005,179.00,'0'),
(447,'91','2016-11-07',1478519742,399.00,'0'),
(448,'149','2016-11-07',1478521863,160.00,'0'),
(449,'56','2016-11-07',1478523571,432.00,'0'),
(450,'210','2016-11-07',1478524754,170.00,'0'),
(451,'63','2016-11-07',1478525536,689.00,'0'),
(452,'210','2016-11-07',1478527908,116.00,'0'),
(453,'156','2016-11-07',1478533253,301.00,'0'),
(454,'26','2016-11-08',1478592746,184.00,'0'),
(455,'153','2016-11-08',1478599207,194.00,'0'),
(456,'2','2016-11-08',1478613801,349.00,'0'),
(457,'55','2016-11-08',1478620145,252.00,'0'),
(458,'239','2016-11-09',1478684810,553.00,'0'),
(459,'61','2016-11-09',1478697706,592.00,'0'),
(460,'51','2016-11-09',1478701638,68.00,'0'),
(461,'233','2016-11-10',1478762203,209.00,'0'),
(462,'34','2016-11-10',1478776568,204.00,'0'),
(463,'219','2016-11-10',1478778013,698.00,'0'),
(464,'294','2016-11-10',1478781498,150.00,'0'),
(465,'90','2016-11-10',1478783125,262.00,'0'),
(466,'31','2016-11-10',1478787400,223.00,'0'),
(467,'67','2016-11-11',1478848955,199.00,'0'),
(468,'112','2016-11-11',1478859643,155.00,'0'),
(469,'68','2016-11-11',1478861179,24.00,'0'),
(470,'71','2016-11-11',1478863893,68.00,'0'),
(471,'71','2016-11-11',1478863907,5.00,'0'),
(472,'258','2016-11-11',1478865200,233.00,'0'),
(473,'198','2016-11-11',1478868541,150.00,'0'),
(474,'137','2016-11-11',1478870285,213.00,'0'),
(475,'215','2016-11-12',1478933843,262.00,'0'),
(476,'32','2016-11-12',1478940022,223.00,'0'),
(477,'124','2016-11-12',1478942369,310.00,'0'),
(478,'174','2016-11-12',1478953296,310.00,'0'),
(479,'138','2016-11-14',1479120281,146.00,'0'),
(480,'193','2016-11-14',1479120305,170.00,'0'),
(481,'79','2016-11-14',1479122982,155.00,'0'),
(482,'292','2016-11-14',1479127967,160.00,'0'),
(483,'215','2016-11-15',1479207781,136.00,'0'),
(484,'261','2016-11-15',1479217019,165.00,'0'),
(485,'167','2016-11-15',1479219329,165.00,'0'),
(486,'49','2016-11-15',1479224533,204.00,'0'),
(487,'91','2016-11-16',1479281936,138.00,'0'),
(488,'231','2016-11-16',1479289356,68.00,'0'),
(489,'93','2016-11-16',1479291812,257.00,'0'),
(490,'231','2016-11-16',1479297229,223.00,'0'),
(491,'187','2016-11-16',1479303379,485.00,'0'),
(492,'66','2016-11-16',1479305740,349.00,'0'),
(493,'223','2016-11-17',1479378659,68.00,'0'),
(494,'115','2016-11-17',1479383321,218.00,'0'),
(495,'15','2016-11-17',1479393154,97.00,'0'),
(496,'193','2016-11-18',1479469490,310.00,'0'),
(497,'176','2016-11-18',1479478760,171.00,'0'),
(498,'176','2016-11-18',1479478760,171.00,'0'),
(499,'176','2016-11-18',1479478760,171.00,'0'),
(500,'131','2016-11-18',1479481430,548.00,'0');

INSERT INTO `DELETE_realizatsia` VALUES 
(501,'93','2016-11-19',1479538610,427.00,'0'),
(502,'193','2016-11-19',1479545809,126.00,'0'),
(503,'131','2016-11-19',1479550957,175.00,'0'),
(504,'231','2016-11-19',1479551028,175.00,'0'),
(505,'131','2016-11-19',1479555012,116.00,'0'),
(506,'143','2016-11-19',1479557035,941.00,'0'),
(507,'137','2016-11-19',1479558647,150.00,'0'),
(508,'115','2016-11-19',1479566495,412.00,'0'),
(509,'150','2016-11-21',1479711948,247.00,'0'),
(510,'111','2016-11-21',1479716775,310.00,'0'),
(511,'98','2016-11-21',1479722370,204.00,'0'),
(512,'133','2016-11-22',1479810946,320.00,'0'),
(513,'131','2016-11-22',1479813951,213.00,'0'),
(514,'282','2016-11-22',1479815189,155.00,'0'),
(515,'289','2016-11-22',1479815574,252.00,'0'),
(516,'203','2016-11-22',1479815828,518.00,'0'),
(517,'210','2016-11-22',1479821788,310.00,'0'),
(518,'132','2016-11-22',1479821945,291.00,'0'),
(519,'130','2016-11-22',1479824848,200.00,'0'),
(520,'65','2016-11-22',1479830979,310.00,'0'),
(521,'65','2016-11-23',1479892912,184.00,'0'),
(522,'65','2016-11-23',1479894100,68.00,'0'),
(523,'47','2016-11-23',1479899934,262.00,'0'),
(524,'47','2016-11-23',1479899944,262.00,'0'),
(525,'267','2016-11-23',1479900460,175.00,'0'),
(526,'267','2016-11-23',1479900647,68.00,'0'),
(527,'81','2016-11-23',1479911142,194.00,'0'),
(528,'205','2016-11-23',1479916126,209.00,'0'),
(529,'176','2016-11-24',1479979644,280.00,'0'),
(530,'75','2016-11-24',1479980255,267.00,'0'),
(531,'264','2016-11-24',1479989348,485.00,'0'),
(532,'203','2016-11-24',1479989652,352.00,'0'),
(533,'15','2016-11-24',1479991029,68.00,'0'),
(534,'266','2016-11-24',1480003857,310.00,'0'),
(535,'7','2016-11-24',1480008895,340.00,'0'),
(536,'15','2016-11-24',1480009435,209.00,'0'),
(537,'15','2016-11-24',1480009435,209.00,'0'),
(538,'26','2016-11-25',1480071866,310.00,'0'),
(539,'56','2016-11-25',1480074335,116.00,'0'),
(540,'56','2016-11-25',1480074345,39.00,'0'),
(541,'145','2016-11-25',1480083086,563.00,'0'),
(542,'284','2016-11-25',1480086357,485.00,'0'),
(543,'141','2016-11-26',1480148037,97.00,'0'),
(544,'203','2016-11-26',1480154301,271.00,'0'),
(545,'143','2016-11-26',1480155924,247.00,'0'),
(546,'267','2016-11-26',1480169905,204.00,'0'),
(547,'138','2016-11-26',1480174693,141.00,'0'),
(548,'197','2016-11-28',1480322991,272.00,'0'),
(549,'156','2016-11-28',1480342898,213.00,'0'),
(550,'79','2016-11-29',1480411644,403.00,'0'),
(551,'175','2016-11-29',1480413547,213.00,'0'),
(552,'175','2016-11-29',1480413547,213.00,'0'),
(553,'38','2016-11-29',1480419821,310.00,'0'),
(554,'153','2016-11-29',1480426078,209.00,'0'),
(555,'153','2016-11-29',1480429397,68.00,'0'),
(556,'291','2016-11-29',1480432946,175.00,'0'),
(557,'188','2016-11-29',1480436047,276.00,'0'),
(558,'188','2016-11-29',1480436132,556.00,'0'),
(559,'7','2016-11-29',1480439606,597.00,'0'),
(560,'176','2016-11-30',1480507193,214.00,'0'),
(561,'222','2016-11-30',1480510837,359.00,'0'),
(562,'31','2016-11-30',1480513965,175.00,'0'),
(563,'198','2016-11-30',1480522510,165.00,'0'),
(564,'119','2016-12-01',1480581820,175.00,'0'),
(565,'223','2016-12-01',1480591093,155.00,'0'),
(566,'68','2016-12-01',1480599234,747.00,'0'),
(567,'232','2016-12-01',1480601930,184.00,'0'),
(568,'240','2016-12-01',1480603684,320.00,'0'),
(569,'209','2016-12-01',1480609022,252.00,'0'),
(570,'209','2016-12-02',1480675093,310.00,'0'),
(571,'173','2016-12-02',1480676657,252.00,'0'),
(572,'90','2016-12-02',1480677310,194.00,'0'),
(573,'280','2016-12-02',1480683472,170.00,'0'),
(574,'137','2016-12-02',1480683994,204.00,'0'),
(575,'91','2016-12-02',1480688184,143.00,'0'),
(576,'49','2016-12-02',1480697014,194.00,'0'),
(577,'72','2016-12-03',1480750734,179.00,'0'),
(578,'107','2016-12-03',1480753520,223.00,'0'),
(579,'133','2016-12-03',1480762394,252.00,'0'),
(580,'160','2016-12-03',1480775112,146.00,'0'),
(581,'272','2016-12-03',1480779119,179.00,'0'),
(582,'268','2016-12-03',1480783221,165.00,'0'),
(583,'233','2016-12-03',1480787984,209.00,'0'),
(584,'105','2016-12-05',1480925434,204.00,'0'),
(585,'112','2016-12-05',1480935469,155.00,'0'),
(586,'91','2016-12-05',1480940712,162.00,'0'),
(587,'239','2016-12-06',1481010711,199.00,'0'),
(588,'239','2016-12-06',1481012049,49.00,'0'),
(589,'91','2016-12-06',1481016246,209.00,'0'),
(590,'91','2016-12-06',1481016267,143.00,'0'),
(591,'296','2016-12-06',1481035034,136.00,'0'),
(592,'307','2016-12-06',1481047600,194.00,'0'),
(593,'67','2016-12-06',1481052943,238.00,'0'),
(594,'93','2016-12-07',1481100753,243.00,'0'),
(595,'173','2016-12-07',1481108759,68.00,'0'),
(596,'132','2016-12-07',1481109393,349.00,'0'),
(597,'294','2016-12-07',1481112061,179.00,'0'),
(598,'123','2016-12-08',1481192157,175.00,'0'),
(599,'292','2016-12-08',1481202992,310.00,'0'),
(600,'99','2016-12-09',1481283111,233.00,'0'),
(601,'212','2016-12-09',1481289798,165.00,'0'),
(602,'212','2016-12-09',1481289803,73.00,'0'),
(603,'34','2016-12-09',1481292150,538.00,'0'),
(604,'19','2016-12-09',1481298882,189.00,'0'),
(605,'67','2016-12-10',1481353200,32.00,'0'),
(606,'219','2016-12-10',1481358075,39.00,'0'),
(607,'219','2016-12-10',1481358380,291.00,'0'),
(608,'219','2016-12-10',1481365318,243.00,'0'),
(609,'138','2016-12-10',1481367982,141.00,'0'),
(610,'17','2016-12-10',1481369786,747.00,'0'),
(611,'227','2016-12-10',1481377687,291.00,'0'),
(612,'261','2016-12-10',1481384219,141.00,'0'),
(613,'133','2016-12-12',1481529774,204.00,'0'),
(614,'203','2016-12-13',1481617129,166.00,'0'),
(615,'282','2016-12-13',1481625149,170.00,'0'),
(616,'67','2016-12-13',1481630406,29.00,'0'),
(617,'231','2016-12-13',1481637028,184.00,'0'),
(618,'294','2016-12-13',1481638960,970.00,'0'),
(619,'39','2016-12-13',1481639240,189.00,'0'),
(620,'48','2016-12-13',1481644991,485.00,'0'),
(621,'149','2016-12-14',1481723298,160.00,'0'),
(622,'169','2016-12-14',1481725175,73.00,'0'),
(623,'251','2016-12-14',1481730113,378.00,'0'),
(624,'258','2016-12-14',1481732933,369.00,'0'),
(625,'25','2016-12-15',1481792380,238.00,'0'),
(626,'315','2016-12-15',1481797754,155.00,'0'),
(627,'63','2016-12-15',1481798831,262.00,'0'),
(628,'231','2016-12-15',1481800071,276.00,'0'),
(629,'289','2016-12-15',1481806292,281.00,'0'),
(630,'215','2016-12-15',1481818492,199.00,'0'),
(631,'321','2016-12-16',1481889234,160.00,'0'),
(632,'79','2016-12-17',1481964879,146.00,'0'),
(633,'60','2016-12-17',1481967772,509.00,'0'),
(634,'37','2016-12-17',1481968144,281.00,'0'),
(635,'321','2016-12-17',1481971726,340.00,'0'),
(636,'115','2016-12-17',1481976278,646.00,'0'),
(637,'272','2016-12-17',1481978450,58.00,'0'),
(638,'210','2016-12-19',1482134507,175.00,'0'),
(639,'81','2016-12-19',1482143986,446.00,'0'),
(640,'272','2016-12-19',1482147368,834.00,'0'),
(641,'104','2016-12-19',1482152954,262.00,'0'),
(642,'297','2016-12-19',1482166568,262.00,'0'),
(643,'297','2016-12-19',1482166568,262.00,'0'),
(644,'119','2016-12-20',1482222667,310.00,'0'),
(645,'131','2016-12-20',1482229619,160.00,'0'),
(646,'320','2016-12-20',1482230338,272.00,'0'),
(647,'21','2016-12-20',1482239066,199.00,'0'),
(648,'21','2016-12-20',1482239101,485.00,'0'),
(649,'128','2016-12-20',1482242733,155.00,'0'),
(650,'65','2016-12-20',1482242998,310.00,'0'),
(651,'65','2016-12-20',1482243030,194.00,'0'),
(652,'258','2016-12-20',1482250772,291.00,'0'),
(653,'91','2016-12-21',1482318077,138.00,'0'),
(654,'91','2016-12-21',1482318097,133.00,'0'),
(655,'61','2016-12-21',1482322724,194.00,'0'),
(656,'61','2016-12-21',1482322729,68.00,'0'),
(657,'139','2016-12-21',1482332597,272.00,'0'),
(658,'144','2016-12-21',1482338107,204.00,'0'),
(659,'291','2016-12-21',1482339799,252.00,'0'),
(660,'291','2016-12-21',1482339799,252.00,'0'),
(661,'66','2016-12-21',1482351574,233.00,'0'),
(662,'304','2016-12-22',1482392260,44.00,'0'),
(663,'294','2016-12-22',1482405109,412.00,'0'),
(664,'269','2016-12-22',1482408126,194.00,'0'),
(665,'269','2016-12-22',1482408135,703.00,'0'),
(666,'187','2016-12-22',1482410798,262.00,'0'),
(667,'91','2016-12-22',1482412918,570.00,'0'),
(668,'48','2016-12-22',1482420783,1222.00,'0'),
(669,'233','2016-12-22',1482427493,223.00,'0'),
(670,'47','2016-12-23',1482488197,243.00,'0'),
(671,'176','2016-12-23',1482489749,304.00,'0'),
(672,'115','2016-12-23',1482494944,95.00,'0'),
(673,'63','2016-12-23',1482495994,267.00,'0'),
(674,'15','2016-12-23',1482496199,68.00,'0'),
(675,'153','2016-12-23',1482496612,291.00,'0'),
(676,'198','2016-12-23',1482500542,146.00,'0'),
(677,'143','2016-12-23',1482501926,318.00,'0'),
(678,'70','2016-12-23',1482503611,223.00,'0'),
(679,'7','2016-12-23',1482508969,233.00,'0'),
(680,'67','2016-12-23',1482510632,349.00,'0'),
(681,'250','2016-12-23',1482514675,213.00,'0'),
(682,'250','2016-12-23',1482514724,68.00,'0'),
(683,'250','2016-12-23',1482514724,68.00,'0'),
(684,'91','2016-12-24',1482583010,190.00,'0'),
(685,'325','2016-12-24',1482583042,805.00,'0'),
(686,'47','2016-12-24',1482584343,243.00,'0'),
(687,'107','2016-12-24',1482587068,204.00,'0'),
(688,'145','2016-12-24',1482590600,213.00,'0'),
(689,'264','2016-12-24',1482590689,146.00,'0'),
(690,'72','2016-12-26',1482735852,189.00,'0'),
(691,'267','2016-12-26',1482739708,68.00,'0'),
(692,'267','2016-12-26',1482739708,68.00,'0'),
(693,'267','2016-12-26',1482739717,175.00,'0'),
(694,'234','2016-12-26',1482744541,165.00,'0'),
(695,'119','2016-12-26',1482747676,213.00,'0'),
(696,'115','2016-12-26',1482749633,185.00,'0'),
(697,'131','2016-12-26',1482752419,432.00,'0'),
(698,'268','2016-12-26',1482759848,168.00,'0'),
(699,'267','2016-12-26',1482761704,204.00,'0'),
(700,'31','2016-12-26',1482763679,427.00,'0'),
(701,'309','2016-12-26',1482771497,175.00,'0'),
(702,'292','2016-12-26',1482772553,373.00,'0'),
(703,'183','2016-12-26',1482780445,165.00,'0'),
(704,'112','2016-12-27',1482823593,146.00,'0'),
(705,'240','2016-12-27',1482823853,310.00,'0'),
(706,'228','2016-12-27',1482826191,39.00,'0'),
(707,'304','2016-12-27',1482827993,204.00,'0'),
(708,'77','2016-12-27',1482830812,340.00,'0'),
(709,'231','2016-12-27',1482834652,279.00,'0'),
(710,'305','2016-12-27',1482837723,461.00,'0'),
(711,'101','2016-12-27',1482838727,165.00,'0'),
(712,'101','2016-12-27',1482838745,553.00,'0'),
(713,'308','2016-12-27',1482839270,223.00,'0'),
(714,'77','2016-12-27',1482843864,490.00,'0'),
(715,'77','2016-12-27',1482843869,68.00,'0'),
(716,'231','2016-12-27',1482844502,68.00,'0'),
(717,'231','2016-12-27',1482844506,175.00,'0'),
(718,'203','2016-12-27',1482847605,238.00,'0'),
(719,'203','2016-12-27',1482847717,171.00,'0'),
(720,'203','2016-12-27',1482847948,138.00,'0'),
(721,'119','2016-12-27',1482849848,175.00,'0'),
(722,'150','2016-12-27',1482851739,223.00,'0'),
(723,'203','2016-12-27',1482852158,570.00,'0'),
(724,'203','2016-12-27',1482852165,67.00,'0'),
(725,'296','2016-12-27',1482857518,310.00,'0'),
(726,'56','2016-12-27',1482869759,941.00,'0'),
(727,'156','2016-12-28',1482914615,243.00,'0'),
(728,'328','2016-12-28',1482930183,1048.00,'0'),
(729,'68','2016-12-28',1482938673,219.00,'0'),
(730,'68','2016-12-28',1482938722,304.00,'0'),
(731,'71','2016-12-28',1482955407,349.00,'0'),
(732,'173','2016-12-29',1483004209,116.00,'0'),
(733,'175','2016-12-29',1483004613,194.00,'0'),
(734,'163','2016-12-29',1483005349,252.00,'0'),
(735,'98','2016-12-29',1483007159,199.00,'0'),
(736,'90','2016-12-29',1483010401,233.00,'0'),
(737,'93','2016-12-29',1483011099,310.00,'0'),
(738,'175','2016-12-29',1483011444,228.00,'0'),
(739,'303','2016-12-29',1483013377,146.00,'0'),
(740,'318','2016-12-29',1483019555,146.00,'0'),
(741,'197','2016-12-29',1483020632,243.00,'0'),
(742,'197','2016-12-29',1483020655,310.00,'0'),
(743,'38','2016-12-29',1483021846,223.00,'0'),
(744,'19','2016-12-29',1483027640,189.00,'0'),
(745,'19','2016-12-29',1483027640,189.00,'0'),
(746,'323','2016-12-29',1483030455,660.00,'0'),
(747,'15','2016-12-29',1483033370,233.00,'0'),
(748,'240','2016-12-29',1483038221,213.00,'0'),
(749,'79','2016-12-29',1483041304,165.00,'0'),
(750,'79','2016-12-29',1483041312,213.00,'0'),
(751,'79','2016-12-29',1483041329,669.00,'0'),
(752,'239','2016-12-30',1483083688,229.00,'0'),
(753,'137','2016-12-30',1483088690,272.00,'0'),
(754,'137','2016-12-30',1483088690,272.00,'0'),
(755,'317','2016-12-30',1483092174,170.00,'0'),
(756,'317','2016-12-30',1483092235,177.00,'0'),
(757,'143','2016-12-30',1483093975,209.00,'0'),
(758,'143','2016-12-30',1483093975,209.00,'0'),
(759,'298','2016-12-30',1483094614,165.00,'0'),
(760,'188','2016-12-30',1483095543,304.00,'0'),
(761,'143','2016-12-30',1483100262,366.00,'0'),
(762,'143','2016-12-30',1483101741,304.00,'0'),
(763,'143','2016-12-30',1483101749,67.00,'0'),
(764,'130','2016-12-30',1483107807,200.00,'0'),
(765,'176','2016-12-30',1483112621,190.00,'0'),
(766,'49','2016-12-30',1483118093,310.00,'0'),
(767,'188','2016-12-30',1483120080,200.00,'0'),
(768,'317','2016-12-30',1483132093,713.00,'0'),
(769,'317','2016-12-31',1483169362,146.00,'0'),
(770,'173','2016-12-31',1483172052,233.00,'0'),
(771,'317','2016-12-31',1483177984,320.00,'0'),
(772,'203','2016-12-31',1483179779,238.00,'0'),
(773,'203','2016-12-31',1483179790,238.00,'0'),
(774,'137','2016-12-31',1483180287,138.00,'0'),
(775,'272','2017-01-03',1483439559,141.00,'0'),
(776,'101','2017-01-03',1483439633,310.00,'0'),
(777,'296','2017-01-03',1483439832,243.00,'0'),
(778,'132','2017-01-03',1483440308,68.00,'0'),
(779,'132','2017-01-03',1483440320,189.00,'0'),
(780,'132','2017-01-03',1483440329,175.00,'0'),
(781,'317','2017-01-03',1483443321,1397.00,'0'),
(782,'138','2017-01-03',1483457045,150.00,'0'),
(783,'68','2017-01-03',1483458253,147.00,'0'),
(784,'68','2017-01-03',1483458323,409.00,'0'),
(785,'261','2017-01-04',1483513549,150.00,'0'),
(786,'253','2017-01-04',1483524846,553.00,'0'),
(787,'229','2017-01-04',1483528211,330.00,'0'),
(788,'124','2017-01-04',1483541577,849.00,'0'),
(789,'61','2017-01-04',1483547068,291.00,'0'),
(790,'91','2017-01-05',1483603814,138.00,'0'),
(791,'193','2017-01-05',1483608007,150.00,'0'),
(792,'131','2017-01-05',1483625268,160.00,'0'),
(793,'131','2017-01-05',1483625276,68.00,'0'),
(794,'93','2017-01-05',1483626888,49.00,'0'),
(795,'81','2017-01-05',1483626951,223.00,'0'),
(796,'81','2017-01-05',1483626956,34.00,'0'),
(797,'175','2017-01-05',1483627393,68.00,'0'),
(798,'31','2017-01-05',1483629950,310.00,'0'),
(799,'133','2017-01-05',1483635524,223.00,'0'),
(800,'12','2017-01-05',1483640242,155.00,'0'),
(801,'12','2017-01-05',1483640242,155.00,'0'),
(802,'12','2017-01-05',1483640242,155.00,'0'),
(803,'12','2017-01-05',1483640242,155.00,'0'),
(804,'12','2017-01-05',1483640242,155.00,'0'),
(805,'12','2017-01-05',1483640242,155.00,'0'),
(806,'12','2017-01-05',1483640242,155.00,'0'),
(807,'49','2017-01-06',1483695649,243.00,'0'),
(808,'17','2017-01-06',1483697894,218.00,'0'),
(809,'264','2017-01-10',1484044610,44.00,'0'),
(810,'130','2017-01-10',1484051960,513.00,'0'),
(811,'149','2017-01-11',1484131799,152.00,'0'),
(812,'308','2017-01-11',1484141045,175.00,'0'),
(813,'212','2017-01-11',1484145895,238.00,'0'),
(814,'232','2017-01-11',1484147007,243.00,'0'),
(815,'198','2017-01-11',1484147727,272.00,'0'),
(816,'167','2017-01-12',1484207875,194.00,'0'),
(817,'167','2017-01-12',1484207885,146.00,'0'),
(818,'26','2017-01-12',1484231001,184.00,'0'),
(819,'123','2017-01-13',1484298596,179.00,'0'),
(820,'321','2017-01-13',1484331145,141.00,'0'),
(821,'67','2017-01-14',1484387364,228.00,'0'),
(822,'67','2017-01-14',1484387377,97.00,'0'),
(823,'176','2017-01-16',1484561355,171.00,'0'),
(824,'153','2017-01-16',1484563116,262.00,'0'),
(825,'193','2017-01-16',1484567087,175.00,'0'),
(826,'227','2017-01-16',1484570531,262.00,'0'),
(827,'13','2017-01-16',1484570585,155.00,'0'),
(828,'280','2017-01-16',1484572911,223.00,'0'),
(829,'280','2017-01-16',1484577309,162.00,'0'),
(830,'322','2017-01-16',1484577460,165.00,'0'),
(831,'93','2017-01-17',1484674664,194.00,'0'),
(832,'152','2017-01-18',1484734470,194.00,'0'),
(833,'263','2017-01-20',1484922656,543.00,'0'),
(834,'215','2017-01-20',1484925208,257.00,'0'),
(835,'250','2017-01-20',1484933447,359.00,'0'),
(836,'19','2017-01-20',1484940415,820.00,'0'),
(837,'258','2017-01-21',1484984607,175.00,'0'),
(838,'327','2017-01-21',1484994224,184.00,'0'),
(839,'21','2017-01-21',1484997218,213.00,'0'),
(840,'81','2017-01-21',1484999661,175.00,'0'),
(841,'268','2017-01-21',1485000376,141.00,'0'),
(842,'333','2017-01-21',1485003666,160.00,'0'),
(843,'34','2017-01-21',1485004251,330.00,'0'),
(844,'314','2017-01-21',1485009526,204.00,'0'),
(845,'314','2017-01-21',1485015778,141.00,'0'),
(846,'65','2017-01-21',1485017975,606.00,'0'),
(847,'53','2017-01-21',1485024156,194.00,'0'),
(848,'49','2017-01-23',1485154863,310.00,'0'),
(849,'294','2017-01-23',1485154879,485.00,'0'),
(850,'112','2017-01-23',1485155823,146.00,'0'),
(851,'176','2017-01-23',1485166409,190.00,'0'),
(852,'79','2017-01-23',1485176430,165.00,'0'),
(853,'292','2017-01-23',1485177337,310.00,'0'),
(854,'239','2017-01-24',1485246134,252.00,'0'),
(855,'326','2017-01-24',1485259947,175.00,'0'),
(856,'91','2017-01-24',1485270841,285.00,'0'),
(857,'91','2017-01-24',1485270866,138.00,'0'),
(858,'72','2017-01-25',1485336223,199.00,'0'),
(859,'219','2017-01-25',1485339654,451.00,'0'),
(860,'219','2017-01-25',1485341275,97.00,'0'),
(861,'219','2017-01-25',1485341291,73.00,'0'),
(862,'156','2017-01-25',1485346717,194.00,'0'),
(863,'183','2017-01-25',1485348511,403.00,'0'),
(864,'79','2017-01-25',1485348528,204.00,'0'),
(865,'307','2017-01-25',1485356548,223.00,'0'),
(866,'320','2017-01-25',1485373482,272.00,'0'),
(867,'320','2017-01-25',1485373482,272.00,'0'),
(868,'267','2017-01-26',1485418438,195.00,'0'),
(869,'336','2017-01-26',1485419538,485.00,'0'),
(870,'267','2017-01-26',1485421240,126.00,'0'),
(871,'125','2017-01-26',1485430690,175.00,'0'),
(872,'119','2017-01-26',1485430929,213.00,'0'),
(873,'337','2017-01-26',1485437815,325.00,'0'),
(874,'203','2017-01-26',1485438818,124.00,'0'),
(875,'203','2017-01-26',1485438988,523.00,'0'),
(876,'163','2017-01-26',1485444964,373.00,'0'),
(877,'337','2017-01-26',1485459681,970.00,'0'),
(878,'163','2017-01-27',1485500702,146.00,'0'),
(879,'54','2017-01-27',1485506535,170.00,'0'),
(880,'132','2017-01-27',1485509572,340.00,'0'),
(881,'50','2017-01-27',1485509589,68.00,'0'),
(882,'50','2017-01-27',1485509604,29.00,'0'),
(883,'137','2017-01-27',1485516878,200.00,'0'),
(884,'131','2017-01-27',1485518476,141.00,'0'),
(885,'66','2017-01-27',1485525607,233.00,'0'),
(886,'150','2017-01-27',1485532604,243.00,'0'),
(887,'107','2017-01-28',1485592984,209.00,'0'),
(888,'325','2017-01-28',1485593142,310.00,'0'),
(889,'81','2017-01-28',1485602683,266.00,'0'),
(890,'312','2017-01-28',1485602728,209.00,'0'),
(891,'294','2017-01-28',1485604525,175.00,'0'),
(892,'292','2017-01-28',1485606899,272.00,'0'),
(893,'68','2017-01-28',1485608179,413.00,'0'),
(894,'143','2017-01-28',1485608443,656.00,'0'),
(895,'138','2017-01-28',1485609989,141.00,'0'),
(896,'68','2017-01-28',1485624229,226.00,'0'),
(897,'233','2017-01-28',1485624248,218.00,'0'),
(898,'85','2017-01-30',1485771851,160.00,'0'),
(899,'297','2017-01-30',1485772903,184.00,'0'),
(900,'209','2017-01-30',1485786448,320.00,'0'),
(901,'209','2017-01-30',1485786475,310.00,'0'),
(902,'209','2017-01-30',1485786481,68.00,'0'),
(903,'209','2017-01-30',1485788190,58.00,'0'),
(904,'38','2017-01-30',1485793900,243.00,'0'),
(905,'38','2017-01-30',1485793919,49.00,'0'),
(906,'21','2017-01-31',1485860657,378.00,'0'),
(907,'50','2017-01-31',1485862302,437.00,'0'),
(908,'303','2017-01-31',1485863963,150.00,'0'),
(909,'212','2017-01-31',1485864483,97.00,'0'),
(910,'223','2017-01-31',1485872013,116.00,'0'),
(911,'139','2017-01-31',1485875447,116.00,'0'),
(912,'139','2017-01-31',1485875454,265.00,'0'),
(913,'212','2017-01-31',1485884509,170.00,'0'),
(914,'212','2017-01-31',1485884522,68.00,'0'),
(915,'223','2017-01-31',1485889064,170.00,'0'),
(916,'8','2017-02-01',1485940142,68.00,'0'),
(917,'329','2017-02-01',1485941655,141.00,'0'),
(918,'240','2017-02-01',1485951046,194.00,'0'),
(919,'317','2017-02-01',1485959078,147.00,'0'),
(920,'283','2017-02-01',1485961333,378.00,'0'),
(921,'317','2017-02-01',1485966604,310.00,'0'),
(922,'198','2017-02-01',1485969655,141.00,'0'),
(923,'304','2017-02-02',1486025200,184.00,'0'),
(924,'304','2017-02-02',1486025212,49.00,'0'),
(925,'99','2017-02-02',1486025730,310.00,'0'),
(926,'99','2017-02-02',1486025737,34.00,'0'),
(927,'183','2017-02-02',1486028573,266.00,'0'),
(928,'222','2017-02-02',1486037159,82.00,'0'),
(929,'79','2017-02-02',1486037197,490.00,'0'),
(930,'173','2017-02-02',1486039899,243.00,'0'),
(931,'317','2017-02-02',1486055321,223.00,'0'),
(932,'128','2017-02-02',1486058180,150.00,'0'),
(933,'7','2017-02-02',1486063129,204.00,'0'),
(934,'31','2017-02-03',1486114193,340.00,'0'),
(935,'133','2017-02-03',1486140681,262.00,'0'),
(936,'8','2017-02-04',1486202532,320.00,'0'),
(937,'317','2017-02-04',1486228043,621.00,'0'),
(938,'15','2017-02-05',1486303685,902.00,'0'),
(939,'61','2017-02-07',1486463784,281.00,'0'),
(940,'124','2017-02-07',1486465472,310.00,'0'),
(941,'124','2017-02-07',1486465480,136.00,'0'),
(942,'175','2017-02-07',1486468238,213.00,'0'),
(943,'153','2017-02-07',1486468376,233.00,'0'),
(944,'143','2017-02-07',1486475908,124.00,'0'),
(945,'2','2017-02-07',1486476622,233.00,'0'),
(946,'175','2017-02-08',1486544436,184.00,'0'),
(947,'67','2017-02-08',1486545438,310.00,'0'),
(948,'264','2017-02-08',1486556926,97.00,'0'),
(949,'32','2017-02-08',1486565300,228.00,'0'),
(950,'240','2017-02-09',1486628081,146.00,'0'),
(951,'31','2017-02-09',1486653231,194.00,'0'),
(952,'169','2017-02-09',1486654594,150.00,'0'),
(953,'98','2017-02-10',1486713808,320.00,'0'),
(954,'98','2017-02-10',1486713816,223.00,'0'),
(955,'193','2017-02-10',1486717061,146.00,'0'),
(956,'193','2017-02-10',1486717067,49.00,'0'),
(957,'231','2017-02-10',1486721784,223.00,'0'),
(958,'231','2017-02-10',1486729390,126.00,'0'),
(959,'258','2017-02-10',1486731249,558.00,'0'),
(960,'26','2017-02-10',1486741260,194.00,'0'),
(961,'107','2017-02-11',1486806364,204.00,'0'),
(962,'91','2017-02-11',1486808285,57.00,'0'),
(963,'91','2017-02-11',1486808293,138.00,'0'),
(964,'20','2017-02-11',1486810616,252.00,'0'),
(965,'215','2017-02-13',1486999279,190.00,'0'),
(966,'268','2017-02-13',1487003921,155.00,'0'),
(967,'77','2017-02-14',1487060976,204.00,'0'),
(968,'289','2017-02-14',1487073964,340.00,'0'),
(969,'176','2017-02-14',1487074884,171.00,'0'),
(970,'335','2017-02-14',1487075133,163.00,'0'),
(971,'167','2017-02-14',1487079790,320.00,'0'),
(972,'187','2017-02-14',1487081390,295.00,'0'),
(973,'251','2017-02-14',1487086717,310.00,'0'),
(974,'79','2017-02-14',1487088703,155.00,'0'),
(975,'291','2017-02-14',1487094561,213.00,'0'),
(976,'191','2017-02-15',1487173073,359.00,'0'),
(977,'65','2017-02-15',1487177005,181.00,'0'),
(978,'70','2017-02-16',1487234518,534.00,'0'),
(979,'264','2017-02-16',1487237752,160.00,'0'),
(980,'187','2017-02-16',1487250211,233.00,'0'),
(981,'294','2017-02-16',1487257442,170.00,'0'),
(982,'272','2017-02-16',1487260919,175.00,'0'),
(983,'305','2017-02-17',1487328983,291.00,'0'),
(984,'131','2017-02-17',1487335118,150.00,'0'),
(985,'131','2017-02-17',1487335127,68.00,'0'),
(986,'188','2017-02-17',1487340918,48.00,'0'),
(987,'188','2017-02-17',1487340926,437.00,'0'),
(988,'145','2017-02-17',1487343055,281.00,'0'),
(989,'203','2017-02-18',1487402631,171.00,'0'),
(990,'143','2017-02-18',1487408694,304.00,'0'),
(991,'277','2017-02-18',1487409935,141.00,'0'),
(992,'128','2017-02-18',1487410538,223.00,'0'),
(993,'254','2017-02-18',1487411971,388.00,'0'),
(994,'254','2017-02-18',1487411984,78.00,'0'),
(995,'209','2017-02-18',1487415190,78.00,'0'),
(996,'209','2017-02-18',1487415206,209.00,'0'),
(997,'209','2017-02-18',1487415217,175.00,'0'),
(998,'37','2017-02-18',1487416163,252.00,'0'),
(999,'327','2017-02-18',1487419739,170.00,'0'),
(1000,'147','2017-02-18',1487420289,131.00,'0');

INSERT INTO `DELETE_realizatsia` VALUES 
(1001,'21','2017-02-18',1487420973,194.00,'0'),
(1002,'79','2017-02-18',1487423102,184.00,'0'),
(1003,'112','2017-02-18',1487426152,160.00,'0'),
(1004,'143','2017-02-18',1487426382,475.00,'0'),
(1005,'99','2017-02-18',1487427433,349.00,'0'),
(1006,'160','2017-02-18',1487435437,160.00,'0'),
(1007,'321','2017-02-18',1487445140,170.00,'0'),
(1008,'81','2017-02-20',1487584138,209.00,'0'),
(1009,'81','2017-02-20',1487584151,171.00,'0'),
(1010,'176','2017-02-20',1487594311,304.00,'0'),
(1011,'176','2017-02-20',1487594317,209.00,'0'),
(1012,'283','2017-02-21',1487672408,204.00,'0'),
(1013,'283','2017-02-21',1487672420,272.00,'0'),
(1014,'283','2017-02-21',1487672430,78.00,'0'),
(1015,'47','2017-02-21',1487678073,204.00,'0'),
(1016,'220','2017-02-22',1487762826,78.00,'0'),
(1017,'15','2017-02-22',1487774407,243.00,'0'),
(1018,'212','2017-02-23',1487845881,68.00,'0'),
(1019,'212','2017-02-23',1487845891,165.00,'0'),
(1020,'307','2017-02-23',1487862973,223.00,'0'),
(1021,'333','2017-02-24',1487928522,165.00,'0'),
(1022,'137','2017-02-24',1487930207,257.00,'0'),
(1023,'72','2017-02-24',1487940047,204.00,'0'),
(1024,'104','2017-02-24',1487947081,301.00,'0'),
(1025,'258','2017-02-24',1487948196,310.00,'0'),
(1026,'239','2017-02-24',1487955273,213.00,'0'),
(1027,'68','2017-02-25',1488006248,209.00,'0'),
(1028,'45','2017-02-25',1488012287,204.00,'0'),
(1029,'325','2017-02-25',1488014449,175.00,'0'),
(1030,'325','2017-02-25',1488014454,291.00,'0'),
(1031,'138','2017-02-25',1488020244,141.00,'0'),
(1032,'68','2017-02-25',1488028971,304.00,'0'),
(1033,'68','2017-02-25',1488028980,76.00,'0'),
(1034,'305','2017-02-27',1488189438,310.00,'0'),
(1035,'198','2017-02-27',1488190211,165.00,'0'),
(1036,'203','2017-02-27',1488201976,266.00,'0'),
(1037,'203','2017-02-27',1488201981,138.00,'0'),
(1038,'297','2017-02-28',1488289984,213.00,'0'),
(1039,'132','2017-03-01',1488358269,175.00,'0'),
(1040,'132','2017-03-01',1488358379,189.00,'0'),
(1041,'193','2017-03-01',1488359005,126.00,'0'),
(1042,'329','2017-03-01',1488366269,160.00,'0'),
(1043,'280','2017-03-02',1488438836,155.00,'0'),
(1044,'93','2017-03-02',1488445287,221.00,'0'),
(1045,'215','2017-03-02',1488460994,295.00,'0'),
(1046,'215','2017-03-02',1488461000,105.00,'0'),
(1047,'358','2017-03-02',1488471651,970.00,'0'),
(1048,'153','2017-03-02',1488477034,218.00,'0'),
(1049,'123','2017-03-03',1488542740,176.00,'0'),
(1050,'31','2017-03-03',1488545209,310.00,'0'),
(1051,'91','2017-03-03',1488551000,147.00,'0'),
(1052,'91','2017-03-03',1488551013,76.00,'0'),
(1053,'17','2017-03-03',1488552337,213.00,'0'),
(1054,'184','2017-03-03',1488559366,154.00,'0'),
(1055,'184','2017-03-04',1488615114,146.00,'0'),
(1056,'143','2017-03-04',1488618625,247.00,'0'),
(1057,'107','2017-03-04',1488633712,276.00,'0'),
(1058,'143','2017-03-04',1488634806,171.00,'0'),
(1059,'233','2017-03-04',1488638365,213.00,'0'),
(1060,'335','2017-03-06',1488795988,160.00,'0'),
(1061,'79','2017-03-06',1488801738,160.00,'0'),
(1062,'79','2017-03-06',1488801746,29.00,'0'),
(1063,'125','2017-03-06',1488814140,369.00,'0'),
(1064,'49','2017-03-06',1488817247,194.00,'0'),
(1065,'166','2017-03-06',1488823901,213.00,'0'),
(1066,'304','2017-03-07',1488874807,49.00,'0'),
(1067,'91','2017-03-07',1488877325,456.00,'0'),
(1068,'214','2017-03-07',1488878106,49.00,'0'),
(1069,'240','2017-03-07',1488882329,252.00,'0'),
(1070,'26','2017-03-07',1488883417,243.00,'0'),
(1071,'258','2017-03-07',1488884769,165.00,'0'),
(1072,'133','2017-03-07',1488888007,213.00,'0'),
(1073,'71','2017-03-07',1488900660,78.00,'0'),
(1074,'38','2017-03-07',1488901334,209.00,'0'),
(1075,'231','2017-03-08',1488963360,78.00,'0'),
(1076,'292','2017-03-08',1488966165,170.00,'0'),
(1077,'183','2017-03-08',1488968061,48.00,'0'),
(1078,'203','2017-03-08',1488975399,171.00,'0'),
(1079,'60','2017-03-08',1488977877,155.00,'0'),
(1080,'79','2017-03-08',1488984206,152.00,'0'),
(1081,'304','2017-03-09',1489046403,184.00,'0'),
(1082,'303','2017-03-09',1489060110,131.00,'0'),
(1083,'71','2017-03-09',1489067837,223.00,'0'),
(1084,'137','2017-03-10',1489139140,133.00,'0'),
(1085,'314','2017-03-10',1489165646,141.00,'0'),
(1086,'254','2017-03-11',1489222223,310.00,'0'),
(1087,'218','2017-03-11',1489222305,582.00,'0'),
(1088,'163','2017-03-11',1489222323,204.00,'0'),
(1089,'160','2017-03-11',1489224442,141.00,'0'),
(1090,'63','2017-03-11',1489224795,92.00,'0'),
(1091,'53','2017-03-11',1489243662,194.00,'0'),
(1092,'264','2017-03-13',1489411893,160.00,'0'),
(1093,'139','2017-03-13',1489413208,146.00,'0'),
(1094,'312','2017-03-13',1489426137,194.00,'0'),
(1095,'15','2017-03-13',1489427248,204.00,'0'),
(1096,'193','2017-03-14',1489487174,160.00,'0'),
(1097,'150','2017-03-14',1489506120,194.00,'0'),
(1098,'48','2017-03-15',1489585673,78.00,'0'),
(1099,'48','2017-03-15',1489585683,318.00,'0'),
(1100,'251','2017-03-15',1489590056,175.00,'0'),
(1101,'183','2017-03-16',1489658069,138.00,'0'),
(1102,'137','2017-03-16',1489659850,352.00,'0'),
(1103,'334','2017-03-16',1489660246,257.00,'0'),
(1104,'137','2017-03-16',1489661733,209.00,'0'),
(1105,'32','2017-03-16',1489664727,272.00,'0'),
(1106,'215','2017-03-16',1489670481,219.00,'0'),
(1107,'239','2017-03-17',1489735607,194.00,'0'),
(1108,'144','2017-03-17',1489744729,126.00,'0'),
(1109,'147','2017-03-17',1489749158,160.00,'0'),
(1110,'366','2017-03-17',1489753973,165.00,'0'),
(1111,'366','2017-03-17',1489753985,310.00,'0'),
(1112,'366','2017-03-17',1489753992,349.00,'0'),
(1113,'361','2017-03-17',1489755029,136.00,'0'),
(1114,'367','2017-03-17',1489759619,310.00,'0'),
(1115,'367','2017-03-17',1489759629,262.00,'0'),
(1116,'45','2017-03-17',1489769226,243.00,'0'),
(1117,'128','2017-03-17',1489773805,165.00,'0'),
(1118,'39','2017-03-17',1489778695,204.00,'0'),
(1119,'21','2017-03-18',1489844601,291.00,'0'),
(1120,'232','2017-03-18',1489847027,262.00,'0'),
(1121,'21','2017-03-18',1489850270,199.00,'0'),
(1122,'81','2017-03-18',1489853457,247.00,'0'),
(1123,'81','2017-03-18',1489853485,171.00,'0'),
(1124,'65','2017-03-18',1489859290,190.00,'0'),
(1125,'354','2017-03-20',1490005004,485.00,'0'),
(1126,'31','2017-03-20',1490012923,355.00,'0'),
(1127,'173','2017-03-20',1490024696,204.00,'0'),
(1128,'112','2017-03-21',1490083271,179.00,'0'),
(1129,'292','2017-03-21',1490096915,155.00,'0'),
(1130,'191','2017-03-21',1490097211,213.00,'0'),
(1131,'197','2017-03-21',1490108691,262.00,'0'),
(1132,'147','2017-03-22',1490171519,78.00,'0'),
(1133,'292','2017-03-22',1490177868,310.00,'0'),
(1134,'132','2017-03-22',1490181643,160.00,'0'),
(1135,'132','2017-03-22',1490181656,175.00,'0'),
(1136,'261','2017-03-22',1490184953,146.00,'0'),
(1137,'68','2017-03-22',1490187200,171.00,'0'),
(1138,'261','2017-03-22',1490187308,78.00,'0'),
(1139,'90','2017-03-22',1490188385,194.00,'0'),
(1140,'68','2017-03-22',1490192314,190.00,'0'),
(1141,'307','2017-03-23',1490270901,146.00,'0'),
(1142,'261','2017-03-24',1490343351,320.00,'0'),
(1143,'91','2017-03-24',1490347009,266.00,'0'),
(1144,'91','2017-03-24',1490351343,138.00,'0'),
(1145,'187','2017-03-24',1490360931,304.00,'0'),
(1146,'187','2017-03-24',1490360940,114.00,'0'),
(1147,'361','2017-03-24',1490366266,175.00,'0'),
(1148,'231','2017-03-24',1490367076,238.00,'0'),
(1149,'131','2017-03-25',1490425830,78.00,'0'),
(1150,'47','2017-03-25',1490437370,233.00,'0'),
(1151,'99','2017-03-25',1490440313,209.00,'0'),
(1152,'327','2017-03-25',1490443983,146.00,'0'),
(1153,'327','2017-03-25',1490444000,165.00,'0'),
(1154,'139','2017-03-25',1490446946,126.00,'0'),
(1155,'160','2017-03-25',1490450206,252.00,'0'),
(1156,'93','2017-03-27',1490602513,950.00,'0'),
(1157,'67','2017-03-27',1490614449,204.00,'0'),
(1158,'79','2017-03-27',1490619114,138.00,'0'),
(1159,'79','2017-03-27',1490619123,48.00,'0'),
(1160,'322','2017-03-27',1490622639,165.00,'0'),
(1161,'203','2017-03-27',1490624681,209.00,'0'),
(1162,'49','2017-03-27',1490624717,310.00,'0'),
(1163,'212','2017-03-28',1490704703,340.00,'0'),
(1164,'212','2017-03-28',1490704711,179.00,'0'),
(1165,'66','2017-03-28',1490719488,257.00,'0'),
(1166,'307','2017-03-28',1490719507,218.00,'0'),
(1167,'124','2017-03-29',1490785268,310.00,'0'),
(1168,'198','2017-03-29',1490786764,141.00,'0'),
(1169,'272','2017-03-29',1490806387,165.00,'0'),
(1170,'335','2017-03-30',1490866802,160.00,'0'),
(1171,'153','2017-03-30',1490878618,213.00,'0'),
(1172,'153','2017-03-30',1490878625,78.00,'0'),
(1173,'107','2017-03-30',1490886487,243.00,'0'),
(1174,'258','2017-03-31',1490944400,150.00,'0'),
(1175,'133','2017-03-31',1490956738,213.00,'0'),
(1176,'10','2017-03-31',1490962574,359.00,'0'),
(1177,'307','2017-03-31',1490968914,78.00,'0'),
(1178,'314','2017-03-31',1490971111,141.00,'0'),
(1179,'56','2017-04-01',1491040974,160.00,'0'),
(1180,'212','2017-04-01',1491041131,68.00,'0'),
(1181,'37','2017-04-03',1491199771,223.00,'0'),
(1182,'115','2017-04-03',1491199807,147.00,'0'),
(1183,'364','2017-04-03',1491207427,155.00,'0'),
(1184,'231','2017-04-03',1491213043,49.00,'0'),
(1185,'231','2017-04-03',1491213047,126.00,'0'),
(1186,'220','2017-04-03',1491214157,475.00,'0'),
(1187,'66','2017-04-03',1491219049,126.00,'0'),
(1188,'292','2017-04-03',1491234875,160.00,'0'),
(1189,'291','2017-04-03',1491244105,272.00,'0'),
(1190,'291','2017-04-03',1491244105,272.00,'0'),
(1191,'204','2017-04-04',1491292149,262.00,'0'),
(1192,'173','2017-04-11',1491913012,223.00,'0'),
(1193,'188','2017-04-11',1491913612,304.00,'0'),
(1194,'150','2017-04-11',1491921450,281.00,'0'),
(1195,'239','2017-04-12',1491978082,252.00,'0'),
(1196,'362','2017-04-12',1491983354,78.00,'0'),
(1197,'93','2017-04-12',1491983587,238.00,'0'),
(1198,'65','2017-04-12',1491987573,494.00,'0'),
(1199,'193','2017-04-12',1491991149,146.00,'0'),
(1200,'17','2017-04-12',1491991358,252.00,'0'),
(1201,'65','2017-04-12',1491992199,76.00,'0'),
(1202,'318','2017-04-12',1491993911,400.00,'0'),
(1203,'258','2017-04-12',1491995603,175.00,'0'),
(1204,'70','2017-04-12',1491995965,233.00,'0'),
(1205,'335','2017-04-12',1491996840,78.00,'0'),
(1206,'81','2017-04-12',1492008669,200.00,'0'),
(1207,'81','2017-04-12',1492011532,200.00,'0'),
(1208,'183','2017-04-12',1492014295,181.00,'0'),
(1209,'38','2017-04-12',1492017096,262.00,'0'),
(1210,'32','2017-04-13',1492069423,223.00,'0'),
(1211,'307','2017-04-13',1492079784,310.00,'0'),
(1212,'303','2017-04-13',1492081230,155.00,'0'),
(1213,'366','2017-04-13',1492086180,175.00,'0'),
(1214,'366','2017-04-13',1492086190,233.00,'0'),
(1215,'366','2017-04-13',1492086202,155.00,'0'),
(1216,'46','2017-04-13',1492088976,310.00,'0'),
(1217,'46','2017-04-13',1492089001,126.00,'0'),
(1218,'46','2017-04-13',1492089011,204.00,'0'),
(1219,'68','2017-04-13',1492090738,437.00,'0'),
(1220,'68','2017-04-13',1492090784,304.00,'0'),
(1221,'68','2017-04-13',1492090818,76.00,'0'),
(1222,'233','2017-04-13',1492098940,243.00,'0'),
(1223,'71','2017-04-13',1492099995,194.00,'0'),
(1224,'196','2017-04-13',1492102219,126.00,'0'),
(1225,'71','2017-04-13',1492109100,262.00,'0'),
(1226,'137','2017-04-14',1492156349,228.00,'0'),
(1227,'91','2017-04-14',1492160042,157.00,'0'),
(1228,'240','2017-04-14',1492165011,243.00,'0'),
(1229,'101','2017-04-14',1492170252,310.00,'0'),
(1230,'363','2017-04-14',1492172023,243.00,'0'),
(1231,'15','2017-04-14',1492179992,194.00,'0'),
(1232,'292','2017-04-14',1492180373,146.00,'0'),
(1233,'79','2017-04-14',1492183860,138.00,'0'),
(1234,'188','2017-04-14',1492186172,285.00,'0'),
(1235,'104','2017-04-14',1492188225,233.00,'0'),
(1236,'279','2017-04-14',1492190243,533.00,'0'),
(1237,'112','2017-04-14',1492191417,146.00,'0'),
(1238,'138','2017-04-14',1492194472,141.00,'0'),
(1239,'312','2017-04-14',1492195771,194.00,'0'),
(1240,'25','2017-04-15',1492247976,171.00,'0'),
(1241,'15','2017-04-19',1492600179,243.00,'0'),
(1242,'280','2017-04-21',1492784713,78.00,'0'),
(1243,'280','2017-04-21',1492784726,15.00,'0'),
(1244,'149','2017-04-24',1493036513,166.00,'0'),
(1245,'327','2017-04-24',1493036976,189.00,'0'),
(1246,'20','2017-04-25',1493111473,213.00,'0'),
(1247,'296','2017-04-25',1493122185,136.00,'0'),
(1248,'280','2017-04-25',1493124641,155.00,'0'),
(1249,'10','2017-04-25',1493128991,243.00,'0'),
(1250,'67','2017-04-25',1493130428,243.00,'0'),
(1251,'373','2017-04-26',1493220390,347.00,'0'),
(1252,'373','2017-04-26',1493220482,141.00,'0'),
(1253,'153','2017-04-26',1493224766,194.00,'0'),
(1254,'364','2017-04-29',1493450248,78.00,'0'),
(1255,'364','2017-04-29',1493450255,146.00,'0'),
(1256,'138','2017-04-29',1493464189,194.00,'0'),
(1257,'143','2017-04-29',1493464687,238.00,'0'),
(1258,'314','2017-04-29',1493470670,131.00,'0'),
(1259,'21','2017-04-29',1493480963,194.00,'0'),
(1260,'378','2017-04-30',1493541092,243.00,'0'),
(1261,'378','2017-04-30',1493541092,243.00,'0'),
(1262,'379','2017-04-30',1493541105,243.00,'0'),
(1263,'15','2017-04-30',1493543416,194.00,'0'),
(1264,'191','2017-05-01',1493640689,1009.00,'0'),
(1265,'239','2017-05-01',1493650542,243.00,'0'),
(1266,'292','2017-05-02',1493710780,209.00,'0'),
(1267,'31','2017-05-02',1493712282,461.00,'0'),
(1268,'91','2017-05-02',1493712902,285.00,'0'),
(1269,'36','2017-05-02',1493715868,970.00,'0'),
(1270,'250','2017-05-02',1493718976,310.00,'0'),
(1271,'167','2017-05-02',1493721233,351.00,'0'),
(1272,'361','2017-05-02',1493721916,175.00,'0'),
(1273,'307','2017-05-02',1493722600,213.00,'0'),
(1274,'31','2017-05-02',1493724540,121.00,'0'),
(1275,'31','2017-05-02',1493724558,78.00,'0'),
(1276,'96','2017-05-02',1493727719,301.00,'0'),
(1277,'96','2017-05-02',1493727724,49.00,'0'),
(1278,'79','2017-05-02',1493729620,333.00,'0'),
(1279,'79','2017-05-02',1493729632,48.00,'0'),
(1280,'68','2017-05-02',1493741404,304.00,'0'),
(1281,'115','2017-05-02',1493741719,333.00,'0'),
(1282,'125','2017-05-03',1493793537,310.00,'0'),
(1283,'70','2017-05-03',1493802980,194.00,'0'),
(1284,'70','2017-05-03',1493802986,82.00,'0'),
(1285,'123','2017-05-03',1493809657,170.00,'0'),
(1286,'193','2017-05-03',1493819517,141.00,'0'),
(1287,'381','2017-05-03',1493826340,1108.00,'0'),
(1288,'81','2017-05-03',1493826486,171.00,'0'),
(1289,'133','2017-05-03',1493829208,262.00,'0'),
(1290,'219','2017-05-03',1493836949,361.00,'0'),
(1291,'184','2017-05-04',1493887624,281.00,'0'),
(1292,'137','2017-05-04',1493897168,209.00,'0'),
(1293,'137','2017-05-04',1493897668,209.00,'0'),
(1294,'373','2017-05-04',1493897709,175.00,'0'),
(1295,'184','2017-05-04',1493901294,141.00,'0'),
(1296,'219','2017-05-04',1493914460,650.00,'0'),
(1297,'219','2017-05-04',1493914497,152.00,'0'),
(1298,'250','2017-05-05',1493962865,272.00,'0'),
(1299,'25','2017-05-05',1493973049,171.00,'0'),
(1300,'382','2017-05-05',1493973683,310.00,'0'),
(1301,'203','2017-05-05',1493980912,171.00,'0'),
(1302,'335','2017-05-05',1493982041,78.00,'0'),
(1303,'383','2017-05-05',1493989877,68.00,'0'),
(1304,'353','2017-05-05',1493991240,440.00,'0'),
(1305,'325','2017-05-06',1494053118,175.00,'0'),
(1306,'277','2017-05-06',1494054395,155.00,'0'),
(1307,'376','2017-05-06',1494058782,160.00,'0'),
(1308,'79','2017-05-06',1494059436,157.00,'0'),
(1309,'143','2017-05-06',1494062668,138.00,'0'),
(1310,'143','2017-05-06',1494062675,95.00,'0'),
(1311,'147','2017-05-06',1494070921,223.00,'0'),
(1312,'326','2017-05-06',1494073428,175.00,'0'),
(1313,'331','2017-05-06',1494074878,243.00,'0'),
(1314,'49','2017-05-06',1494076644,78.00,'0'),
(1315,'183','2017-05-06',1494078046,266.00,'0'),
(1316,'183','2017-05-06',1494078069,138.00,'0'),
(1317,'53','2017-05-06',1494092873,228.00,'0'),
(1318,'163','2017-05-08',1494229585,490.00,'0'),
(1319,'197','2017-05-08',1494232319,243.00,'0'),
(1320,'163','2017-05-08',1494232965,490.00,'0'),
(1321,'231','2017-05-08',1494238962,291.00,'0'),
(1322,'364','2017-05-08',1494247883,407.00,'0'),
(1323,'36','2017-05-08',1494251505,141.00,'0'),
(1324,'72','2017-05-08',1494251540,189.00,'0'),
(1325,'17','2017-05-09',1494314264,199.00,'0'),
(1326,'17','2017-05-09',1494314264,199.00,'0'),
(1327,'333','2017-05-09',1494315241,201.00,'0'),
(1328,'375','2017-05-09',1494327984,231.00,'0'),
(1329,'119','2017-05-09',1494332102,970.00,'0'),
(1330,'137','2017-05-09',1494332610,143.00,'0'),
(1331,'335','2017-05-10',1494409894,291.00,'0'),
(1332,'304','2017-05-10',1494415753,194.00,'0'),
(1333,'81','2017-05-10',1494422868,257.00,'0'),
(1334,'303','2017-05-10',1494423630,78.00,'0'),
(1335,'34','2017-05-10',1494428150,272.00,'0'),
(1336,'112','2017-05-11',1494481096,141.00,'0'),
(1337,'48','2017-05-11',1494489052,78.00,'0'),
(1338,'48','2017-05-11',1494489060,369.00,'0'),
(1339,'137','2017-05-11',1494496868,285.00,'0'),
(1340,'130','2017-05-11',1494496958,214.00,'0'),
(1341,'50','2017-05-11',1494498604,1601.00,'0'),
(1342,'370','2017-05-11',1494506630,291.00,'0'),
(1343,'370','2017-05-11',1494506645,218.00,'0'),
(1344,'65','2017-05-11',1494509761,247.00,'0'),
(1345,'307','2017-05-11',1494509875,78.00,'0'),
(1346,'291','2017-05-11',1494516474,233.00,'0'),
(1347,'336','2017-05-12',1494574351,310.00,'0'),
(1348,'270','2017-05-12',1494579721,126.00,'0'),
(1349,'175','2017-05-12',1494582912,194.00,'0'),
(1350,'322','2017-05-12',1494586176,291.00,'0'),
(1351,'65','2017-05-13',1494662337,304.00,'0'),
(1352,'82','2017-05-13',1494666910,685.00,'0'),
(1353,'176','2017-05-13',1494667627,171.00,'0'),
(1354,'221','2017-05-13',1494673984,228.00,'0'),
(1355,'388','2017-05-13',1494679883,160.00,'0'),
(1356,'115','2017-05-13',1494680324,366.00,'0'),
(1357,'153','2017-05-13',1494683570,87.00,'0'),
(1358,'342','2017-05-13',1494688800,369.00,'0'),
(1359,'292','2017-05-16',1494919541,310.00,'0'),
(1360,'196','2017-05-16',1494924319,427.00,'0'),
(1361,'389','2017-05-16',1494924548,87.00,'0'),
(1362,'196','2017-05-16',1494944708,272.00,'0'),
(1363,'21','2017-05-17',1495006847,199.00,'0'),
(1364,'10','2017-05-17',1495016627,301.00,'0'),
(1365,'10','2017-05-17',1495016635,87.00,'0'),
(1366,'90','2017-05-17',1495024351,306.00,'0'),
(1367,'240','2017-05-17',1495028854,223.00,'0'),
(1368,'139','2017-05-17',1495031454,204.00,'0'),
(1369,'139','2017-05-17',1495031459,126.00,'0'),
(1370,'322','2017-05-18',1495101942,146.00,'0'),
(1371,'322','2017-05-18',1495107192,272.00,'0'),
(1372,'15','2017-05-18',1495111980,194.00,'0'),
(1373,'93','2017-05-19',1495181114,475.00,'0'),
(1374,'175','2017-05-19',1495186764,223.00,'0'),
(1375,'335','2017-05-19',1495187826,291.00,'0'),
(1376,'296','2017-05-19',1495189099,262.00,'0'),
(1377,'60','2017-05-19',1495194519,456.00,'0'),
(1378,'191','2017-05-19',1495210189,906.00,'0'),
(1379,'10','2017-05-20',1495263921,485.00,'0'),
(1380,'72','2017-05-20',1495264462,209.00,'0'),
(1381,'173','2017-05-20',1495265153,126.00,'0'),
(1382,'361','2017-05-20',1495269101,170.00,'0'),
(1383,'361','2017-05-20',1495269107,175.00,'0'),
(1384,'38','2017-05-20',1495270516,213.00,'0'),
(1385,'45','2017-05-20',1495274507,150.00,'0'),
(1386,'82','2017-05-20',1495278726,310.00,'0'),
(1387,'82','2017-05-20',1495278731,87.00,'0'),
(1388,'104','2017-05-20',1495278778,262.00,'0'),
(1389,'368','2017-05-20',1495289929,175.00,'0'),
(1390,'393','2017-05-20',1495290882,698.00,'0'),
(1391,'191','2017-05-23',1495520143,190.00,'0'),
(1392,'209','2017-05-23',1495535841,48.00,'0'),
(1393,'209','2017-05-23',1495535878,228.00,'0'),
(1394,'209','2017-05-23',1495535888,76.00,'0'),
(1395,'269','2017-05-23',1495538829,766.00,'0'),
(1396,'1','2017-05-24',1495625474,291.00,'0'),
(1397,'104','2017-05-24',1495627557,44.00,'0'),
(1398,'390','2017-05-24',1495634513,116.00,'0'),
(1399,'81','2017-05-24',1495634988,171.00,'0'),
(1400,'114','2017-05-24',1495642101,399.00,'0'),
(1401,'125','2017-05-24',1495642823,272.00,'0'),
(1402,'32','2017-05-25',1495699605,301.00,'0'),
(1403,'81','2017-05-25',1495699955,181.00,'0'),
(1404,'81','2017-05-25',1495699982,190.00,'0'),
(1405,'131','2017-05-25',1495705445,87.00,'0'),
(1406,'379','2017-05-25',1495712371,184.00,'0'),
(1407,'167','2017-05-25',1495714855,78.00,'0'),
(1408,'350','2017-05-26',1495797539,175.00,'0'),
(1409,'239','2017-05-26',1495805288,243.00,'0'),
(1410,'150','2017-05-26',1495807394,194.00,'0'),
(1411,'191','2017-05-26',1495809967,304.00,'0'),
(1412,'125','2017-05-26',1495813973,175.00,'0'),
(1413,'66','2017-05-26',1495823440,247.00,'0'),
(1414,'233','2017-05-27',1495875951,209.00,'0'),
(1415,'153','2017-05-27',1495884570,267.00,'0'),
(1416,'366','2017-05-27',1495885586,301.00,'0'),
(1417,'130','2017-05-27',1495886085,333.00,'0'),
(1418,'366','2017-05-27',1495889951,310.00,'0'),
(1419,'366','2017-05-27',1495889964,310.00,'0'),
(1420,'366','2017-05-27',1495889973,223.00,'0'),
(1421,'49','2017-05-27',1495892358,194.00,'0'),
(1422,'49','2017-05-27',1495892559,310.00,'0'),
(1423,'143','2017-05-27',1495893889,304.00,'0'),
(1424,'160','2017-05-27',1495896889,160.00,'0'),
(1425,'1','2017-05-28',1495952335,291.00,'0'),
(1426,'84','2017-05-29',1496041440,136.00,'0'),
(1427,'364','2017-05-30',1496130065,146.00,'0'),
(1428,'364','2017-05-30',1496130074,78.00,'0'),
(1429,'65','2017-05-30',1496137212,190.00,'0'),
(1430,'65','2017-05-30',1496137230,76.00,'0'),
(1431,'65','2017-05-30',1496137246,171.00,'0'),
(1432,'399','2017-05-30',1496139405,252.00,'0'),
(1433,'250','2017-05-30',1496139789,213.00,'0'),
(1434,'149','2017-05-30',1496142504,155.00,'0'),
(1435,'149','2017-05-30',1496142515,247.00,'0'),
(1436,'68','2017-05-30',1496143467,114.00,'0'),
(1437,'212','2017-05-30',1496148460,252.00,'0'),
(1438,'212','2017-05-30',1496148486,165.00,'0'),
(1439,'212','2017-05-30',1496148498,68.00,'0'),
(1440,'212','2017-05-30',1496148517,175.00,'0'),
(1441,'212','2017-05-30',1496148602,97.00,'0'),
(1442,'307','2017-05-30',1496152792,87.00,'0'),
(1443,'31','2017-05-30',1496153816,238.00,'0'),
(1444,'31','2017-05-30',1496153835,76.00,'0'),
(1445,'401','2017-05-30',1496156565,679.00,'0'),
(1446,'373','2017-05-31',1496230156,485.00,'0'),
(1447,'373','2017-05-31',1496230167,155.00,'0'),
(1448,'45','2017-05-31',1496235802,194.00,'0'),
(1449,'183','2017-05-31',1496237021,475.00,'0'),
(1450,'183','2017-05-31',1496237032,48.00,'0'),
(1451,'114','2017-05-31',1496242768,631.00,'0'),
(1452,'373','2017-05-31',1496244097,175.00,'0'),
(1453,'384','2017-05-31',1496247589,281.00,'0'),
(1454,'144','2017-06-01',1496304250,213.00,'0'),
(1455,'351','2017-06-02',1496388370,194.00,'0'),
(1456,'70','2017-06-02',1496396044,262.00,'0'),
(1457,'403','2017-06-02',1496396943,752.00,'0'),
(1458,'313','2017-06-02',1496397344,209.00,'0'),
(1459,'313','2017-06-02',1496397398,340.00,'0'),
(1460,'224','2017-06-02',1496401351,78.00,'0'),
(1461,'325','2017-06-03',1496473031,194.00,'0'),
(1462,'400','2017-06-03',1496479073,68.00,'0'),
(1463,'313','2017-06-03',1496481009,340.00,'0'),
(1464,'143','2017-06-03',1496490517,266.00,'0'),
(1465,'261','2017-06-03',1496491578,87.00,'0'),
(1466,'261','2017-06-03',1496498102,58.00,'0'),
(1467,'261','2017-06-03',1496503689,146.00,'0'),
(1468,'53','2017-06-03',1496511984,204.00,'0'),
(1469,'327','2017-06-05',1496650510,78.00,'0'),
(1470,'335','2017-06-05',1496654441,179.00,'0'),
(1471,'405','2017-06-05',1496655571,170.00,'0'),
(1472,'227','2017-06-05',1496667800,204.00,'0'),
(1473,'371','2017-06-06',1496736223,87.00,'0'),
(1474,'25','2017-06-06',1496741560,190.00,'0'),
(1475,'268','2017-06-06',1496751999,136.00,'0'),
(1476,'268','2017-06-06',1496752013,126.00,'0'),
(1477,'114','2017-06-06',1496765392,291.00,'0'),
(1478,'114','2017-06-06',1496765401,310.00,'0'),
(1479,'140','2017-06-06',1496768173,340.00,'0'),
(1480,'231','2017-06-07',1496816150,136.00,'0'),
(1481,'67','2017-06-07',1496821327,262.00,'0'),
(1482,'25','2017-06-07',1496824618,238.00,'0'),
(1483,'335','2017-06-07',1496829173,87.00,'0'),
(1484,'376','2017-06-07',1496836316,291.00,'0'),
(1485,'376','2017-06-07',1496836801,49.00,'0'),
(1486,'390','2017-06-07',1496837812,340.00,'0'),
(1487,'376','2017-06-07',1496837957,58.00,'0'),
(1488,'268','2017-06-07',1496840639,177.00,'0'),
(1489,'268','2017-06-07',1496840639,177.00,'0'),
(1490,'251','2017-06-07',1496842422,340.00,'0'),
(1491,'140','2017-06-07',1496849288,970.00,'0'),
(1492,'140','2017-06-07',1496849321,432.00,'0'),
(1493,'112','2017-06-08',1496901062,165.00,'0'),
(1494,'387','2017-06-08',1496902234,204.00,'0'),
(1495,'408','2017-06-08',1496905108,378.00,'0'),
(1496,'71','2017-06-08',1496907414,213.00,'0'),
(1497,'269','2017-06-08',1496910331,970.00,'0'),
(1498,'183','2017-06-08',1496923784,333.00,'0'),
(1499,'183','2017-06-08',1496923835,171.00,'0'),
(1500,'183','2017-06-08',1496923944,133.00,'0');

INSERT INTO `DELETE_realizatsia` VALUES 
(1501,'183','2017-06-08',1496923954,133.00,'0'),
(1502,'137','2017-06-08',1496924916,228.00,'0'),
(1503,'379','2017-06-09',1496999760,78.00,'0'),
(1504,'196','2017-06-09',1497003025,160.00,'0'),
(1505,'183','2017-06-09',1497003068,475.00,'0'),
(1506,'137','2017-06-09',1497003142,209.00,'0'),
(1507,'137','2017-06-09',1497003151,152.00,'0'),
(1508,'321','2017-06-09',1497031447,165.00,'0'),
(1509,'21','2017-06-10',1497073741,204.00,'0'),
(1510,'379','2017-06-10',1497086588,243.00,'0'),
(1511,'361','2017-06-10',1497086612,194.00,'0'),
(1512,'34','2017-06-10',1497088899,281.00,'0'),
(1513,'128','2017-06-10',1497090989,160.00,'0'),
(1514,'34','2017-06-10',1497102340,349.00,'0'),
(1515,'31','2017-06-10',1497102696,143.00,'0'),
(1516,'56','2017-06-10',1497111839,175.00,'0'),
(1517,'176','2017-06-12',1497246414,200.00,'0'),
(1518,'167','2017-06-12',1497258961,78.00,'0'),
(1519,'147','2017-06-12',1497262842,363.00,'0'),
(1520,'388','2017-06-12',1497275562,262.00,'0'),
(1521,'116','2017-06-12',1497277442,267.00,'0'),
(1522,'15','2017-06-12',1497280888,204.00,'0'),
(1523,'194','2017-06-12',1497282956,194.00,'0'),
(1524,'119','2017-06-13',1497342790,485.00,'0'),
(1525,'123','2017-06-13',1497349554,184.00,'0'),
(1526,'342','2017-06-13',1497356792,262.00,'0'),
(1527,'239','2017-06-13',1497365483,204.00,'0'),
(1528,'176','2017-06-14',1497422953,333.00,'0'),
(1529,'47','2017-06-14',1497431095,262.00,'0'),
(1530,'196','2017-06-14',1497435116,340.00,'0'),
(1531,'292','2017-06-14',1497443718,555.00,'0'),
(1532,'1','2017-06-14',1497446838,194.00,'0'),
(1533,'1','2017-06-14',1497446838,194.00,'0'),
(1534,'1','2017-06-14',1497446877,87.00,'0'),
(1535,'191','2017-06-14',1497451098,190.00,'0'),
(1536,'191','2017-06-15',1497512914,209.00,'0'),
(1537,'292','2017-06-15',1497515398,233.00,'0'),
(1538,'153','2017-06-15',1497523234,87.00,'0'),
(1539,'215','2017-06-15',1497524866,200.00,'0'),
(1540,'25','2017-06-15',1497530186,141.00,'0'),
(1541,'222','2017-06-15',1497532046,223.00,'0'),
(1542,'222','2017-06-15',1497534773,87.00,'0'),
(1543,'321','2017-06-16',1497602211,136.00,'0'),
(1544,'65','2017-06-16',1497606465,209.00,'0'),
(1545,'269','2017-06-16',1497606757,266.00,'0'),
(1546,'292','2017-06-16',1497617439,194.00,'0'),
(1547,'104','2017-06-16',1497619302,213.00,'0'),
(1548,'224','2017-06-16',1497621660,136.00,'0'),
(1549,'304','2017-06-16',1497623450,213.00,'0'),
(1550,'125','2017-06-16',1497630348,340.00,'0'),
(1551,'93','2017-06-17',1497678743,200.00,'0'),
(1552,'93','2017-06-17',1497678743,200.00,'0'),
(1553,'196','2017-06-17',1497687191,970.00,'0'),
(1554,'298','2017-06-17',1497689184,182.00,'0'),
(1555,'65','2017-06-17',1497689970,124.00,'0'),
(1556,'65','2017-06-17',1497689970,124.00,'0'),
(1557,'25','2017-06-17',1497694669,257.00,'0'),
(1558,'138','2017-06-17',1497699141,126.00,'0'),
(1559,'138','2017-06-17',1497699167,170.00,'0'),
(1560,'351','2017-06-17',1497706192,340.00,'0'),
(1561,'351','2017-06-17',1497706192,340.00,'0'),
(1562,'291','2017-06-17',1497714202,239.00,'0'),
(1563,'19','2017-06-20',1497937161,179.00,'0'),
(1564,'65','2017-06-20',1497948589,333.00,'0'),
(1565,'81','2017-06-20',1497952708,285.00,'0'),
(1566,'81','2017-06-20',1497952764,190.00,'0'),
(1567,'167','2017-06-20',1497961675,150.00,'0'),
(1568,'363','2017-06-20',1497968050,194.00,'0'),
(1569,'363','2017-06-20',1497968057,146.00,'0'),
(1570,'45','2017-06-20',1497974316,262.00,'0'),
(1571,'296','2017-06-21',1498035790,165.00,'0'),
(1572,'90','2017-06-21',1498048314,204.00,'0'),
(1573,'413','2017-06-21',1498048935,223.00,'0'),
(1574,'348','2017-06-21',1498053078,209.00,'0'),
(1575,'322','2017-06-21',1498057231,170.00,'0'),
(1576,'146','2017-06-21',1498057453,340.00,'0'),
(1577,'130','2017-06-22',1498111202,219.00,'0'),
(1578,'234','2017-06-22',1498115385,155.00,'0'),
(1579,'119','2017-06-22',1498119424,359.00,'0'),
(1580,'379','2017-06-22',1498125742,213.00,'0'),
(1581,'378','2017-06-22',1498125749,78.00,'0'),
(1582,'379','2017-06-22',1498125764,78.00,'0'),
(1583,'261','2017-06-22',1498140343,165.00,'0'),
(1584,'203','2017-06-22',1498149931,589.00,'0'),
(1585,'133','2017-06-22',1498155787,310.00,'0'),
(1586,'402','2017-06-23',1498208566,320.00,'0'),
(1587,'175','2017-06-23',1498211790,262.00,'0'),
(1588,'82','2017-06-23',1498218592,204.00,'0'),
(1589,'307','2017-06-23',1498219245,320.00,'0'),
(1590,'81','2017-06-24',1498287095,124.00,'0'),
(1591,'378','2017-06-24',1498287790,243.00,'0'),
(1592,'37','2017-06-24',1498313507,252.00,'0'),
(1593,'394','2017-06-24',1498313867,340.00,'0'),
(1594,'364','2017-06-26',1498480204,311.00,'0'),
(1595,'364','2017-06-26',1498480795,209.00,'0'),
(1596,'250','2017-06-26',1498482866,78.00,'0'),
(1597,'250','2017-06-26',1498494819,243.00,'0'),
(1598,'153','2017-06-27',1498559584,233.00,'0'),
(1599,'322','2017-06-27',1498566132,243.00,'0'),
(1600,'119','2017-06-27',1498566324,194.00,'0'),
(1601,'423','2017-06-27',1498568782,78.00,'0'),
(1602,'125','2017-06-27',1498571570,204.00,'0'),
(1603,'212','2017-06-28',1498641835,185.00,'0'),
(1604,'212','2017-06-28',1498641849,190.00,'0'),
(1605,'212','2017-06-28',1498645285,76.00,'0'),
(1606,'212','2017-06-28',1498650916,76.00,'0'),
(1607,'212','2017-06-28',1498650984,138.00,'0'),
(1608,'361','2017-06-28',1498658433,184.00,'0'),
(1609,'268','2017-06-28',1498660805,340.00,'0'),
(1610,'396','2017-06-29',1498720258,970.00,'0'),
(1611,'234','2017-06-29',1498723013,340.00,'0'),
(1612,'241','2017-06-29',1498725928,340.00,'0'),
(1613,'353','2017-06-29',1498738286,582.00,'0'),
(1614,'356','2017-06-29',1498755830,175.00,'0'),
(1615,'368','2017-06-30',1498812933,78.00,'0'),
(1616,'404','2017-07-01',1498906902,175.00,'0'),
(1617,'53','2017-07-01',1498906970,821.00,'0'),
(1618,'124','2017-07-01',1498913111,281.00,'0'),
(1619,'393','2017-07-03',1499061658,388.00,'0'),
(1620,'393','2017-07-03',1499061692,340.00,'0'),
(1621,'387','2017-07-03',1499102003,204.00,'0'),
(1622,'358','2017-07-04',1499156634,340.00,'0'),
(1623,'358','2017-07-04',1499156648,146.00,'0'),
(1624,'412','2017-07-04',1499161081,209.00,'0'),
(1625,'60','2017-07-04',1499169251,179.00,'0'),
(1626,'60','2017-07-04',1499169251,179.00,'0'),
(1627,'183','2017-07-04',1499173850,333.00,'0'),
(1628,'183','2017-07-04',1499173912,950.00,'0'),
(1629,'373','2017-07-04',1499173944,485.00,'0'),
(1630,'373','2017-07-04',1499173970,970.00,'0'),
(1631,'183','2017-07-04',1499174253,67.00,'0'),
(1632,'187','2017-07-04',1499175280,133.00,'0'),
(1633,'187','2017-07-04',1499175298,209.00,'0'),
(1634,'25','2017-07-04',1499176888,266.00,'0'),
(1635,'321','2017-07-04',1499179803,49.00,'0'),
(1636,'112','2017-07-04',1499180544,160.00,'0'),
(1637,'384','2017-07-04',1499181550,223.00,'0'),
(1638,'68','2017-07-04',1499182368,325.00,'0'),
(1639,'401','2017-07-04',1499186002,175.00,'0'),
(1640,'329','2017-07-04',1499186121,58.00,'0'),
(1641,'395','2017-07-05',1499254901,136.00,'0'),
(1642,'150','2017-07-06',1499351084,340.00,'0'),
(1643,'183','2017-07-06',1499356228,176.00,'0'),
(1644,'183','2017-07-06',1499356238,128.00,'0'),
(1645,'183','2017-07-06',1499356255,171.00,'0'),
(1646,'183','2017-07-06',1499356282,200.00,'0'),
(1647,'272','2017-07-06',1499358512,179.00,'0'),
(1648,'227','2017-07-08',1499513691,213.00,'0'),
(1649,'335','2017-07-08',1499515643,243.00,'0'),
(1650,'71','2017-07-10',1499677941,291.00,'0'),
(1651,'137','2017-07-10',1499678485,276.00,'0'),
(1652,'123','2017-07-10',1499679272,189.00,'0'),
(1653,'415','2017-07-10',1499684143,209.00,'0'),
(1654,'292','2017-07-10',1499689393,126.00,'0'),
(1655,'183','2017-07-10',1499689653,57.00,'0'),
(1656,'196','2017-07-11',1499763557,141.00,'0'),
(1657,'196','2017-07-11',1499763585,194.00,'0'),
(1658,'423','2017-07-11',1499764452,223.00,'0'),
(1659,'137','2017-07-11',1499768038,138.00,'0'),
(1660,'15','2017-07-11',1499769678,233.00,'0'),
(1661,'153','2017-07-11',1499772633,87.00,'0'),
(1662,'65','2017-07-11',1499773188,266.00,'0'),
(1663,'65','2017-07-11',1499773198,133.00,'0'),
(1664,'65','2017-07-11',1499773227,190.00,'0'),
(1665,'65','2017-07-11',1499773254,86.00,'0'),
(1666,'239','2017-07-11',1499778892,204.00,'0'),
(1667,'191','2017-07-11',1499779054,190.00,'0'),
(1668,'19','2017-07-11',1499789354,204.00,'0'),
(1669,'292','2017-07-13',1499933383,475.00,'0'),
(1670,'196','2017-07-13',1499934099,209.00,'0'),
(1671,'1','2017-07-13',1499944656,204.00,'0'),
(1672,'1','2017-07-13',1499944671,252.00,'0'),
(1673,'373','2017-07-13',1499944935,262.00,'0'),
(1674,'419','2017-07-13',1499949297,126.00,'0'),
(1675,'223','2017-07-13',1499954158,1556.00,'0'),
(1676,'264','2017-07-13',1499956940,97.00,'0'),
(1677,'233','2017-07-13',1499961668,213.00,'0'),
(1678,'244','2017-07-13',1499965222,160.00,'0'),
(1679,'317','2017-07-14',1500015312,155.00,'0'),
(1680,'56','2017-07-14',1500017251,136.00,'0'),
(1681,'85','2017-07-14',1500032501,179.00,'0'),
(1682,'104','2017-07-14',1500037272,233.00,'0'),
(1683,'68','2017-07-14',1500042090,19.00,'0'),
(1684,'304','2017-07-14',1500049357,204.00,'0'),
(1685,'74','2017-07-15',1500093490,340.00,'0'),
(1686,'21','2017-07-15',1500102200,204.00,'0'),
(1687,'138','2017-07-15',1500102234,136.00,'0'),
(1688,'221','2017-07-15',1500104170,970.00,'0'),
(1689,'1','2017-07-15',1500112725,534.00,'0'),
(1690,'362','2017-07-15',1500113440,291.00,'0'),
(1691,'362','2017-07-15',1500113445,87.00,'0'),
(1692,'104','2017-07-15',1500116246,146.00,'0'),
(1693,'363','2017-07-15',1500117126,223.00,'0'),
(1694,'363','2017-07-15',1500117143,141.00,'0'),
(1695,'192','2017-07-15',1500118559,194.00,'0'),
(1696,'81','2017-07-15',1500124425,204.00,'0'),
(1697,'417','2017-07-15',1500124444,179.00,'0'),
(1698,'417','2017-07-15',1500124458,136.00,'0'),
(1699,'321','2017-07-15',1500134816,160.00,'0'),
(1700,'183','2017-07-18',1500390033,950.00,'0'),
(1701,'291','2017-07-20',1500556258,254.00,'0'),
(1702,'280','2017-07-21',1500614838,160.00,'0'),
(1703,'183','2017-07-21',1500621795,950.00,'0'),
(1704,'183','2017-07-21',1500621806,523.00,'0'),
(1705,'183','2017-07-21',1500621823,542.00,'0'),
(1706,'231','2017-07-21',1500632965,238.00,'0'),
(1707,'231','2017-07-21',1500633150,141.00,'0'),
(1708,'193','2017-07-21',1500648484,160.00,'0'),
(1709,'351','2017-07-22',1500727293,194.00,'0'),
(1710,'125','2017-07-22',1500736168,194.00,'0'),
(1711,'45','2017-07-22',1500737351,204.00,'0'),
(1712,'307','2017-07-25',1500961454,218.00,'0'),
(1713,'383','2017-07-25',1500965764,204.00,'0'),
(1714,'93','2017-07-25',1500970579,213.00,'0'),
(1715,'395','2017-07-25',1500975019,281.00,'0'),
(1716,'438','2017-07-25',1500976174,213.00,'0'),
(1717,'438','2017-07-25',1500976181,146.00,'0'),
(1718,'438','2017-07-25',1500976187,87.00,'0'),
(1719,'438','2017-07-25',1500977072,87.00,'0'),
(1720,'99','2017-07-25',1500978309,335.00,'0'),
(1721,'99','2017-07-25',1500984326,243.00,'0'),
(1722,'7','2017-07-25',1500984445,136.00,'0'),
(1723,'426','2017-07-25',1500989062,252.00,'0'),
(1724,'438','2017-07-25',1500989293,175.00,'0'),
(1725,'268','2017-07-25',1500997622,175.00,'0'),
(1726,'91','2017-07-26',1501053293,428.00,'0'),
(1727,'91','2017-07-26',1501053300,124.00,'0'),
(1728,'91','2017-07-26',1501053335,285.00,'0'),
(1729,'81','2017-07-26',1501066802,190.00,'0'),
(1730,'153','2017-07-27',1501143883,223.00,'0'),
(1731,'396','2017-07-27',1501155032,223.00,'0'),
(1732,'396','2017-07-27',1501155076,330.00,'0'),
(1733,'439','2017-07-27',1501161235,150.00,'0'),
(1734,'212','2017-07-28',1501235303,195.00,'0'),
(1735,'212','2017-07-28',1501237138,133.00,'0'),
(1736,'212','2017-07-28',1501242112,333.00,'0'),
(1737,'187','2017-07-28',1501244067,200.00,'0');

DROP TABLE IF EXISTS `DELETE_slideshow`;

CREATE TABLE `DELETE_slideshow` (
  `id` smallint(4) NOT NULL auto_increment,
  `sort` smallint(4) NOT NULL,
  `url` varchar(255) collate utf8_unicode_ci NOT NULL,
  `h1_uk` varchar(255) collate utf8_unicode_ci NOT NULL,
  `text_uk` varchar(255) collate utf8_unicode_ci NOT NULL,
  `h1_ru` varchar(255) collate utf8_unicode_ci NOT NULL,
  `text_ru` varchar(255) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Слайд шоу';

DROP TABLE IF EXISTS `DELETE_users`;

CREATE TABLE `DELETE_users` (
  `id` mediumint(5) NOT NULL auto_increment,
  `email` varchar(25) collate utf8_unicode_ci NOT NULL,
  `name` varchar(35) collate utf8_unicode_ci NOT NULL,
  `password` varchar(32) collate utf8_unicode_ci NOT NULL,
  `passremem` varchar(32) collate utf8_unicode_ci NOT NULL,
  `tel` bigint(12) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci PACK_KEYS=0;

DROP TABLE IF EXISTS `admins`;

CREATE TABLE `admins` (
  `id` smallint(3) unsigned NOT NULL auto_increment,
  `name` varchar(30) collate utf8_unicode_ci NOT NULL,
  `password` char(32) collate utf8_unicode_ci NOT NULL,
  `status` enum('1','2','3','4') collate utf8_unicode_ci NOT NULL default '4',
  `tel` bigint(12) unsigned default NULL,
  `tel2` bigint(12) unsigned default NULL,
  `email` varchar(35) collate utf8_unicode_ci NOT NULL,
  `accessbyip` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  `ip1` varchar(15) collate utf8_unicode_ci NOT NULL,
  `ip2` varchar(15) collate utf8_unicode_ci NOT NULL,
  `ip3` varchar(15) collate utf8_unicode_ci NOT NULL,
  `accessbycookie` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  `cookies_list` varchar(255) collate utf8_unicode_ci NOT NULL,
  `nadaeposl` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  `group_id` tinyint(3) unsigned default NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci PACK_KEYS=0;

INSERT INTO `admins` VALUES 
(1,'Андрій (програміст)','22c3e1312adb1d40b740a126ef619404','1',380509183599,380679183599,'benzapila@gmail.com','0','','','','0','','0',0,'0'),
(2,'Адміністратор Віка','8ac043119a54960852ec178b6a2c75e9','3',666511101,976720248,'','0','','','','0','','0',0,'0'),
(3,'Анастасія','8ac043119a54960852ec178b6a2c75e9','2',380936456101,NULL,'','0','','','','0','','1',2,'0'),
(4,'Оля','213d1d0bed78040a0171ffbdee1a35b1','4',380989718428,380687277307,'','0','','','','0','','1',2,'0'),
(5,'Соломія','1ddcbb1f9bdc7d317e37e0b614a341a1','4',682829460,NULL,'','0','','','','0','','1',2,'0'),
(6,'Наталя','177760786881f69461c8c68a727a10d1','4',986438662,NULL,'','0','','','','0','','1',1,'0'),
(7,'Маша','ad8098edc952e4985ee4e9d9f28f94b5','4',685871794,NULL,'','0','','','','0','','1',1,'0'),
(8,'Галя','9879df9c39711b80aea905ede645da62','4',961846250,NULL,'','0','','','','0','','1',2,'0'),
(9,'Оксана','7ae4c5f3f5d2277b66d8db3b1b305bc6','4',977685853,NULL,'','0','','','','0','','1',4,'0'),
(10,'Віра','b813cadb7243dbe2c6c59fe2ea6b6a43','4',992746060,NULL,'','0','','','','0','','1',4,'0'),
(11,'Оленка','ea2cb6589769c638497ac292439bb804','4',681231652,NULL,'','0','','','','0','','1',0,'0'),
(12,'Таня','1ac397dca72a039956ea448f115d050b','4',982365130,NULL,'','0','','','','0','','1',4,'0');

DROP TABLE IF EXISTS `const`;

CREATE TABLE `const` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(30) collate utf8_unicode_ci NOT NULL,
  `value` varchar(255) collate utf8_unicode_ci NOT NULL,
  `prumitka` varchar(255) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name_2` (`name`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Константи';

INSERT INTO `const` VALUES 
(1,'log','0',''),
(2,'next_cron_job','9999999998','Час наступного виконання завдання'),
(3,'sms_balance','148','кількість грошей на рахунку'),
(4,'send_sms','0','0-в цій конфігурації не відправляються смс, 1-відправляються'),
(5,'name_db','База для розробки','назва бази головна або резерва копія'),
(6,'bkp_copy_to_external_serv','0','1-з цієї бази дані копіються на servage, 0-не копіюються'),
(7,'time_last_backup_copy','2017-08-11 21:21:03','Час останнього копіювання даних на резервну базу'),
(8,'db_status','0','1-головна база, 0-резервна база (на серваже)'),
(9,'pass_cor_rec','861637a425ef06e6d539aaaff113d1d5','пароль який дає можливість редагувати деяким користувачам грошові рухи в базі в md5');

DROP TABLE IF EXISTS `cron`;

CREATE TABLE `cron` (
  `id` smallint(3) NOT NULL auto_increment,
  `name` varchar(40) collate utf8_unicode_ci NOT NULL,
  `date_start` date NOT NULL,
  `date_end` date NOT NULL,
  `d1` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  `d2` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  `d3` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  `d4` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  `d5` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  `d6` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  `d7` enum('0','1') collate utf8_unicode_ci NOT NULL default '1',
  `time_start` mediumint(8) unsigned NOT NULL default '0',
  `periodicity` mediumint(8) unsigned NOT NULL default '0',
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `cron_jobs`;

CREATE TABLE `cron_jobs` (
  `id` smallint(5) NOT NULL auto_increment,
  `cron_id` smallint(3) NOT NULL,
  `time` int(10) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `errors`;

CREATE TABLE `errors` (
  `id` mediumint(5) NOT NULL auto_increment,
  `url` text collate utf8_unicode_ci NOT NULL,
  `mess` text collate utf8_unicode_ci NOT NULL,
  `date` int(10) NOT NULL,
  `GET` text collate utf8_unicode_ci NOT NULL,
  `POST` text collate utf8_unicode_ci NOT NULL,
  `COOKIE` text collate utf8_unicode_ci NOT NULL,
  `SESSION` text collate utf8_unicode_ci NOT NULL,
  `SERVER` text collate utf8_unicode_ci NOT NULL,
  `FILES` text collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `errors` VALUES 
(1,'/backoffice/add_shedule.php?th=9&tm=30&master_id=8&date=2017-10-06','<i>Відбувся запит:</i><br><b>SELECT * from `schedule` WHERE `datetime`&gt;\'2017-10-06 09:30:00\' &amp;&amp; `datetime`&lt;\'2017-10-06 23:59:59\' &amp;&amp; `master_id`=\'8\' ORDER BY `datetime` ASC LIMIT 1</b><br><i>Жодного ряду не вибрано.</i>',1507316804,'<p>th=&gt;9</p><p>tm=&gt;30</p><p>master_id=&gt;8</p><p>date=&gt;2017-10-06</p>','','<p>_ga=&gt;GA1.2.349246973.1498845687</p><p>setting=&gt;21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1</p><p>pc_key=&gt;pgzRrgSYnrRVrEqbVPesYprAzARcWUaV</p><p>admin=&gt;1_22c3e1312adb1d40b740a126ef619404</p>','','HTTP_HOST=&gt;like_.365_.biz.ua<br />HTTP_USER_AGENT=&gt;Mozilla/5.0 (Windows NT 6.1; WOW64; rv:56.0) Gecko/20100101 Firefox/56.0<br />HTTP_ACCEPT=&gt;text/html, */*; q=0.01<br />HTTP_ACCEPT_LANGUAGE=&gt;uk,ru-RU;q=0.8,ru;q=0.6,en-US;q=0.4,en;q=0.2<br />HTTP_ACCEPT_ENCODING=&gt;gzip, deflate<br />HTTP_X_REQUESTED_WITH=&gt;XMLHttpRequest<br />HTTP_REFERER=&gt;http://like_.365_.biz.ua/backoffice/?select=schedule&date_start=06.10.2017&date_end=22.10.2017<br />HTTP_COOKIE=&gt;_ga=GA1.2.349246973.1498845687; setting=21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1; pc_key=pgzRrgSYnrRVrEqbVPesYprAzARcWUaV; admin=1_22c3e1312adb1d40b740a126ef619404<br />HTTP_DNT=&gt;1<br />HTTP_CONNECTION=&gt;keep-alive<br />PATH=&gt;\\usr\\local\\ImageMagick;\\usr\\local\\php5;C:\\ProgramData\\Oracle\\Java\\javapath;C:\\Windows\\system32;C:\\Windows;C:\\Windows\\System32\\Wbem;C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\;C:\\corp2.client\\vega\\bin\\;C:\\Program Files (x86)\\Skype\\Phone\\<br />SystemRoot=&gt;C:\\Windows<br />COMSPEC=&gt;C:\\Windows\\system32\\cmd.exe<br />PATHEXT=&gt;.COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC<br />WINDIR=&gt;C:\\Windows<br />SERVER_SIGNATURE=&gt;<address>Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4 Server at like_.365_.biz.ua Port 80</address>\n<br />SERVER_SOFTWARE=&gt;Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4<br />SERVER_NAME=&gt;like_.365_.biz.ua<br />SERVER_ADDR=&gt;127.0.0.1<br />SERVER_PORT=&gt;80<br />REMOTE_ADDR=&gt;127.0.0.1<br />DOCUMENT_ROOT=&gt;Z:/home/365_.biz.ua/like_<br />SERVER_ADMIN=&gt;admin@localhost<br />SCRIPT_FILENAME=&gt;Z:/home/365_.biz.ua/like_/backoffice/add_shedule.php<br />REMOTE_PORT=&gt;50238<br />GATEWAY_INTERFACE=&gt;CGI/1.1<br />SERVER_PROTOCOL=&gt;HTTP/1.1<br />REQUEST_METHOD=&gt;GET<br />QUERY_STRING=&gt;th=9&tm=30&master_id=8&date=2017-10-06<br />REQUEST_URI=&gt;/backoffice/add_shedule.php?th=9&tm=30&master_id=8&date=2017-10-06<br />SCRIPT_NAME=&gt;/backoffice/add_shedule.php<br />PHP_SELF=&gt;/backoffice/add_shedule.php<br />REQUEST_TIME=&gt;1507316804<br />argv=&gt;Array<br />argc=&gt;1<br />','Array\n(\n)\n'),
(2,'/backoffice/ajax/send_schedule.php','Була відправка смс: Ви записані у Like 06.10 о 09:30. Чекаємо Вас! 0936329533 0672929804',1507316813,'','<p>master_id=&gt;8</p><p>klient_id=&gt;2</p><p>poslyga_id=&gt;34</p><p>datetime=&gt;2017-10-06 09:30:00</p><p>truvalist=&gt;60</p><p>comment=&gt;</p><p>new_kont_pib=&gt;</p><p>new_kont_karta=&gt;</p><p>new_kont_tel=&gt;</p><p>new_kont_tel2=&gt;</p>','<p>_ga=&gt;GA1.2.349246973.1498845687</p><p>setting=&gt;21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1</p><p>pc_key=&gt;pgzRrgSYnrRVrEqbVPesYprAzARcWUaV</p><p>admin=&gt;1_22c3e1312adb1d40b740a126ef619404</p>','','HTTP_HOST=&gt;like_.365_.biz.ua<br />HTTP_USER_AGENT=&gt;Mozilla/5.0 (Windows NT 6.1; WOW64; rv:56.0) Gecko/20100101 Firefox/56.0<br />HTTP_ACCEPT=&gt;text/html, */*; q=0.01<br />HTTP_ACCEPT_LANGUAGE=&gt;uk,ru-RU;q=0.8,ru;q=0.6,en-US;q=0.4,en;q=0.2<br />HTTP_ACCEPT_ENCODING=&gt;gzip, deflate<br />CONTENT_TYPE=&gt;application/x-www-form-urlencoded; charset=UTF-8<br />HTTP_X_REQUESTED_WITH=&gt;XMLHttpRequest<br />HTTP_REFERER=&gt;http://like_.365_.biz.ua/backoffice/?select=schedule&date_start=06.10.2017&date_end=22.10.2017<br />CONTENT_LENGTH=&gt;147<br />HTTP_COOKIE=&gt;_ga=GA1.2.349246973.1498845687; setting=21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1; pc_key=pgzRrgSYnrRVrEqbVPesYprAzARcWUaV; admin=1_22c3e1312adb1d40b740a126ef619404<br />HTTP_DNT=&gt;1<br />HTTP_CONNECTION=&gt;keep-alive<br />PATH=&gt;\\usr\\local\\ImageMagick;\\usr\\local\\php5;C:\\ProgramData\\Oracle\\Java\\javapath;C:\\Windows\\system32;C:\\Windows;C:\\Windows\\System32\\Wbem;C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\;C:\\corp2.client\\vega\\bin\\;C:\\Program Files (x86)\\Skype\\Phone\\<br />SystemRoot=&gt;C:\\Windows<br />COMSPEC=&gt;C:\\Windows\\system32\\cmd.exe<br />PATHEXT=&gt;.COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC<br />WINDIR=&gt;C:\\Windows<br />SERVER_SIGNATURE=&gt;<address>Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4 Server at like_.365_.biz.ua Port 80</address>\n<br />SERVER_SOFTWARE=&gt;Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4<br />SERVER_NAME=&gt;like_.365_.biz.ua<br />SERVER_ADDR=&gt;127.0.0.1<br />SERVER_PORT=&gt;80<br />REMOTE_ADDR=&gt;127.0.0.1<br />DOCUMENT_ROOT=&gt;Z:/home/365_.biz.ua/like_<br />SERVER_ADMIN=&gt;admin@localhost<br />SCRIPT_FILENAME=&gt;Z:/home/365_.biz.ua/like_/backoffice/ajax/send_schedule.php<br />REMOTE_PORT=&gt;50238<br />GATEWAY_INTERFACE=&gt;CGI/1.1<br />SERVER_PROTOCOL=&gt;HTTP/1.1<br />REQUEST_METHOD=&gt;POST<br />QUERY_STRING=&gt;<br />REQUEST_URI=&gt;/backoffice/ajax/send_schedule.php<br />SCRIPT_NAME=&gt;/backoffice/ajax/send_schedule.php<br />PHP_SELF=&gt;/backoffice/ajax/send_schedule.php<br />REQUEST_TIME=&gt;1507316813<br />argv=&gt;Array<br />argc=&gt;0<br />','Array\n(\n)\n'),
(3,'/backoffice/add_shedule.php?th=12&tm=0&master_id=8&date=2017-10-06','<i>Відбувся запит:</i><br><b>SELECT * from `schedule` WHERE `datetime`&gt;\'2017-10-06 12:00:00\' &amp;&amp; `datetime`&lt;\'2017-10-06 23:59:59\' &amp;&amp; `master_id`=\'8\' ORDER BY `datetime` ASC LIMIT 1</b><br><i>Жодного ряду не вибрано.</i>',1507316839,'<p>th=&gt;12</p><p>tm=&gt;0</p><p>master_id=&gt;8</p><p>date=&gt;2017-10-06</p>','','<p>_ga=&gt;GA1.2.349246973.1498845687</p><p>setting=&gt;21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1</p><p>pc_key=&gt;pgzRrgSYnrRVrEqbVPesYprAzARcWUaV</p><p>admin=&gt;1_22c3e1312adb1d40b740a126ef619404</p>','','HTTP_HOST=&gt;like_.365_.biz.ua<br />HTTP_USER_AGENT=&gt;Mozilla/5.0 (Windows NT 6.1; WOW64; rv:56.0) Gecko/20100101 Firefox/56.0<br />HTTP_ACCEPT=&gt;text/html, */*; q=0.01<br />HTTP_ACCEPT_LANGUAGE=&gt;uk,ru-RU;q=0.8,ru;q=0.6,en-US;q=0.4,en;q=0.2<br />HTTP_ACCEPT_ENCODING=&gt;gzip, deflate<br />HTTP_X_REQUESTED_WITH=&gt;XMLHttpRequest<br />HTTP_REFERER=&gt;http://like_.365_.biz.ua/backoffice/?select=schedule&date_start=06.10.2017&date_end=22.10.2017<br />HTTP_COOKIE=&gt;_ga=GA1.2.349246973.1498845687; setting=21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1; pc_key=pgzRrgSYnrRVrEqbVPesYprAzARcWUaV; admin=1_22c3e1312adb1d40b740a126ef619404<br />HTTP_DNT=&gt;1<br />HTTP_CONNECTION=&gt;keep-alive<br />PATH=&gt;\\usr\\local\\ImageMagick;\\usr\\local\\php5;C:\\ProgramData\\Oracle\\Java\\javapath;C:\\Windows\\system32;C:\\Windows;C:\\Windows\\System32\\Wbem;C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\;C:\\corp2.client\\vega\\bin\\;C:\\Program Files (x86)\\Skype\\Phone\\<br />SystemRoot=&gt;C:\\Windows<br />COMSPEC=&gt;C:\\Windows\\system32\\cmd.exe<br />PATHEXT=&gt;.COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC<br />WINDIR=&gt;C:\\Windows<br />SERVER_SIGNATURE=&gt;<address>Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4 Server at like_.365_.biz.ua Port 80</address>\n<br />SERVER_SOFTWARE=&gt;Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4<br />SERVER_NAME=&gt;like_.365_.biz.ua<br />SERVER_ADDR=&gt;127.0.0.1<br />SERVER_PORT=&gt;80<br />REMOTE_ADDR=&gt;127.0.0.1<br />DOCUMENT_ROOT=&gt;Z:/home/365_.biz.ua/like_<br />SERVER_ADMIN=&gt;admin@localhost<br />SCRIPT_FILENAME=&gt;Z:/home/365_.biz.ua/like_/backoffice/add_shedule.php<br />REMOTE_PORT=&gt;50238<br />GATEWAY_INTERFACE=&gt;CGI/1.1<br />SERVER_PROTOCOL=&gt;HTTP/1.1<br />REQUEST_METHOD=&gt;GET<br />QUERY_STRING=&gt;th=12&tm=0&master_id=8&date=2017-10-06<br />REQUEST_URI=&gt;/backoffice/add_shedule.php?th=12&tm=0&master_id=8&date=2017-10-06<br />SCRIPT_NAME=&gt;/backoffice/add_shedule.php<br />PHP_SELF=&gt;/backoffice/add_shedule.php<br />REQUEST_TIME=&gt;1507316839<br />argv=&gt;Array<br />argc=&gt;1<br />','Array\n(\n)\n'),
(4,'/backoffice/add_shedule.php?th=11&tm=45&master_id=5&date=2017-10-08','<i>Відбувся запит:</i><br><b>SELECT * from `schedule` WHERE `datetime`&gt;\'2017-10-08 11:45:00\' &amp;&amp; `datetime`&lt;\'2017-10-08 23:59:59\' &amp;&amp; `master_id`=\'5\' ORDER BY `datetime` ASC LIMIT 1</b><br><i>Жодного ряду не вибрано.</i>',1507316899,'<p>th=&gt;11</p><p>tm=&gt;45</p><p>master_id=&gt;5</p><p>date=&gt;2017-10-08</p>','','<p>_ga=&gt;GA1.2.349246973.1498845687</p><p>setting=&gt;21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1</p><p>pc_key=&gt;pgzRrgSYnrRVrEqbVPesYprAzARcWUaV</p><p>admin=&gt;1_22c3e1312adb1d40b740a126ef619404</p>','','HTTP_HOST=&gt;like_.365_.biz.ua<br />HTTP_USER_AGENT=&gt;Mozilla/5.0 (Windows NT 6.1; WOW64; rv:56.0) Gecko/20100101 Firefox/56.0<br />HTTP_ACCEPT=&gt;text/html, */*; q=0.01<br />HTTP_ACCEPT_LANGUAGE=&gt;uk,ru-RU;q=0.8,ru;q=0.6,en-US;q=0.4,en;q=0.2<br />HTTP_ACCEPT_ENCODING=&gt;gzip, deflate<br />HTTP_X_REQUESTED_WITH=&gt;XMLHttpRequest<br />HTTP_REFERER=&gt;http://like_.365_.biz.ua/backoffice/?select=schedule&date_start=06.10.2017&date_end=22.10.2017<br />HTTP_COOKIE=&gt;_ga=GA1.2.349246973.1498845687; setting=21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1; pc_key=pgzRrgSYnrRVrEqbVPesYprAzARcWUaV; admin=1_22c3e1312adb1d40b740a126ef619404<br />HTTP_DNT=&gt;1<br />HTTP_CONNECTION=&gt;keep-alive<br />PATH=&gt;\\usr\\local\\ImageMagick;\\usr\\local\\php5;C:\\ProgramData\\Oracle\\Java\\javapath;C:\\Windows\\system32;C:\\Windows;C:\\Windows\\System32\\Wbem;C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\;C:\\corp2.client\\vega\\bin\\;C:\\Program Files (x86)\\Skype\\Phone\\<br />SystemRoot=&gt;C:\\Windows<br />COMSPEC=&gt;C:\\Windows\\system32\\cmd.exe<br />PATHEXT=&gt;.COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC<br />WINDIR=&gt;C:\\Windows<br />SERVER_SIGNATURE=&gt;<address>Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4 Server at like_.365_.biz.ua Port 80</address>\n<br />SERVER_SOFTWARE=&gt;Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4<br />SERVER_NAME=&gt;like_.365_.biz.ua<br />SERVER_ADDR=&gt;127.0.0.1<br />SERVER_PORT=&gt;80<br />REMOTE_ADDR=&gt;127.0.0.1<br />DOCUMENT_ROOT=&gt;Z:/home/365_.biz.ua/like_<br />SERVER_ADMIN=&gt;admin@localhost<br />SCRIPT_FILENAME=&gt;Z:/home/365_.biz.ua/like_/backoffice/add_shedule.php<br />REMOTE_PORT=&gt;50431<br />GATEWAY_INTERFACE=&gt;CGI/1.1<br />SERVER_PROTOCOL=&gt;HTTP/1.1<br />REQUEST_METHOD=&gt;GET<br />QUERY_STRING=&gt;th=11&tm=45&master_id=5&date=2017-10-08<br />REQUEST_URI=&gt;/backoffice/add_shedule.php?th=11&tm=45&master_id=5&date=2017-10-08<br />SCRIPT_NAME=&gt;/backoffice/add_shedule.php<br />PHP_SELF=&gt;/backoffice/add_shedule.php<br />REQUEST_TIME=&gt;1507316899<br />argv=&gt;Array<br />argc=&gt;1<br />','Array\n(\n)\n'),
(5,'/backoffice/ajax/send_schedule.php','Була відправка смс: Ви записані у Like 08.10 о 11:45. Чекаємо Вас! 0936329533 0672929804',1507316921,'','<p>master_id=&gt;5</p><p>klient_id=&gt;2</p><p>poslyga_id=&gt;6</p><p>datetime=&gt;2017-10-08 11:45:00</p><p>truvalist=&gt;75</p><p>comment=&gt;</p><p>new_kont_pib=&gt;</p><p>new_kont_karta=&gt;</p><p>new_kont_tel=&gt;</p><p>new_kont_tel2=&gt;</p>','<p>_ga=&gt;GA1.2.349246973.1498845687</p><p>setting=&gt;21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1</p><p>pc_key=&gt;pgzRrgSYnrRVrEqbVPesYprAzARcWUaV</p><p>admin=&gt;1_22c3e1312adb1d40b740a126ef619404</p>','','HTTP_HOST=&gt;like_.365_.biz.ua<br />HTTP_USER_AGENT=&gt;Mozilla/5.0 (Windows NT 6.1; WOW64; rv:56.0) Gecko/20100101 Firefox/56.0<br />HTTP_ACCEPT=&gt;text/html, */*; q=0.01<br />HTTP_ACCEPT_LANGUAGE=&gt;uk,ru-RU;q=0.8,ru;q=0.6,en-US;q=0.4,en;q=0.2<br />HTTP_ACCEPT_ENCODING=&gt;gzip, deflate<br />CONTENT_TYPE=&gt;application/x-www-form-urlencoded; charset=UTF-8<br />HTTP_X_REQUESTED_WITH=&gt;XMLHttpRequest<br />HTTP_REFERER=&gt;http://like_.365_.biz.ua/backoffice/?select=schedule&date_start=06.10.2017&date_end=22.10.2017<br />CONTENT_LENGTH=&gt;146<br />HTTP_COOKIE=&gt;_ga=GA1.2.349246973.1498845687; setting=21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1; pc_key=pgzRrgSYnrRVrEqbVPesYprAzARcWUaV; admin=1_22c3e1312adb1d40b740a126ef619404<br />HTTP_DNT=&gt;1<br />HTTP_CONNECTION=&gt;keep-alive<br />PATH=&gt;\\usr\\local\\ImageMagick;\\usr\\local\\php5;C:\\ProgramData\\Oracle\\Java\\javapath;C:\\Windows\\system32;C:\\Windows;C:\\Windows\\System32\\Wbem;C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\;C:\\corp2.client\\vega\\bin\\;C:\\Program Files (x86)\\Skype\\Phone\\<br />SystemRoot=&gt;C:\\Windows<br />COMSPEC=&gt;C:\\Windows\\system32\\cmd.exe<br />PATHEXT=&gt;.COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC<br />WINDIR=&gt;C:\\Windows<br />SERVER_SIGNATURE=&gt;<address>Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4 Server at like_.365_.biz.ua Port 80</address>\n<br />SERVER_SOFTWARE=&gt;Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4<br />SERVER_NAME=&gt;like_.365_.biz.ua<br />SERVER_ADDR=&gt;127.0.0.1<br />SERVER_PORT=&gt;80<br />REMOTE_ADDR=&gt;127.0.0.1<br />DOCUMENT_ROOT=&gt;Z:/home/365_.biz.ua/like_<br />SERVER_ADMIN=&gt;admin@localhost<br />SCRIPT_FILENAME=&gt;Z:/home/365_.biz.ua/like_/backoffice/ajax/send_schedule.php<br />REMOTE_PORT=&gt;50431<br />GATEWAY_INTERFACE=&gt;CGI/1.1<br />SERVER_PROTOCOL=&gt;HTTP/1.1<br />REQUEST_METHOD=&gt;POST<br />QUERY_STRING=&gt;<br />REQUEST_URI=&gt;/backoffice/ajax/send_schedule.php<br />SCRIPT_NAME=&gt;/backoffice/ajax/send_schedule.php<br />PHP_SELF=&gt;/backoffice/ajax/send_schedule.php<br />REQUEST_TIME=&gt;1507316921<br />argv=&gt;Array<br />argc=&gt;0<br />','Array\n(\n)\n'),
(6,'/backoffice/?select=edit_admin&id=11','НАМАГАННЯ ПОРУШИТИ ПРАВА ДОСТУПУ адміна з id=11, адміном з id=12',1513167336,'<p>select=&gt;edit_admin</p><p>id=&gt;11</p>','','<p>_ga=&gt;GA1.2.349246973.1498845687</p><p>setting=&gt;21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1</p><p>pc_key=&gt;pgzRrgSYnrRVrEqbVPesYprAzARcWUaV</p><p>admin=&gt;12_1ac397dca72a039956ea448f115d050b</p>','','HTTP_HOST=&gt;like_.365_.biz.ua<br />HTTP_USER_AGENT=&gt;Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:57.0) Gecko/20100101 Firefox/57.0<br />HTTP_ACCEPT=&gt;text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8<br />HTTP_ACCEPT_LANGUAGE=&gt;uk,ru-RU;q=0.8,ru;q=0.6,en-US;q=0.4,en;q=0.2<br />HTTP_ACCEPT_ENCODING=&gt;gzip, deflate<br />HTTP_COOKIE=&gt;_ga=GA1.2.349246973.1498845687; setting=21_uk_isMSqf_1500740041_30_1_0_0_0_0_0_0_1_06.10.2017_22.10.2017_1; pc_key=pgzRrgSYnrRVrEqbVPesYprAzARcWUaV; admin=12_1ac397dca72a039956ea448f115d050b<br />HTTP_DNT=&gt;1<br />HTTP_CONNECTION=&gt;keep-alive<br />HTTP_UPGRADE_INSECURE_REQUESTS=&gt;1<br />PATH=&gt;\\usr\\local\\ImageMagick;\\usr\\local\\php5;C:\\ProgramData\\Oracle\\Java\\javapath;C:\\Windows\\system32;C:\\Windows;C:\\Windows\\System32\\Wbem;C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\;C:\\corp2.client\\vega\\bin\\;C:\\Program Files (x86)\\Skype\\Phone\\<br />SystemRoot=&gt;C:\\Windows<br />COMSPEC=&gt;C:\\Windows\\system32\\cmd.exe<br />PATHEXT=&gt;.COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC<br />WINDIR=&gt;C:\\Windows<br />SERVER_SIGNATURE=&gt;<address>Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4 Server at like_.365_.biz.ua Port 80</address>\n<br />SERVER_SOFTWARE=&gt;Apache/2.2.4 (Win32) mod_ssl/2.2.4 OpenSSL/0.9.8d PHP/5.2.4<br />SERVER_NAME=&gt;like_.365_.biz.ua<br />SERVER_ADDR=&gt;127.0.0.1<br />SERVER_PORT=&gt;80<br />REMOTE_ADDR=&gt;127.0.0.1<br />DOCUMENT_ROOT=&gt;Z:/home/365_.biz.ua/like_<br />SERVER_ADMIN=&gt;admin@localhost<br />SCRIPT_FILENAME=&gt;Z:/home/365_.biz.ua/like_/backoffice/index.php<br />REMOTE_PORT=&gt;52844<br />GATEWAY_INTERFACE=&gt;CGI/1.1<br />SERVER_PROTOCOL=&gt;HTTP/1.1<br />REQUEST_METHOD=&gt;GET<br />QUERY_STRING=&gt;select=edit_admin&id=11<br />REQUEST_URI=&gt;/backoffice/?select=edit_admin&id=11<br />SCRIPT_NAME=&gt;/backoffice/index.php<br />PHP_SELF=&gt;/backoffice/index.php<br />REQUEST_TIME=&gt;1513167335<br />argv=&gt;Array<br />argc=&gt;1<br />','Array\n(\n)\n');

DROP TABLE IF EXISTS `groups`;

CREATE TABLE `groups` (
  `id` smallint(3) unsigned NOT NULL auto_increment,
  `name_uk` varchar(15) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(15) collate utf8_unicode_ci NOT NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Назви груп в якій обєднують майстрів';

INSERT INTO `groups` VALUES 
(1,'Перукарі','','0'),
(2,'Манікюристи','','0'),
(3,'','','0'),
(4,'Макіяж','','0');

DROP TABLE IF EXISTS `informer`;

CREATE TABLE `informer` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `text_uk` varchar(255) collate utf8_unicode_ci NOT NULL,
  `text_ru` varchar(255) collate utf8_unicode_ci NOT NULL,
  `text_en` varchar(255) collate utf8_unicode_ci NOT NULL,
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Інформаційні повідомлення';

DROP TABLE IF EXISTS `kontragentu`;

CREATE TABLE `kontragentu` (
  `id` smallint(5) NOT NULL auto_increment,
  `karta` smallint(4) unsigned zerofill default NULL,
  `pib` varchar(40) collate utf8_unicode_ci default NULL,
  `birthday` date default NULL,
  `date_start` date default NULL,
  `tel` bigint(12) unsigned default NULL,
  `tel2` bigint(12) unsigned default NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `karta` (`karta`),
  UNIQUE KEY `tel` (`tel`)
) ENGINE=MyISAM AUTO_INCREMENT=526 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Таблиця Клієнтів';

INSERT INTO `kontragentu` VALUES 
(1,0999,'Кулій Ірина Василівна','1994-05-24',NULL,NULL,NULL,'0'),
(2,0995,'Задиляк Світлана','1980-05-29',NULL,380955644016,NULL,'0'),
(3,0993,'Залевська Альона Василіна','1995-01-22',NULL,NULL,NULL,'0'),
(4,0991,'Макогін Н.А.','1996-12-17',NULL,NULL,NULL,'0'),
(5,0989,'Федоришин Лілія Л.','1980-04-08',NULL,NULL,NULL,'0'),
(6,0987,'Москаль Марія В.','1976-07-13',NULL,NULL,NULL,'0'),
(7,0985,'Мельничук Оксана Л.','1985-04-11',NULL,NULL,NULL,'0'),
(8,0983,'Ізвєкова Оксана В.','1989-06-21',NULL,NULL,NULL,'0'),
(9,0981,'Сенів Ольга ','1994-07-19',NULL,NULL,NULL,'0'),
(10,0979,'Бубель Марія ','1997-06-17',NULL,NULL,NULL,'0'),
(11,0977,'Стухляк Наталя Й.','1993-10-11',NULL,NULL,NULL,'0'),
(12,0975,'Хандашко Оксана Я.','1990-11-19',NULL,NULL,NULL,'0'),
(13,0971,'Бойчук Анастасія Р.','0000-00-00',NULL,NULL,NULL,'0'),
(14,0969,'Гриців Степанія Т.','1963-09-20',NULL,NULL,NULL,'0'),
(15,0967,'Чорнявська Олена В. ','1999-01-31',NULL,380508726544,NULL,'0'),
(16,0965,'Дергачова Зоряна В.','1977-03-05',NULL,NULL,NULL,'0'),
(17,0961,'Цитульська Анастасія ','1996-12-04',NULL,NULL,NULL,'0'),
(18,0959,'Павшок Оксана О.','1994-10-23',NULL,NULL,NULL,'0'),
(19,0955,'Томчук Таня ','0000-00-00',NULL,NULL,NULL,'0'),
(20,0951,'Лотоцька Марія ','1985-03-23',NULL,NULL,NULL,'0'),
(21,0949,'Каспрій Анастасія ','1995-12-20',NULL,NULL,NULL,'0'),
(22,0941,'Іванова Ірина','1996-07-27',NULL,NULL,NULL,'0'),
(23,0940,'Геравс Галина ','1992-07-15',NULL,NULL,NULL,'0'),
(24,0930,'Лучко Вікторія ','1989-10-06',NULL,NULL,NULL,'0'),
(25,0920,'Бойчук Оксана',NULL,NULL,380983379736,NULL,'0'),
(26,0910,'Петричка  Галина ','1985-05-04',NULL,380672569402,NULL,'0'),
(27,0900,'Тришак Галина ','1992-09-01',NULL,NULL,NULL,'0'),
(28,0887,'Кулій Іванна','1976-05-09',NULL,NULL,NULL,'0'),
(29,0883,'Цикрик Марія','1994-10-19',NULL,NULL,NULL,'0'),
(30,0881,'Українець Н.','1992-04-27',NULL,NULL,NULL,'0'),
(31,0879,'Кравець Оксана ','0000-00-00',NULL,NULL,NULL,'0'),
(32,0877,'Колівошко Ольга','1979-04-21',NULL,NULL,NULL,'0'),
(33,0873,'Улична Юлія ','1991-10-24',NULL,NULL,NULL,'0'),
(34,0871,'Завгородня Наталія','1969-04-22',NULL,NULL,NULL,'0'),
(35,0869,'Петрас Уляна','1983-07-29',NULL,NULL,NULL,'0'),
(36,0867,'Харук Олександра','1978-08-13',NULL,NULL,NULL,'0'),
(37,0863,'Боднар Юлія ','1993-11-14',NULL,NULL,NULL,'0'),
(38,0861,'Копій Тетяна ','1989-01-31',NULL,NULL,NULL,'0'),
(39,0859,'Гевко Оксана ','1987-03-22',NULL,NULL,NULL,'0'),
(40,0857,'Чубата Леся ','0000-00-00',NULL,NULL,NULL,'0'),
(41,0853,'Романів Оксана','1977-11-30',NULL,NULL,NULL,'0'),
(42,0851,'Слободян Галина ','1974-11-09',NULL,NULL,NULL,'0'),
(43,0849,'Боднар Анастасія',NULL,NULL,380680927170,NULL,'0'),
(44,0847,'Дубчак М.','1997-09-20',NULL,NULL,NULL,'0'),
(45,0843,'Жравська Юлія','1987-11-05',NULL,NULL,NULL,'0'),
(46,0841,'Гой Юлія ','1992-06-10',NULL,NULL,NULL,'0'),
(47,0839,'Лукасевич Вікторія','1986-11-23',NULL,NULL,NULL,'0'),
(48,0837,'Буяр Світлана ','1982-09-26',NULL,NULL,NULL,'0'),
(49,0947,'Худзік Юлія ','2000-01-22',NULL,NULL,NULL,'0'),
(50,0835,'Купіль Вікторія','1997-01-23',NULL,NULL,NULL,'0'),
(51,0831,'Коземчук Марія','1994-09-10',NULL,NULL,NULL,'0'),
(52,0829,'Коробій Вікторія ','1995-10-09',NULL,NULL,NULL,'0'),
(53,0827,'Лазецька Юлія ','1995-02-15',NULL,NULL,NULL,'0'),
(54,0825,'Повшок Світлана','1991-05-08',NULL,NULL,NULL,'0'),
(55,0823,'Ягода Лідія ','1981-07-17',NULL,NULL,NULL,'0'),
(56,0821,'Огороднік Ірина ','1989-03-22',NULL,NULL,NULL,'0'),
(57,0819,'Гоменюк Андріна','1995-12-12',NULL,NULL,NULL,'0'),
(58,0817,'Біленко Маряна','1972-12-12',NULL,NULL,NULL,'0'),
(59,0815,'Романчук Вікторія','2000-04-08',NULL,NULL,NULL,'0'),
(60,0811,'Чапурда Наталія ','1987-05-17',NULL,NULL,NULL,'0'),
(61,0809,'Козіцька Марія ','1995-10-15',NULL,NULL,NULL,'0'),
(62,0807,'Коцур Світлана','1963-06-09',NULL,NULL,NULL,'0'),
(63,0805,'Буслер Надія','1964-10-18',NULL,380936266748,NULL,'0'),
(64,0803,'Дідюк Ірина ','1988-03-26',NULL,NULL,NULL,'0'),
(65,0801,'Ткачик Ольга','1975-07-05',NULL,NULL,NULL,'0'),
(66,0799,'Журба Тетяна','1982-01-03',NULL,NULL,NULL,'0'),
(67,0797,'Бойко Уляна ','1994-05-28',NULL,NULL,NULL,'0'),
(68,0795,'Потикевич Вікторія ','1997-10-24',NULL,NULL,NULL,'0'),
(69,0793,'Шикульська Світлана','1981-03-17',NULL,NULL,NULL,'0'),
(70,0789,'Новак  Наталя','1988-09-11',NULL,NULL,NULL,'0'),
(71,0787,'Антонюк Вікторія','1999-02-23',NULL,NULL,NULL,'0'),
(72,0785,'Харук Ліля','1998-06-11',NULL,NULL,NULL,'0'),
(73,0783,'Довгань Надія','1983-11-27',NULL,NULL,NULL,'0'),
(74,0781,'Куриляк Зоряна','1987-06-12',NULL,NULL,NULL,'0'),
(75,0779,'Винник Наталія ','1986-05-08',NULL,NULL,NULL,'0'),
(76,0777,'Сас Надія ','1977-07-05',NULL,NULL,NULL,'0'),
(77,0775,'Даньо Марія ','1995-08-25',NULL,NULL,NULL,'0'),
(78,0771,'Дубрівна Ярослава','1997-02-08',NULL,NULL,NULL,'0'),
(79,0769,'Задорожна Таня','1994-09-14',NULL,380982365130,NULL,'0'),
(80,0767,'Кравчук Ольга','1988-12-01',NULL,NULL,NULL,'0'),
(81,0765,'Гоменюк Ірина','1977-04-12',NULL,NULL,NULL,'0'),
(82,0763,'Луців Наталія','1991-10-11',NULL,NULL,NULL,'0'),
(83,0761,'Бегман Вероніка','1995-10-23',NULL,NULL,NULL,'0'),
(84,0759,'Калакайло А.','1998-04-04',NULL,NULL,NULL,'0'),
(85,0757,'Погорецька Ірина','1996-04-13',NULL,NULL,NULL,'0'),
(86,0755,'Пундій Ганна','1992-12-13',NULL,NULL,NULL,'0'),
(87,0751,'Дроболюк Ольга','1958-10-16',NULL,NULL,NULL,'0'),
(88,0750,'Голіната Ганна','1967-10-24',NULL,NULL,NULL,'0'),
(89,0748,'Ізввикова Ірина','1989-08-16',NULL,NULL,NULL,'0'),
(90,0740,'Сеник Олена','1981-12-31',NULL,NULL,NULL,'0'),
(91,0738,'Гамбаль Тетяна ','1983-08-02',NULL,NULL,NULL,'0'),
(92,0736,'Махмутова Лілія','1982-10-07',NULL,NULL,NULL,'0'),
(93,0732,'загайкевич Катерина','0000-00-00',NULL,NULL,NULL,'0'),
(94,0730,'Ганкевич Світлана','1965-02-05',NULL,NULL,NULL,'0'),
(95,0728,'Брезіна Тетяна','1995-03-06',NULL,NULL,NULL,'0'),
(96,0726,'Козак Людмила','1984-03-14',NULL,NULL,NULL,'0'),
(97,0722,'Цаплан Любов','1994-03-08',NULL,NULL,NULL,'0'),
(98,0720,'Парасимчук Світлана','1996-10-06',NULL,NULL,NULL,'0'),
(99,0718,'Лесюк Василина','1998-01-14',NULL,NULL,NULL,'0'),
(100,0716,'Скорогабач Наталя','1991-06-02',NULL,NULL,NULL,'0'),
(101,0712,'Скобальська Христина','1996-07-12',NULL,NULL,NULL,'0'),
(102,0710,'Мельник В.','1997-02-25',NULL,NULL,NULL,'0'),
(103,0708,'Стадник Таїсія','1998-10-31',NULL,NULL,NULL,'0'),
(104,0706,'Самсон Лєна','1981-06-21',NULL,NULL,NULL,'0'),
(105,0702,'Москалик Ольга','1980-05-31',NULL,NULL,NULL,'0'),
(106,0700,'Федорчук Ольга ','0000-00-00',NULL,380962447038,NULL,'0'),
(107,0698,'Ліпунова Тетяна','1988-08-12',NULL,380678762678,NULL,'0'),
(108,0696,'Козак Ірина','2002-04-26',NULL,NULL,NULL,'0'),
(109,0692,'Матвієвич Юлія','1990-06-20',NULL,NULL,NULL,'0'),
(110,0690,'Боднарчук Ярослав','1984-07-29',NULL,NULL,NULL,'0'),
(111,0688,'Семанчук Вікторія','1996-02-07',NULL,NULL,NULL,'0'),
(112,0686,'Жовковська  Тетяна','1968-08-09',NULL,NULL,NULL,'0'),
(113,0684,'Самсон Юлія ','1993-09-18',NULL,NULL,NULL,'0'),
(114,0682,'Туркіць Ольга','1982-07-30',NULL,NULL,NULL,'0'),
(115,0680,'Старик Ірина','0000-00-00',NULL,NULL,NULL,'0'),
(116,0678,'Григорєва Андріана ','1993-06-02',NULL,NULL,NULL,'0'),
(117,0676,'Війтюк Софія','1999-07-25',NULL,NULL,NULL,'0'),
(118,0672,'Сушельницька Людмила','1980-09-20',NULL,NULL,NULL,'0'),
(119,0670,'Ткач Христина','1992-10-30',NULL,NULL,NULL,'0'),
(120,0668,'Перців Ганна','1989-11-24',NULL,NULL,NULL,'0'),
(121,0666,'Білецька Леся ','1999-01-15',NULL,NULL,NULL,'0'),
(122,0644,'Шарган Ірина','1987-10-03',NULL,NULL,NULL,'0'),
(123,0662,'Архіпова Наталя','1964-09-16',NULL,NULL,NULL,'0'),
(124,0660,'Софія Чвіль','1998-01-04',NULL,NULL,NULL,'0'),
(125,0658,'Половчук Наталя','1969-03-14',NULL,NULL,NULL,'0'),
(126,0656,'Казьмір Наталія','1979-05-13',NULL,NULL,NULL,'0'),
(127,0654,'Хамчук Ольга','1897-08-21',NULL,NULL,NULL,'0'),
(128,0652,'Габура Зоряна','1998-11-25',NULL,NULL,NULL,'0'),
(129,0650,'Подолянська М.','1996-05-01',NULL,NULL,NULL,'0'),
(130,0648,'Дідик Ліля','1988-06-27',NULL,NULL,NULL,'0'),
(131,0646,'Возьна Вікторія','1992-08-18',NULL,NULL,NULL,'0'),
(132,0642,'Данилишин Галина',NULL,NULL,380979728611,NULL,'0'),
(133,0640,'Ткачук Ірина','0000-00-00',NULL,380973402850,NULL,'0'),
(134,0638,'Білевич Тетяна','1973-11-13',NULL,NULL,NULL,'0'),
(135,0630,'Мурашка Ірина','1991-01-01',NULL,NULL,NULL,'0'),
(136,0628,'Ковбаснюк Анастасія','1988-09-20',NULL,NULL,NULL,'0'),
(137,0620,'Петрів Ірина','1991-01-10',NULL,NULL,NULL,'0'),
(138,0618,'Музика Олена','1994-12-02',NULL,NULL,NULL,'0'),
(139,0610,'Захарчук Світлана','1975-05-22',NULL,NULL,NULL,'0'),
(140,0608,'Найдух Христина','1998-02-10',NULL,NULL,NULL,'0'),
(141,0600,'Вороняк Наталія','1996-03-23',NULL,NULL,NULL,'0'),
(142,0598,'Іванищук Ю.','1994-03-08',NULL,NULL,NULL,'0'),
(143,0590,'Бажовська Соломія',NULL,NULL,380686484399,NULL,'0'),
(144,0588,'Штиник Галина','1986-07-13',NULL,NULL,NULL,'0'),
(145,0580,'Панчук Ірина','1993-06-11',NULL,NULL,NULL,'0'),
(146,0578,'Полівчук Оксана','1995-07-10',NULL,NULL,NULL,'0'),
(147,0570,'Данилишин Н.','1988-03-11',NULL,NULL,NULL,'0'),
(148,0568,'Дячик Надія','1967-04-12',NULL,380969686571,NULL,'0'),
(149,0560,'Николяк Тетяна ','1978-09-14',NULL,NULL,NULL,'0'),
(150,0558,'Колівошко Наталя','1983-04-29',NULL,NULL,NULL,'0'),
(151,0550,'Петрик Галина','1965-06-23',NULL,380678023451,NULL,'0'),
(152,0548,'Сліпцова Зоряна','1999-04-29',NULL,NULL,NULL,'0'),
(153,0540,'Білевич Наталя','1944-02-20',NULL,NULL,NULL,'0'),
(154,0538,'Балінська Любов','1991-11-14',NULL,NULL,NULL,'0'),
(155,0530,'Кошута Тетяна','1991-10-23',NULL,NULL,NULL,'0'),
(156,0528,'Качаровська Яна ','1996-01-15',NULL,NULL,NULL,'0'),
(157,0520,'Липа Марія','1967-02-20',NULL,NULL,NULL,'0'),
(158,0518,'Ванай Зоряна','1990-05-20',NULL,NULL,NULL,'0'),
(159,0510,'Нагаєвська Наталія','1992-10-17',NULL,NULL,NULL,'0'),
(160,0508,'Шимків Наталія','1997-12-25',NULL,380936802828,NULL,'0'),
(161,0496,'Гураль Марія','0000-00-00',NULL,NULL,NULL,'0'),
(162,0486,'Олійник Інна','1993-05-18',NULL,NULL,NULL,'0'),
(163,0476,'Хмелик Аліна',NULL,NULL,380979014508,NULL,'0'),
(164,0466,'Якимець Христина','1991-12-31',NULL,NULL,NULL,'0'),
(165,0456,'Когут Юлія','1997-05-04',NULL,NULL,NULL,'0'),
(166,0446,'Кульчицька Т.','1978-09-02',NULL,NULL,NULL,'0'),
(167,0436,'Ушій Віта','1991-08-02',NULL,NULL,NULL,'0'),
(168,0426,'Махневич Зоряна','1992-10-31',NULL,NULL,NULL,'0'),
(169,0416,'Чубак Діана','1997-12-12',NULL,NULL,NULL,'0'),
(170,0406,'Дідюк Анжеліна','2016-04-22',NULL,NULL,NULL,'0'),
(171,0396,'Янч Соломія','1995-11-08',NULL,NULL,NULL,'0'),
(172,0386,'Куриляк Христина','1992-06-13',NULL,NULL,NULL,'0'),
(173,0376,'Дерій Олена','1997-01-12',NULL,NULL,NULL,'0'),
(174,0366,'Рудніцька Юлія ','1996-08-05',NULL,NULL,NULL,'0'),
(175,0356,'Юркевич Галина','1969-02-22',NULL,NULL,NULL,'0'),
(176,0350,'Горбаль Марія','1985-09-20',NULL,NULL,NULL,'0'),
(177,0348,'Наконечна Оксана ','1986-01-29',NULL,NULL,NULL,'0'),
(178,0346,'Манорик Галина','1982-09-08',NULL,NULL,NULL,'0'),
(179,0344,'Безпалько Олена','1993-09-17',NULL,NULL,NULL,'0'),
(180,0342,'Черник Галина','1999-04-09',NULL,NULL,NULL,'0'),
(181,0997,'Ліщинська Галина','1974-08-13',NULL,NULL,NULL,'0'),
(182,0340,'Чорній Маряна','1991-01-16',NULL,NULL,NULL,'0'),
(183,0338,'Задорожна Оля','1968-02-16',NULL,NULL,NULL,'0'),
(184,0336,'Старовойт Юля','1997-02-28',NULL,NULL,NULL,'0'),
(185,0334,'Похила Марія','1990-09-09',NULL,NULL,NULL,'0'),
(186,0332,'Маціборко З.','1985-05-24',NULL,NULL,NULL,'0'),
(187,0330,'Огороднік Людмила','1960-02-23',NULL,380506240817,NULL,'0'),
(188,0328,'Яськів Наталія','1981-05-07',NULL,NULL,NULL,'0'),
(189,0326,'Гайова Василина','1995-01-14',NULL,NULL,NULL,'0'),
(190,0324,'Гевко Наталія ','1991-12-10',NULL,NULL,NULL,'0'),
(191,0322,'Прейзнер Світлана ','1980-05-27',NULL,NULL,NULL,'0'),
(192,0320,'Галінаускас Ірина ','1995-01-14',NULL,NULL,NULL,'0'),
(193,0318,'Свергун Маряна','1992-02-16',NULL,NULL,NULL,'0'),
(194,0316,'Басараба Юлія','1999-05-20',NULL,NULL,NULL,'0'),
(195,0314,'Лівінська Наталя','1990-09-09',NULL,NULL,NULL,'0'),
(196,0312,'Задорожна Юлія','1990-04-05',NULL,380980903531,NULL,'0'),
(197,0310,'Дерій Наталія','0000-00-00',NULL,NULL,NULL,'0'),
(198,0308,'Смаглій Оксана','1974-12-07',NULL,380984328251,NULL,'0'),
(199,0306,'Мельник Аліна ','1987-11-27',NULL,NULL,NULL,'0'),
(200,0304,'Тиндик Світлана','0989-04-14',NULL,NULL,NULL,'0'),
(201,0302,'Тронт Марія','1999-10-13',NULL,NULL,NULL,'0'),
(202,0300,'Марущак Христина','1994-08-21',NULL,NULL,NULL,'0'),
(203,0298,'Єрастова Юлія','1995-02-22',NULL,NULL,NULL,'0'),
(204,0296,'Боднар Наталя',NULL,NULL,380673402735,NULL,'0'),
(205,0292,'Горичак Наталія','1989-11-09',NULL,NULL,NULL,'0'),
(206,0290,'Кулій Надія','1971-07-27',NULL,NULL,NULL,'0'),
(207,0288,'Стадніченко Маряна','1992-09-05',NULL,NULL,NULL,'0'),
(208,0286,'Борисюк Ірина','1997-11-10',NULL,NULL,NULL,'0'),
(209,0282,'Харченко Наталя','1996-09-14',NULL,NULL,NULL,'0'),
(210,0280,'Бабюк Тетяна','1944-12-30',NULL,NULL,NULL,'0'),
(211,0278,'Курчак Яна','1991-03-18',NULL,NULL,NULL,'0'),
(212,0276,'Петрило Наталя','1977-12-17',NULL,NULL,NULL,'0'),
(213,0272,'Федорчук Настя','1996-10-28',NULL,NULL,NULL,'0'),
(214,0270,'Полева Надія','1993-04-14',NULL,NULL,NULL,'0'),
(215,0268,'Марчин Яна','1996-07-07',NULL,NULL,NULL,'0'),
(216,0266,'Буріняк Маргарита','2002-05-23',NULL,NULL,NULL,'0'),
(217,0262,'Сулима Світлана','1982-10-14',NULL,NULL,NULL,'0'),
(218,0260,'Когут Тетяна','1996-09-25',NULL,NULL,NULL,'0'),
(219,0258,'Шевчик Роксолана ','1997-04-24',NULL,NULL,NULL,'0'),
(220,0256,'Ландяк Ірина','1992-04-29',NULL,NULL,NULL,'0'),
(221,0254,'Горох Євгенія','1994-05-16',NULL,NULL,NULL,'0'),
(222,0252,'Стельмащук Галина','1967-08-13',NULL,NULL,NULL,'0'),
(223,0046,'Ковальчук Оксана','1991-06-08',NULL,NULL,NULL,'0'),
(224,0036,'Шаровська Ірина','1979-11-18',NULL,NULL,NULL,'0'),
(225,0026,'Колодій Оксана','1997-03-30',NULL,NULL,NULL,'0'),
(226,0016,'Андрухів Оксана','1991-05-20',NULL,NULL,NULL,'0'),
(227,0012,'Чмола Наталя','0000-00-00',NULL,380686017463,NULL,'0'),
(228,0006,'Івасів Ірина','1995-05-08',NULL,NULL,NULL,'0'),
(229,0002,'Дзюба Катерина','1997-04-08',NULL,NULL,NULL,'0'),
(230,0957,'Сороківська Уляна','1964-07-26',NULL,380986386047,NULL,'0'),
(231,0885,'Ковганич Ірина','1990-12-16',NULL,380660953307,NULL,'0'),
(232,0664,'Чир Юля',NULL,NULL,380979351620,NULL,'0'),
(233,0482,'Потикевич Христина Орестівна','1992-06-27',NULL,380971292031,NULL,'0'),
(234,0022,'Колотіліна Марія','1977-06-11',NULL,NULL,NULL,'0'),
(235,0042,'Фик Оксана','1995-03-16',NULL,NULL,NULL,'0'),
(236,0032,'Мерецька Надія','1971-07-13',NULL,NULL,NULL,'0'),
(237,0813,'Шедіва Оксана ','1975-01-28',NULL,380965600800,NULL,'0'),
(238,0833,'Богдан Людмила','1982-05-07',NULL,NULL,NULL,'0'),
(239,0889,'МАксимчук Таня','1971-06-16',NULL,380960390049,NULL,'0'),
(240,0953,'Червона Юлія Олегівна','1999-07-21',NULL,380961806256,NULL,'0'),
(241,0943,'Легка Ольга','1998-08-08',NULL,38684202309,NULL,'0'),
(242,0963,'Базюк Христина ','0000-00-00',NULL,380972305110,NULL,'0'),
(243,0773,'Штойко Ірина','1991-05-09',NULL,380937573217,NULL,'0'),
(244,0973,'Данильчишин Світлана','1995-03-23',NULL,380976463718,NULL,'0'),
(245,0753,'Опир Ольга','1993-11-04',NULL,380680063328,NULL,'0'),
(246,0945,'Гура Христина','1996-01-17',NULL,380978415511,NULL,'0'),
(247,0704,'Дунець Ірина','1978-01-01',NULL,NULL,380966793866,'0'),
(248,0694,'Петрас Ольга','1992-04-14',NULL,380984502250,NULL,'0'),
(249,0714,'Винник Ліля','1995-10-26',NULL,380683163756,NULL,'0'),
(250,0734,'Хмелик Леся Ігорівна','1983-03-03',NULL,380679481363,NULL,'0'),
(251,0724,'Кобзар Валерія','1996-05-15',NULL,380966051824,NULL,'0'),
(252,0294,'Граблюк Оксана','0000-00-00',NULL,380684254599,NULL,'0'),
(253,0274,'Богатинська Тетяна','1995-10-12',NULL,38784248299,NULL,'0'),
(254,0284,'Кай Таня','1996-03-27',NULL,380684210185,NULL,'0'),
(255,0865,'Глова Юля Юріївна','0000-00-00',NULL,380684231712,NULL,'0'),
(256,0264,'Лукачина Любов Ярославівна','1976-09-16',NULL,380684231713,NULL,'0'),
(257,0916,'секундяк Оксана','1993-09-15','2016-09-20',380680454107,NULL,'0'),
(258,0906,'Чупіль Наталя','1989-04-16',NULL,380999093960,NULL,'0'),
(259,0896,'Бутриновська Оля','1994-04-20',NULL,380632259452,NULL,'0'),
(260,0000,'','0000-00-00','0000-00-00',38,38,'1'),
(261,0536,'Костів Оксана Ярославівна','1990-06-25',NULL,380977748748,NULL,'0'),
(262,0526,'Павшок Оксана Степанівна','1993-02-14',NULL,380978303074,NULL,'0'),
(263,0452,'Дмитряк Люда','1985-03-30',NULL,380959328785,NULL,'0'),
(264,0606,'Король Ірина ','1987-04-05',NULL,380966455047,NULL,'0'),
(265,0936,'Сорока Світлана','1985-11-10',NULL,380689829190,NULL,'0'),
(266,0592,'Бойчук Оля','1994-02-27',NULL,380989551776,NULL,'0'),
(267,0632,'Турчин Таня','1993-02-24',NULL,380635619263,NULL,'0'),
(268,0512,'Макарчук Наталя','1979-10-06',NULL,380972264420,NULL,'0'),
(269,0622,'Огороднік Таня','1983-11-04',NULL,380678111276,NULL,'0'),
(270,0612,'Бодьо Людмила','1996-12-10',NULL,380686258073,NULL,'0'),
(271,0516,'Бранецька Ілона','1999-09-19',NULL,380660678279,NULL,'0'),
(272,0926,'Карвацька Ульяна','1995-12-14',NULL,380979883642,NULL,'0'),
(273,0855,'Мацишин Тетяна','1995-08-04',NULL,380986475190,NULL,'0'),
(274,0845,'Ряба Ірина','1998-06-12',NULL,380687502345,NULL,'0'),
(275,0674,'Кожухарова Ніні','0000-00-00',NULL,380686965931,NULL,'0'),
(276,0914,'Ванджура Таня','1993-10-28',NULL,NULL,NULL,'0'),
(277,0904,'Смеречинська Ліля ','1992-04-09',NULL,380687502323,NULL,'0'),
(278,0894,'Піць Вікторія','0000-00-00',NULL,380966664871,NULL,'0'),
(279,0556,'Завійська Аліна','1996-07-31',NULL,380984096186,NULL,'0'),
(280,0602,'Котелевич Інна ','1972-05-01',NULL,380667837114,NULL,'0'),
(281,0506,'Галянт Оксана','1992-06-24',NULL,380971072344,NULL,'0'),
(282,0746,'Кінзерська Світлана ','1991-11-28',NULL,380688426252,NULL,'0'),
(283,0636,'Мардаль Марія','1966-05-30',NULL,NULL,NULL,'0'),
(284,0586,'Батенчук Галина ','1972-07-06',NULL,380681604641,NULL,'0'),
(285,0576,'Пшик Інна ','2001-07-12',NULL,380972908779,NULL,'0'),
(286,0566,'Віцентович Аня','1993-05-23',NULL,380968210657,NULL,'0'),
(287,0626,'Бабіч Тетяна','1991-03-14',NULL,380978049984,NULL,'0'),
(288,0924,'Чепига Марія','1993-12-03',NULL,380686465071,NULL,'0'),
(289,0546,'Кравчук Галя','1988-12-04',NULL,380976713520,NULL,'0'),
(290,0616,'Пельвецька Іра','1989-10-28',NULL,380987275141,NULL,'0'),
(291,0596,'Задорожна Аліна','1986-04-05',NULL,380936473842,NULL,'0'),
(292,0402,'Козубенко Юля','1988-03-19',NULL,380671939787,NULL,'0'),
(293,0938,'Заруба Ірина','1994-09-16',NULL,380680900345,NULL,'0'),
(294,0442,'Подоляк Уляна','1997-06-14',NULL,380678702707,NULL,'0'),
(295,0412,'Підсадна Маряна','1991-08-18',NULL,380977205420,NULL,'0'),
(296,0422,'Гаворчак Лариса ','1979-01-20',NULL,380964660240,NULL,'0'),
(297,0382,'Марухна Світлана','1982-03-05',NULL,380993634049,NULL,'0'),
(298,3552,'Буринюк Анастасія','1995-06-18',NULL,380979681257,NULL,'0'),
(299,0044,'Бровко Віка','1986-10-29',NULL,380976984743,NULL,'0'),
(300,0494,'Ярошинська Зоряна','1984-11-21',NULL,380967824303,NULL,'0'),
(301,0454,'Кирилишин Галя','1998-05-29',NULL,380978728064,NULL,'0'),
(302,0464,'Деревенчук Віра','1998-07-06',NULL,380678867061,NULL,'0'),
(303,0474,'Зрайчик Зоряна','1991-04-11',NULL,380968566617,NULL,'0'),
(304,0484,'Шевчук Наталя ','1965-02-15',NULL,380936944237,NULL,'0'),
(305,0434,'Бернецівка Антоніна','1982-11-08',NULL,380678044707,NULL,'0'),
(306,0444,'Микиташ Іра','1997-10-27',NULL,380975410853,NULL,'0'),
(307,0414,'Бадлюк Уляна','2000-08-01',NULL,380961232680,NULL,'0'),
(308,0404,'Бессага Христина','1986-03-09',NULL,380985571506,NULL,'0'),
(309,0424,'Коник Ольга ','1990-12-06',NULL,380664162106,NULL,'0'),
(310,0492,'Гевко Таня','1992-08-04',NULL,380989206755,NULL,'0'),
(311,0362,'Сапіщук Христина ','2005-09-18',NULL,380978674080,NULL,'0'),
(312,0372,'Бугера Оксана','1996-09-02',NULL,380930587294,NULL,'0'),
(313,0392,'Чорна Оксана','1992-08-29',NULL,380503773001,NULL,'0'),
(314,0004,'Єременчук Вікторія','1985-05-29',NULL,380972662317,NULL,'0'),
(315,0534,'Дутка Іра ','1992-11-08',NULL,380984709369,NULL,'0'),
(316,0524,'Мельничин Оля ','1992-06-02',NULL,380982401311,NULL,'0'),
(317,0514,'Железняк Аня','1997-12-11',NULL,380683244458,NULL,'0'),
(319,0384,'Ровінська Тетяна ','1993-09-27',NULL,380967653817,NULL,'0'),
(318,0504,'Чехніта НАталя','1981-07-13',NULL,380674970597,NULL,'0'),
(320,0354,'Слонь Надя ','0000-00-00',NULL,380666623315,NULL,'0'),
(321,0364,'Гаврелюк Марія ','1994-03-15',NULL,380986689558,NULL,'0'),
(322,0498,'Погорецька Руслана','1984-12-20',NULL,380978979438,NULL,'0'),
(323,0458,'Логін Аліна','0000-00-00',NULL,380961895629,NULL,'0'),
(324,0034,'Затварніцька Таня','1994-02-28',NULL,380987277375,NULL,'0'),
(325,0024,'Павлик Марія','0000-00-00',NULL,380986682338,NULL,'0'),
(326,0908,'Білик Марія','1992-08-26',NULL,380997734961,NULL,'0'),
(327,0928,'Роговська Тетяна ','1971-01-28',NULL,380066273500,NULL,'0'),
(328,0010,'Шевцова Інна ','1978-11-23',NULL,380678446009,NULL,'0'),
(329,0050,'ПЕтрів Наталя','1992-07-12',NULL,380930192592,NULL,'0'),
(330,0500,'Билиця Юліанна ','1992-05-14',NULL,380988244096,NULL,'0'),
(331,0552,'Гермак Христина ','1996-04-05',NULL,380637835315,NULL,'0'),
(332,0918,'Чухрій  Лідія','1997-01-30',NULL,380639295185,NULL,'0'),
(333,0460,'Сусяк Тетяна ','1971-07-20',NULL,380688997205,NULL,'0'),
(334,0634,'Ковтун Таня','0000-00-00',NULL,380995517792,NULL,'0'),
(335,0624,'Градова Христина',NULL,NULL,380985931545,NULL,'0'),
(336,0470,'Петришак Ліля','1989-03-04',NULL,380963025860,NULL,'0'),
(337,0480,'Зегарські Уляна ','1989-03-17',NULL,NULL,NULL,'0'),
(338,0490,'Лекар Інна','1993-11-20',NULL,380968769535,NULL,'0'),
(339,0892,'Джурило Люда','1999-08-02',NULL,380977107699,NULL,'0'),
(340,0532,'Тихович Оля','1995-01-16',NULL,380983317792,NULL,'0'),
(341,0522,'Южда Юля','1995-01-29',NULL,NULL,NULL,'0'),
(342,0572,'Білик Анна Василівна','1994-11-06',NULL,380966813467,NULL,'0'),
(343,0562,'Харченко Галина','1978-07-06',NULL,3822196,NULL,'0'),
(344,0542,'Силіцька Юля ','1991-03-23',NULL,380505652479,NULL,'0'),
(345,0374,'Кериченко Наталя','1991-11-30',NULL,380686505904,NULL,'0'),
(346,0614,'Серединська Ліля','1992-02-07',NULL,380685141563,NULL,'0'),
(347,0604,'Когут Таня','1996-09-25',NULL,380673084741,NULL,'0'),
(348,0594,'Стець Надія','1983-12-11',NULL,380970324914,NULL,'0'),
(349,0932,'Кунцьо Наталя ','2002-08-10',NULL,380991339893,NULL,'0'),
(350,0922,'Обшарська Катерина','2007-02-02',NULL,380983544911,NULL,'0'),
(351,0912,'Бублієнко Люба','1968-05-05',NULL,380984707954,NULL,'0'),
(352,0554,'Осьмак Оксана','1994-09-18',NULL,380959187524,NULL,'0'),
(353,0574,'СмукЮля','1999-12-15',NULL,380682384483,NULL,'0'),
(354,0564,'Кулій Оксана','1968-05-27',NULL,NULL,NULL,'0'),
(355,0875,'Титарчук Галя','1989-03-22',NULL,380976067310,NULL,'0'),
(356,0472,'Батрак Антоніна ','1956-09-29',NULL,380977717961,NULL,'0'),
(357,0432,'Якубік Олена','2000-06-27',NULL,380686954286,NULL,'0'),
(358,0898,'Максимчук Марія ','1990-12-07',NULL,380987661093,NULL,'0'),
(359,0388,'Лось Оксана ','1980-08-12',NULL,380975784766,NULL,'0'),
(360,0358,'Градова Юля ','1994-03-27',NULL,380981016279,NULL,'0'),
(361,0368,'Петраш Наталя ','1972-05-06',NULL,380938638969,NULL,'0'),
(362,0398,'Романчук Наталія ','1991-06-11',NULL,38096640814,NULL,'0'),
(363,0378,'наконечна уляна','0000-00-00',NULL,380660467631,NULL,'0'),
(364,0030,'Чоловська Віка','1993-03-20',NULL,38987793468,NULL,'0'),
(365,0462,'Миньок Галина','1970-10-18',NULL,380681976375,NULL,'0'),
(366,0448,'Козлова Руслана','1974-12-28',NULL,380967140957,NULL,'0'),
(367,0502,'Маракіа Віка','0994-12-26',NULL,380971191076,NULL,'0'),
(368,0438,'Холоднюк Іра ','1997-04-02',NULL,380993312951,NULL,'0'),
(369,0468,'Олексяк Наталя ','1992-05-07',NULL,380989722890,NULL,'0'),
(370,0488,'Лаванда Галя ','1989-12-13',NULL,380969098088,NULL,'0'),
(371,0478,'Бойко Анжела ','1997-06-05',NULL,380971500807,NULL,'0'),
(372,0544,'федорчук Ольга  Броніславівна','1975-04-10',NULL,380635995434,NULL,'0'),
(373,0040,'Данилишин Світлана','1997-04-28',NULL,380977154286,NULL,'0'),
(374,0394,'Сєліцька Оксана Михайлівна','1984-10-26',NULL,380666117837,NULL,'0'),
(375,0440,'Бридух Наталія','1990-03-10',NULL,380966390813,NULL,'0'),
(376,0902,'Івановчик Віталіна','1993-07-16',NULL,380680966492,NULL,'0'),
(377,0020,'Матевощук Ліля ','1986-09-17',NULL,380680116070,NULL,'0'),
(378,0410,'обліжок Галина Миколаіна','1978-10-29',NULL,380975658234,NULL,'0'),
(379,0450,'Обліжок Божена Михайлівна','2000-08-18',NULL,380962363212,NULL,'0'),
(380,0742,'Гермак Аліна','1994-04-03',NULL,380684235754,NULL,'0'),
(381,0582,'Шеременда Лілія Теодозіівна','2001-06-15',NULL,380978235314,NULL,'0'),
(382,0934,'Сорокопуд Христина ','1990-09-29',NULL,380950519376,NULL,'0'),
(383,0048,'Сендзюк Леся','1996-05-28',NULL,380968073162,NULL,'0'),
(384,0408,'Брегін Ольга','1986-11-06',NULL,380673508683,NULL,'0'),
(385,0428,'Урсул Уляна','0000-00-00',NULL,NULL,380967833740,'0'),
(386,0038,'Ворона Людмила','0000-00-00',NULL,NULL,NULL,'0'),
(387,0418,'Мороз Ілона','1988-09-22',NULL,380977288220,NULL,'0'),
(388,0014,'Ухман Аня','0000-00-00',NULL,380977020722,NULL,'0'),
(389,0430,'Рудик Стефанія','0000-00-00',NULL,380975906200,NULL,'0'),
(390,0243,'Божагора ОЛя','1966-12-25',NULL,380991569355,NULL,'0'),
(391,0206,'Підгурська Ольга ','1996-02-12',NULL,380977605516,NULL,'0'),
(392,0216,'Коцюк Христина ','1998-04-21',NULL,380976767841,NULL,'0'),
(393,0420,'Бамбурак Таня','1999-06-29',NULL,38678601499,NULL,'0'),
(394,0390,'Волкова Тетяна','1990-12-24',NULL,380969740615,NULL,'0'),
(395,0744,'Гринів Світлана','1981-09-28',NULL,380962162496,NULL,'0'),
(396,0584,'Струтинська Надя','1997-11-02',NULL,380986214657,NULL,'0'),
(397,0360,'Рудик Наталя','0000-00-00',NULL,380973404137,NULL,'0'),
(398,0370,'Гапин Софія','2002-09-18',NULL,380675959379,NULL,'0'),
(399,0078,'Ковбас ірина','1984-09-19',NULL,380956042963,NULL,'0'),
(400,0098,'Нікітін Уляна','1999-05-10',NULL,380978126586,NULL,'0'),
(401,0058,'Леганчук Ірина петрівна','1887-06-02',NULL,38987270995,NULL,'0'),
(402,0400,'Олексишин Наталя','1979-09-06',NULL,380689602204,NULL,'0'),
(403,0380,'Захарчук Наталя','2003-06-01',NULL,380507482687,NULL,'0'),
(404,0088,'Марія Яворська','0000-00-00',NULL,380960782589,NULL,'0'),
(405,0068,'Кожушко Оксана Орестівна','1967-07-02',NULL,380505586166,NULL,'0'),
(406,0018,'Машталляр Марія','0000-00-00',NULL,380686505786,NULL,'0'),
(407,0138,'Корнак Марія','0000-00-00',NULL,380666562311,NULL,'0'),
(408,0128,'Маліцька Каріна','2011-11-03',NULL,380977550575,NULL,'0'),
(409,0118,'Голодівська Ірина','1995-01-28',NULL,380978328028,NULL,'0'),
(410,0108,'Сорока Оля','1995-10-31',NULL,380988173215,NULL,'0'),
(411,0148,'Градова Наталя','1998-10-18',NULL,380676535061,NULL,'0'),
(412,0094,'Наталя Борик','1985-11-10',NULL,380964901909,NULL,'0'),
(413,0184,'Іванка Пельвецька','2001-05-15',NULL,380686241202,NULL,'0'),
(414,0008,'Гринчук Оксана Романівна','2002-02-11',NULL,380962745466,NULL,'0'),
(415,0028,'Песікова Ірина','0000-00-00',NULL,380992901668,NULL,'0'),
(416,0054,'Зубік Тетяна','0000-00-00',NULL,380985786956,NULL,'0'),
(417,0084,'Бойко Тетяна','1993-02-14',NULL,38666002229,NULL,'0'),
(418,0064,'Катиренюк Лілія Ігорівна','1995-10-19',NULL,380955905750,NULL,'0'),
(419,0104,'Романюк Марія','1996-10-15',NULL,380681582500,NULL,'0'),
(420,0114,'Люба Світлана','0000-00-00',NULL,380677603491,NULL,'0'),
(421,0174,'Гузік Лідія','1973-10-03',NULL,380968421873,NULL,'0'),
(422,0144,'Пахолків Марія','0000-00-00',NULL,380978848011,NULL,'0'),
(423,0226,'Голіната Катя Володимирівна','1885-12-14',NULL,380661089766,NULL,'0'),
(424,0194,'Садовяк Наталя','1982-05-19',NULL,380673960535,NULL,'0'),
(425,0164,'Чубко Юлія Іванівна','2001-03-24',NULL,380964244731,NULL,'0'),
(426,0244,'Лесюк Наталія','1976-10-18',NULL,380673547853,NULL,'0'),
(427,0154,'Світлана Боцян','0000-00-00',NULL,380994903960,NULL,'0'),
(428,0234,'Смук Надя','0000-00-00',NULL,380969563163,NULL,'0'),
(429,0224,'Коростіль Ліля','0000-00-00',NULL,380971378266,NULL,'0'),
(430,0204,'станько христина','1991-09-11',NULL,380950601369,NULL,'0'),
(431,0076,'Романчук наталія Вікторівна','1991-06-11',NULL,380966405804,NULL,'0'),
(432,0096,'Веремеєва Віталіна ','0000-00-00',NULL,380985570625,NULL,'0'),
(433,0056,'Коник Вікторія','1990-05-01',NULL,380970510305,NULL,'0'),
(434,0086,'козакевич таня','1988-08-13',NULL,380976397126,NULL,'0'),
(435,0066,'Віка Стельмах','1996-01-16',NULL,380968430179,NULL,'0'),
(436,0136,'Руслана Стельмах','1998-01-17',NULL,380961281891,NULL,'0'),
(437,0116,'Савіцька Христина','0000-00-00',NULL,380500215735,NULL,'0'),
(438,0106,'Смеречинська  Анна','0000-00-00',NULL,380676036318,NULL,'0'),
(439,0176,'Бойчук Юля Андріівна','1997-07-04',NULL,380678464676,NULL,'0'),
(440,NULL,'Роздрібний клієнт','0000-00-00','2017-07-31',NULL,0,'0'),
(441,NULL,'Тестовий Клієнт','0000-00-00','2017-07-31',380501234567,0,'0'),
(442,NULL,'Тест2','0000-00-00','2017-07-31',380509999999,0,'1'),
(443,NULL,'Тест3',NULL,'2017-07-31',3805,NULL,'1'),
(444,NULL,'Тестовий4',NULL,NULL,380500000908,NULL,'1'),
(445,NULL,'Дембіцька Ольга',NULL,'2017-08-01',380970108311,NULL,'0'),
(446,NULL,'Кулій Таня',NULL,NULL,380669487555,NULL,'0'),
(447,NULL,'Мушій Оля',NULL,'2017-08-02',380989718428,NULL,'0'),
(448,NULL,'Харук Леся',NULL,'2017-08-02',380685141589,NULL,'0'),
(449,NULL,'Петрушенко Леся',NULL,'2017-08-02',380973390017,NULL,'0'),
(450,NULL,'Бедрій Оксана',NULL,NULL,380683577900,NULL,'0'),
(451,NULL,'Богайчук Галина',NULL,'2017-08-02',380680931815,NULL,'0'),
(452,NULL,'Демкович Віка',NULL,'2017-08-02',380961394262,NULL,'0'),
(453,NULL,'Шушура Маряна',NULL,'2017-08-02',380975084674,NULL,'0'),
(454,NULL,'Павлишин Наталя',NULL,'2017-08-02',380938126555,NULL,'0'),
(455,NULL,'Колісник Люда',NULL,'2017-08-02',380974813186,NULL,'0'),
(456,NULL,'Підгорецька Оля',NULL,'2017-08-02',380937627072,NULL,'0'),
(457,NULL,'Мороз Ліля',NULL,'2017-08-02',380993232404,NULL,'0'),
(458,NULL,'',NULL,NULL,NULL,NULL,'0'),
(459,NULL,'Кобаль Іра',NULL,NULL,380987686855,NULL,'0'),
(460,NULL,' Бабин Христина',NULL,NULL,380968398760,NULL,'0'),
(461,NULL,'',NULL,NULL,NULL,NULL,'0'),
(462,NULL,'Яблонська Наталя',NULL,'2017-08-03',380678908145,NULL,'0'),
(463,NULL,'Богута Настя',NULL,'2017-08-03',380952054241,NULL,'0'),
(464,NULL,'Федорейко Соломія',NULL,'2017-08-03',380509502222,NULL,'0'),
(465,NULL,'Ватраль Марія',NULL,'2017-08-03',380674392831,NULL,'0'),
(466,NULL,'Шпиголь Ірина',NULL,'2017-08-03',380980143573,NULL,'0'),
(467,NULL,'Чикаловська Вікторія',NULL,'2017-08-03',380666560750,NULL,'0'),
(468,NULL,'Прондюк Ганна2',NULL,NULL,380978723612,NULL,'0'),
(469,NULL,'Наталя',NULL,'2017-08-03',380686469116,NULL,'0'),
(470,NULL,'Грушевська Оля',NULL,'2017-08-03',380988664929,NULL,'0'),
(471,NULL,'Тимчук Оля',NULL,'2017-08-03',380971594301,NULL,'0'),
(472,NULL,'Кулій Діана',NULL,'2017-08-03',380502390588,NULL,'0'),
(473,NULL,'Наталя',NULL,'2017-08-03',380982538049,NULL,'0'),
(474,NULL,'Грицик Марія',NULL,'2017-08-03',380970632251,NULL,'0'),
(475,NULL,'Шарун Соломія',NULL,'2017-08-03',380639296709,NULL,'0'),
(476,NULL,'Гейніш Марія',NULL,'2017-08-03',380970554366,NULL,'0'),
(477,NULL,'Оля',NULL,'2017-08-03',380966765720,NULL,'0'),
(478,NULL,'Грита Іра',NULL,'2017-08-03',380675306850,NULL,'0'),
(479,NULL,'Христя',NULL,'2017-08-03',380683365391,NULL,'0'),
(480,NULL,'Глушин Іра',NULL,'2017-08-03',380675859836,NULL,'0'),
(481,NULL,'Таня н',NULL,NULL,380953143904,NULL,'0'),
(482,NULL,'Железняк Женя',NULL,'2017-08-03',380965710597,NULL,'0'),
(483,NULL,'Гордієнко Оля',NULL,NULL,380963715310,NULL,'0'),
(484,NULL,'Юля',NULL,'2017-08-03',380984794268,NULL,'0'),
(485,NULL,'Бабик Анастасія',NULL,'2017-08-03',380936456101,NULL,'0'),
(486,NULL,'Трембалюк Таня',NULL,'2017-08-03',380962546543,NULL,'0'),
(487,NULL,'Козак Оля',NULL,'2017-08-03',380971040927,NULL,'0'),
(488,NULL,'Наталя Корнелівна',NULL,'2017-08-03',380992549767,NULL,'0'),
(489,NULL,'Наталя',NULL,'2017-08-03',380955913220,NULL,'0'),
(490,NULL,'Болібрус Наталя',NULL,'2017-08-04',380982737225,NULL,'0'),
(491,NULL,'Федоляк Світлана',NULL,'2017-08-04',380976415750,NULL,'0'),
(492,NULL,'Ткачук Наталя ',NULL,'2017-08-04',380503774092,NULL,'0'),
(493,NULL,'Безпалько Люда',NULL,'2017-08-04',380931325161,NULL,'0'),
(494,NULL,'Івашків Оля',NULL,'2017-08-04',380975035464,NULL,'0'),
(495,NULL,'Беднарська Наталя',NULL,'2017-08-04',380968752396,NULL,'0'),
(496,NULL,'Усова Таня ',NULL,'2017-08-04',380953741171,NULL,'0'),
(497,NULL,'Сушельницька Надя',NULL,'2017-08-04',380936580593,NULL,'0'),
(498,NULL,'Бура Аліна',NULL,'2017-08-04',380986490916,NULL,'0'),
(499,NULL,'грабова катя',NULL,NULL,380677433083,NULL,'0'),
(500,NULL,'Мерена Зоя ',NULL,'2017-08-04',380976263720,NULL,'0');

INSERT INTO `kontragentu` VALUES 
(501,NULL,'Федишин Наталя',NULL,'2017-08-04',380969575830,NULL,'0'),
(502,NULL,'Палагнюк Люда',NULL,'2017-08-04',380987018673,NULL,'0'),
(503,NULL,'Негайчук Іра',NULL,'2017-08-04',380967426612,NULL,'0'),
(504,NULL,'Псиляк Наталя',NULL,'2017-08-04',380669240207,NULL,'0'),
(505,NULL,'380987313551',NULL,'2017-08-04',NULL,NULL,'0'),
(506,NULL,'Половчук Оля',NULL,'2017-08-04',380681603844,NULL,'0'),
(507,NULL,'Віра',NULL,'2017-08-04',380984236778,NULL,'0'),
(508,NULL,'Іра ',NULL,'2017-08-04',380989881274,NULL,'0'),
(509,0521,'Чепига Іванна',NULL,NULL,380936418788,NULL,'0'),
(510,NULL,'наконечна оля',NULL,NULL,NULL,NULL,'0'),
(511,NULL,'Вакуленко Наталя',NULL,'2017-08-04',380977010771,NULL,'0'),
(512,NULL,'Клебан Оксана',NULL,'2017-08-04',380665345725,NULL,'0'),
(513,NULL,'Мельничук Оля',NULL,'2017-08-04',380979155006,NULL,'0'),
(514,NULL,'Вакулишин Оля',NULL,NULL,NULL,NULL,'0'),
(515,0220,'Гальтюк Христина',NULL,NULL,NULL,380968398760,'0'),
(516,NULL,'павлюк оксана',NULL,NULL,NULL,NULL,'0'),
(517,NULL,'Павлюк Галина',NULL,'2017-08-04',380689559846,NULL,'0'),
(518,NULL,'Кононова Оля',NULL,NULL,380989883554,NULL,'0'),
(519,NULL,'Волянська Юля',NULL,'2017-08-04',380666511101,NULL,'0'),
(520,NULL,'бабій наталя',NULL,'2017-08-04',380633862196,NULL,'0'),
(521,NULL,'чепига оксана',NULL,NULL,NULL,NULL,'0'),
(522,NULL,'Кучерява Оля',NULL,'2017-08-04',380968415205,NULL,'0'),
(523,NULL,'Дерманська Іра',NULL,'2017-08-04',380680931740,NULL,'0'),
(524,0146,'Зозуляк Таня',NULL,'2017-08-04',383809729598,NULL,'0'),
(525,NULL,'GFfd',NULL,'2017-08-11',380441012220,NULL,'0');

DROP TABLE IF EXISTS `langs`;

CREATE TABLE `langs` (
  `id` smallint(4) NOT NULL auto_increment,
  `key` varchar(30) collate utf8_unicode_ci NOT NULL,
  `name_uk` varchar(2000) collate utf8_unicode_ci NOT NULL,
  `name_ru` varchar(2000) collate utf8_unicode_ci NOT NULL,
  `name_en` varchar(2000) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=370 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci PACK_KEYS=0;

INSERT INTO `langs` VALUES 
(1,'login_vhid','Увійти','',''),
(2,'login_nikname','Нік(піб)','',''),
(3,'login_nick_zaniat','Нік(піб) вже зайнятий, виберіть інший','',''),
(4,'login_incorect_email','Поле email не коректне','',''),
(5,'login_zapov_ren_email','Введіть дійсний email для відновлення доступу до сайту','',''),
(6,'login_tel_zaniat','Номер телефону вже зареєстрований в системі, спробуйте <span onclick=\\\"loginforma_renew();\\\" style=\\\"text-decoration:underline; cursor:pointer;\\\">відновити свій обліковий запис</span>.','',''),
(7,'login_incorect_tel','Номер телефону не коректний','',''),
(8,'login_email_zaniat','Email вже зареєстрований в системі, спробуйте відновити свій обліковий запис, за цим email','',''),
(9,'login_nekid','Був введений не коректний телефон або email','',''),
(10,'login_nepr_lp','Не правильна комбінація логіна і пароля','',''),
(11,'login_nouser','Не знайдено користувача із таким обліковим записом','',''),
(12,'login_incorect','Не заповнено поле логін або пароль, або вони не коректні','',''),
(13,'login_user','nik/email/telephone','',''),
(14,'login_remember_me','Запам\\\"ятати мене','',''),
(15,'login_reg','Реєстрація','',''),
(16,'login_renewal','Відновити пароль','',''),
(17,'login_zareg','Зареєструватись','',''),
(18,'login_m_tel','Моб.&nbsp;Телефон','',''),
(19,'login','Логін','',''),
(20,'Password','Пароль','',''),
(21,'login_new_password','Новий пароль','',''),
(22,'login_zabulu','Відновити пароль','',''),
(23,'login_uvijtu','Увійти','',''),
(24,'login_empty_nikname','Заповніть поле Нік(піб)','',''),
(25,'login_korotkuy_nik','Поле Нік занадто коротке, або незаповнене','',''),
(26,'login_empty_email','Заповніть поле email','',''),
(27,'login_empty_m_tel','Заповніть поле мобільний телефон','',''),
(28,'login_incorect_m_tel','Не коректно заповнено поле мобільний телефон','',''),
(29,'login_empty_password','Заповніть поле Пароль','',''),
(30,'login_korotkuy_password','Поле пароль занадто коротке','',''),
(31,'login_reg_projshla','Реєстрація пройшла успішно.','',''),
(32,'email','Електронна пошта','',''),
(33,'vernytus','Вернутись','',''),
(34,'login_fio','П.І.Б.','',''),
(35,'login_empty_fio','Заповніть поле П.І.Б.','',''),
(36,'login_korotke_fio','Поле П.І.Б. занадато коротке','',''),
(37,'login_vidn_pass','Відновлення паролю','',''),
(38,'login_renew_text','Будь ласка, введіть Вашу адресу електронної пошти, на яку ми вишлемо лист для відновлення паролю.','',''),
(39,'login_vidnovutu','Відновити','',''),
(40,'login_zgadav','Згадав','',''),
(41,'login_uspishnuy_vhid','Ви успішно увійшли, для продовження ','',''),
(42,'login_uspishna_reg','Ви успішно зареєструвались, для продовження ','',''),
(43,'login_click_here','натисніть тут','',''),
(44,'login_email_nosearch','Користувача із такою одресою не зареєстровано','',''),
(45,'login_ren_subject','Відновлення доступу до сайту dvigok.com.ua','',''),
(46,'login_em_p1','<p>Доброго дня.</p> <p>Хтось - можливо, Ви - намагалися і не змогли увійти у свій профіль на dvigok.com.ua і спробували відновити пароль. Для того щоб задати новий пароль, перейдіть за посиланням: ','',''),
(47,'login_em_p2','</p> <p>Якщо ви не запитували цю інформацію, не хвилюйтесь - просто ігноруйте цей лист.</p> <p>&nbsp;</p><p>Команда <a href=\\\"http://dvigok.com.ua\\\">dvigok.com.ua</a>.</p>','',''),
(48,'login_mail_send_1','Електронний лист надіслано, перейдіть в свою поштову скриньку на сайті ','',''),
(49,'login_mail_send_2',', щоб отримати новий пароль','',''),
(50,'zv_uvagu','Зверніть увагу','',''),
(51,'login_vs_n_pass','Встановлення нового паролю','',''),
(52,'login_vstanovutu','Встановити','',''),
(53,'login_zn_n_passw','Введіть новий пароль','',''),
(54,'login_error_no_n_p','Ви не ввели новий пароль, або ввели занадто короткий пароль, поверніться на попередню сторінку і заповніть поле \\\"Новий пароль\\\"','',''),
(55,'login_p_vstanovleno','Пароль встановлено, натисніть кнопку \\\"Увійти\\\", щоб автоматично авторизуватись на сайті','',''),
(56,'login_settings','Налаштування облікового запису','',''),
(57,'login_rozlog_othpc','Вийти зі свого облікового запису на інших пристроях','',''),
(58,'login_oth_pc_vukunuto','Ви успішно вийшли зі свого облікового запису на інших пристроях','',''),
(59,'login_oth_pc_nevuk','Сталася помилка під час виходу з облікового запису на інших пристроях','',''),
(60,'login_empty_name_admina','Не заповнено поле \\\"логін адміністратора\\\"','',''),
(61,'login_incorect_pass','Не вірний пароль','',''),
(62,'admins','Адміністратори','',''),
(63,'status','Статус','',''),
(64,'tel','Телефон','',''),
(65,'stadmin','Старший Адміністратор','',''),
(66,'admin','Адміністратор','',''),
(67,'stvorutu','Створити','',''),
(68,'ker_ob_zap','Керування обліковим записом адміністратора ','',''),
(69,'zag_info_adm','Загальне','',''),
(70,'stat_ob_zap','Статус облікового запису','',''),
(71,'ob_zap_del','Обліковий запис видалено','',''),
(72,'ob_dost_po_ip','Обмеження доступу по IP','',''),
(73,'ob_dost_po_cookie','Обмеження доступу по Cookie','',''),
(74,'on','Ввімкнено','',''),
(75,'vudalutu','Видалити','',''),
(76,'mess_tmp_pass','Адміністратору призначено пароль: ','',''),
(77,'pyst_obl_zapus','Пустий обліковий запис вже було створено, відредагуйте <a href=\\\"?select=admins\\\">його</a>','',''),
(78,'New','Новий','',''),
(79,'ponujennia','Не можливо вносити такі зміни у свій обліковий запис','',''),
(80,'ne_kor_ip','Не коректний IP адміністратора','',''),
(81,'ne_diysnuy_ip','З цієї IP-адреси Вам не дозволено заходити на сайт, попросіть Старшого Адміністратора добавити ваш ір 127.0.0.1 в \\\"список довірених\\\"','',''),
(82,'informer','Інформер','',''),
(83,'date','Дата','',''),
(84,'text','Текст','',''),
(85,'adminka_title','Центр краси LIKE','',''),
(86,'od_vumiry','Одиниці виміру','',''),
(87,'undelete','Відновити','',''),
(88,'q_undelete','Ви впевнені що хочете відновити цей елемент?','',''),
(89,'q_delete','Ви впевнені що хочете видалити цей елемент?','',''),
(90,'najmenuvannia','Найменування','',''),
(91,'specifications','Характеристики','',''),
(92,'sp_tovariv','Характеристики товарів','',''),
(93,'products','Товари','',''),
(94,'rekvizut','Реквізит','',''),
(95,'value','Значення','',''),
(96,'nazva','Назва','',''),
(97,'opus','Опис','',''),
(98,'price','Ціна','',''),
(99,'old_price','Стара ціна','',''),
(100,'stocks','Залишок','',''),
(101,'status_stoks','Статус залишку','',''),
(102,'status_stoks_0','Закінчився','',''),
(103,'status_stoks_1','Закінчується','',''),
(104,'status_stoks_2','В наявності','',''),
(105,'new_product','Новий продукт','',''),
(106,'action','Акція','',''),
(107,'deletest','Видалений','',''),
(108,'pictures','Картинки','',''),
(109,'add_pictures','Додати картинки','',''),
(110,'edit_pictures','Редагувати картинки','',''),
(111,'stvoreno_tovar','Товар створено','',''),
(112,'st_tov_pereytu','Перейти до щойно створеного товару','',''),
(113,'file_est','Такий файл вже є на сервері, поміняйте імя файлу','',''),
(114,'upl_insite','Завантаження картинок на сервер','',''),
(115,'files','Файли','',''),
(116,'http_pict','HTTP картинка','',''),
(117,'z_in_site','(з іншого сайту)','',''),
(118,'opus_pict','Опис картинки <i>(alt)</i>','',''),
(119,'new_pict_name','Нове ім`я<br /><small style=\\\"color:#666;\\\">(тільки англійська)</small>','995',''),
(120,'upload','Завантажити','',''),
(121,'delete_file','Видалити файл','',''),
(122,'zagalne','Загальне','',''),
(123,'log_mess','Лог повідомлень','',''),
(124,'ups_pictures_sk','Завант. картинок','',''),
(125,'comments','Коментарі','',''),
(126,'cookie_editor','Cookie редактор','',''),
(127,'pidpuska','Підписка -@-','',''),
(128,'my_ekaunt','Мій аккаунт','',''),
(129,'bacup_bd','Бекап Бази Даних','',''),
(130,'mysql_editor','MySQL редактор','',''),
(131,'help','Допомога','',''),
(132,'articles','Статті','',''),
(133,'add_article','Створити статтю','',''),
(134,'articles_derevo','Меню дерево статей','',''),
(135,'editor_types','Редактор типів','',''),
(136,'int_magazin','Інт. магазин','',''),
(137,'katalog','Каталог','',''),
(138,'exit_admin','Закінчити роботу','',''),
(139,'backup_zrobleno','Бекап зроблено','',''),
(140,'download_arhiv','Завантажити архів','',''),
(141,'pok_komm_zar_kl','Показувати коментарі зареєстрованих клієнтів','',''),
(142,'no_valid','Не перевірений','',''),
(143,'valid','Перевірений','',''),
(144,'vudalennia','Видалення','',''),
(145,'zast_zminu','Застосувати зміни','',''),
(146,'site_email','Сайт, email','',''),
(147,'comm_text','Текст Коментаря','',''),
(148,'provaliduvatu','Провалідувати','',''),
(149,'unvalidation','Вімінити валідацію','',''),
(150,'email_pidpuska','Підписка на email','',''),
(151,'pidpuska_help','тут можна переглянути cписок<br /> email адрес, що підписались на розсилку','',''),
(152,'clear_log','Очистити лог','',''),
(153,'vub_type_st','Виберіть тип статті','',''),
(154,'vub_pidtype_st','Виберіть підтип статті','',''),
(155,'type_st','Тип статті','',''),
(156,'pidtype_st','Підтип статті','',''),
(157,'adds_article','Менеджер створнення статті','',''),
(158,'dali','Далі','',''),
(159,'editor_statey','Редактор статей','',''),
(160,'dod_settings','Додаткові налаштування','',''),
(161,'reklama','Реклама','',''),
(162,'polazuvatu','Показувати','',''),
(163,'nepolazuvatu','Не показувати','',''),
(164,'delete_art','Видалення статті','',''),
(165,'delete_article','Видалити статтю','',''),
(166,'dell_q1','Ви впевнені що хочете без зворотньо видалити цей запис?','',''),
(167,'dell_q2','Ці зміни будуть не зворотні, продовжуєм?','',''),
(168,'zap_zmanu','Спершу запишіть зміни, щоб видалити цю статтю','',''),
(169,'script_verh','Скрипт \\\"Верх\\\"','',''),
(170,'script_nuz','Скрипт \\\"Низ\\\"','',''),
(171,'all_cats',' всі категорії','',''),
(172,'rozgornytu','Розгорнути','',''),
(173,'zgornytu','Згорнути','',''),
(174,'root','Корінь','',''),
(175,'art_dell','Стаття видалена з бази','',''),
(176,'go_glavna','перейти на головну','',''),
(177,'art_zajniato','Створення статті не здійснено, можливо такий url вже існує','',''),
(178,'url_obovazkove','Поле url обовязкове для заповнення','',''),
(179,'nevkazanuy_id','Не вказаний id статті','',''),
(180,'perekl_vizual','Переключити візуалізатор?','',''),
(181,'no_save','В цьому режимі Збереження працює через іконку зберегти в вікні редагування тексту статті (іконка дискети)','',''),
(182,'save','Зберегти','',''),
(183,'komentuvannia','коментування','',''),
(184,'menu','Меню','',''),
(185,'struktura','Структура','',''),
(186,'red_pidkat','Редактор підкатегорій','',''),
(187,'add','Додати','',''),
(188,'onovutu','Оновити','',''),
(189,'sp_har_zam','Список характеристик по замовчуванню для цієї категорії','',''),
(190,'sp_tovs','Список товарів для цієї категорії','',''),
(191,'slideshow','Слайд шоу','',''),
(192,'zagolovok','Заголовок','',''),
(193,'dod_text','Додатковий текст','',''),
(194,'batkivska_dur','Змінити батьківську директорію','',''),
(195,'valuty','Грошові одиниці','',''),
(196,'valyta','Грошова одиниця','',''),
(197,'nazad_title','Назад','',''),
(198,'nazad','Назад','',''),
(199,'glv','Головна','',''),
(200,'groups_tsin','Групи цін','',''),
(201,'cart','Корзина','',''),
(202,'empty_cart','Ваша корзина пуста.','',''),
(203,'product','Продукт','',''),
(204,'kilkist','Кількість','',''),
(205,'suma','Сума','',''),
(206,'delete_tovar','Видалити цю позицію','',''),
(207,'comentar_zamovl','Коментар до замовлення','',''),
(208,'end_zakaza','Замовлення підтверджую','',''),
(209,'kataloga_nema','Каталогаа не знайдено','',''),
(210,'print_zakaz','Роздрукувати замовлення','',''),
(211,'kod_tovara','Код товару','',''),
(212,'grn','грн.','',''),
(213,'zamovlennia','Замовлення','',''),
(214,'vid','від','',''),
(215,'data_z','Дата з','',''),
(216,'data_do','Дата до','',''),
(239,'pidbur_tovs_0','Розпочате','',''),
(218,'pay_method','Спосіб оплати','',''),
(245,'sposib_op_0','Готівка при отриманні','',''),
(220,'edit','редагувати','',''),
(221,'vlasnuk','Власник','',''),
(222,'in_cart','В корзині ','',''),
(223,'tovar','покупка','',''),
(224,'tovariv','покупки','',''),
(225,'tovariv_big','покупок','',''),
(226,'link','Посилання','',''),
(227,'pereglianytu','Переглянути','',''),
(228,'recommended','Рекомендований','',''),
(229,'discount','Знижка','',''),
(230,'ne_vuk_umovu_ajax','Не виконані всі необхідні умови для виконання ajax-запиту','',''),
(231,'langs','Мови','',''),
(232,'error_internet','Помилка: Відсутній доступ до мережі Інтернет, перевірте з\\\'єднання і повторіть спробу','',''),
(233,'name','Ім\\\'я','',''),
(234,'login_ch_komp','Чужий комп\\\'ютер','',''),
(235,'search','Пошук','Поиск',''),
(240,'pidbur_tovs_1','Оформлене','',''),
(241,'pidbur_tovs_2','Опрацьоване','',''),
(242,'pidbur_tovs_3','Скасоване','',''),
(243,'pidbur_tovs_4','Передане в 1С','',''),
(244,'pidbur_tovs_5','Завершене','',''),
(246,'sposib_op_1','Передоплата на картку Приватбанку','',''),
(247,'empty_komirku','Підсвітити незаповнені комірки','',''),
(248,'code','Код','',''),
(249,'save_all','Зберегти всі','',''),
(250,'cron','Плановані завдання','',''),
(251,'date_start','Дата початку','',''),
(252,'date_end','Дата закінчення','',''),
(253,'days','Дні','',''),
(254,'time_start','Час початку','',''),
(255,'periodicity','Періодичність','',''),
(256,'d1','Пн.','',''),
(257,'d2','Вт.','',''),
(258,'d3','Ср.','',''),
(259,'d4','Чт.','',''),
(260,'d5','Пт.','',''),
(261,'d6','Сб.','',''),
(262,'d7','Нд.','',''),
(263,'warning','Увага','',''),
(264,'optumizator','Оптимізатор','',''),
(265,'klients','Клієнти','',''),
(266,'poslygu','Послуги','',''),
(267,'pratsivnuku','Працівники','',''),
(268,'L_nastupna','Наступна','',''),
(269,'L_porepedn','Попередня','',''),
(270,'L_pokazano','Показано','',''),
(271,'nazva_poslygu','Назва послуги','',''),
(272,'prava','Права','',''),
(273,'rozrobnuk','Програміст','',''),
(274,'director','Директор','',''),
(275,'admin_salony','Адміністратор салону','',''),
(276,'pratsivnuk_salony','Працівник салону','',''),
(277,'korustuvachi','Користувачі','',''),
(278,'tvukposl','Час вик. послуг','',''),
(279,'timevukposl','Час виконання послуг працівниками','',''),
(280,'schedule','Розклад','',''),
(281,'groups','Групи','',''),
(282,'group','Група','',''),
(283,'bezgroup','Без групи','',''),
(284,'all','Всі','',''),
(285,'poslyga','Послуга','',''),
(286,'vub_poslygy','Виберіть послугу','',''),
(287,'no_time_posl','В цього майстра не проставленгий час виконання його послуг, спершу <a href=\\\"?select=time_vuk_poslug\\\">тут заповніть</a> час виконання ним послуг','',''),
(288,'master','Майстер','',''),
(289,'time','Час','',''),
(290,'klient','Клієнт','',''),
(291,'kartka','Картка','',''),
(292,'pib','ПІБ','',''),
(293,'tel2','Тел.2','',''),
(294,'tel_korotko','Тел.','',''),
(295,'truvalist','Тривалість','',''),
(296,'zakinn','Закінчення','',''),
(297,'mysql_console','MSQL консоль','',''),
(298,'vunevubkonr','Ви не вибрали клієнта, або не заповнили інформацію про нового клієнта','',''),
(299,'oj','Ой...','',''),
(300,'comment','Коментар','',''),
(301,'delete_event','Видалити запис','',''),
(302,'create_payment','Створити оплату','',''),
(303,'no_prav','Не достатньо прав для здійснення цієї операції','',''),
(304,'del_record_conf','Ви впевнені що бажаєте видалити запис?','',''),
(305,'materialu','Матеріали','',''),
(306,'oplata','Оплата послуг','',''),
(307,'vsiogo','Всього','',''),
(308,'zajniato','Зайнято','',''),
(309,'oplatcheno','Оплачено','',''),
(310,'sms_service','СМС сервіс','',''),
(311,'malonarah','У Вас на смс-рахунку мала кількість коштів. <a href=\\\"?select=sms_service\\\">Поповніть свій рахунок</a>','',''),
(312,'kasa_zvit','Фінансовий звіт','',''),
(313,'vn_oplatu','Внести кошти','',''),
(314,'ob_klienta','Виберіть клієнта','',''),
(315,'m01','січня','',''),
(316,'m02','лютого','',''),
(317,'m03','березня','',''),
(318,'m04','квітня','',''),
(319,'m05','травня','',''),
(320,'m06','червня','',''),
(321,'m07','липня','',''),
(322,'m08','серпня','',''),
(323,'m09','вересня','',''),
(324,'m10','жовтня','',''),
(325,'m11','листопада','',''),
(326,'m12','грудня','',''),
(327,'sms_poperedj','Зачекайте! Надсилаються смс. Не виконуйте ніяких дій у браузері.','',''),
(328,'stat_1','Розробник','',''),
(329,'stat_2','Директор','',''),
(330,'stat_3','Адміністратор салону','',''),
(331,'stat_4','Майстер','',''),
(332,'vid_rank_god','Відображати ранкові години','',''),
(333,'new_pib','ПІБ нового клієнта','',''),
(334,'pro_kor_tel_format','Поле телефон повинно бути у форматі 380хххххххххх','',''),
(335,'pay_docs','Касові документи','',''),
(336,'vart_mat','Вартість матеріалів','',''),
(337,'vart_posl','Вартість послуг','',''),
(338,'zavd','№ Завдання','',''),
(339,'dd0','неділя','',''),
(340,'dd1','понеділок','',''),
(341,'dd2','вівторок','',''),
(342,'dd3','середа','',''),
(343,'dd4','четвер','',''),
(344,'dd5','п\\\'ятниця','',''),
(345,'dd6','субота','',''),
(346,'add_vacation','Створити відпустку','',''),
(347,'zabronuv','Забронювати час','',''),
(348,'err_prom_vajniat','В даному проміжку дат вже є створені завдання, внести вихідні дні неможливо. Спочатку видаліть існуючі забронювані клієнтами місця','',''),
(349,'err_nev_dates','Не вірні значення в дати, виправіть дату','',''),
(350,'dell_holiday','Видалити вихідний день','',''),
(351,'inp_pass','Введіть пароль','',''),
(352,'vud_zarplatu','Видати зарплату','',''),
(353,'vut_koshtiv','Витрати коштів','',''),
(354,'sum_groshey','Сума грошей','',''),
(355,'st_doc_vt_kosh','Створення документу витрата коштів','',''),
(356,'st_doc_vud_zp','Створення документу видача зарплати','',''),
(357,'pole_pr_ne_zap','Вкажіть працівника','',''),
(358,'zap_date','Заповніть поле \\\"Дата\\\"','',''),
(359,'zap_cash','Заповніть поле \\\"Сума грошей\\\"','',''),
(360,'zap_note','Заповніть поле \\\"Коментар\\\"','',''),
(361,'oth_vutr','Інші витрати','',''),
(362,'author','Автор','',''),
(363,'dr0','неділю','',''),
(364,'dr1','понеділок','',''),
(365,'dr2','вівторок','',''),
(366,'dr3','середу','',''),
(367,'dr4','червер','',''),
(368,'dr5','п\\\'ятницю','',''),
(369,'dr6','суботу','','');

DROP TABLE IF EXISTS `payments`;

CREATE TABLE `payments` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `schedule_id` smallint(5) unsigned default NULL,
  `datetime` datetime NOT NULL,
  `master_id` smallint(3) unsigned default NULL,
  `klient_id` smallint(5) unsigned default NULL,
  `poslyga_id` smallint(4) unsigned default NULL,
  `materialu` decimal(6,2) NOT NULL default '0.00',
  `robota` decimal(7,2) NOT NULL default '0.00',
  `oth_payment` decimal(7,2) NOT NULL default '0.00',
  `note` varchar(50) collate utf8_unicode_ci default NULL,
  `datetime_create` datetime NOT NULL,
  `author` tinyint(3) unsigned NOT NULL,
  `lasthero` tinyint(3) unsigned default NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `klient_id` (`klient_id`),
  KEY `robota` (`robota`),
  KEY `delete` (`delete`)
) ENGINE=MyISAM AUTO_INCREMENT=359 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Тут тримаються оплати від клієнтів';

INSERT INTO `payments` VALUES 
(1,NULL,'2017-07-31 00:00:00',NULL,1,NULL,0.00,2454.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(2,NULL,'2017-07-31 00:00:00',NULL,2,NULL,0.00,1154.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(3,NULL,'2017-07-31 00:00:00',NULL,5,NULL,0.00,1683.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(4,NULL,'2017-07-31 00:00:00',NULL,6,NULL,0.00,335.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(5,NULL,'2017-07-31 00:00:00',NULL,7,NULL,0.00,1937.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(6,NULL,'2017-07-31 00:00:00',NULL,8,NULL,0.00,388.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(7,NULL,'2017-07-31 00:00:00',NULL,9,NULL,0.00,529.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(8,NULL,'2017-07-31 00:00:00',NULL,10,NULL,0.00,1475.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(9,NULL,'2017-07-31 00:00:00',NULL,11,NULL,0.00,747.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(10,NULL,'2017-07-31 00:00:00',NULL,12,NULL,0.00,1085.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(11,NULL,'2017-07-31 00:00:00',NULL,13,NULL,0.00,592.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(12,NULL,'2017-07-31 00:00:00',NULL,15,NULL,0.00,4843.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(13,NULL,'2017-07-31 00:00:00',NULL,16,NULL,0.00,78.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(14,NULL,'2017-07-31 00:00:00',NULL,17,NULL,0.00,4524.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(15,NULL,'2017-07-31 00:00:00',NULL,19,NULL,0.00,4240.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(16,NULL,'2017-07-31 00:00:00',NULL,20,NULL,0.00,465.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(17,NULL,'2017-07-31 00:00:00',NULL,21,NULL,0.00,3766.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(18,NULL,'2017-07-31 00:00:00',NULL,23,NULL,0.00,1285.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(19,NULL,'2017-07-31 00:00:00',NULL,24,NULL,0.00,2668.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(20,NULL,'2017-07-31 00:00:00',NULL,25,NULL,0.00,7587.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(21,NULL,'2017-07-31 00:00:00',NULL,26,NULL,0.00,4141.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(22,NULL,'2017-07-31 00:00:00',NULL,31,NULL,0.00,5498.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(23,NULL,'2017-07-31 00:00:00',NULL,32,NULL,0.00,1936.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(24,NULL,'2017-07-31 00:00:00',NULL,33,NULL,0.00,2555.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(25,NULL,'2017-07-31 00:00:00',NULL,34,NULL,0.00,2571.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(26,NULL,'2017-07-31 00:00:00',NULL,36,NULL,0.00,1388.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(27,NULL,'2017-07-31 00:00:00',NULL,37,NULL,0.00,1527.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(28,NULL,'2017-07-31 00:00:00',NULL,38,NULL,0.00,2586.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(29,NULL,'2017-07-31 00:00:00',NULL,39,NULL,0.00,393.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(30,NULL,'2017-07-31 00:00:00',NULL,41,NULL,0.00,999.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(31,NULL,'2017-07-31 00:00:00',NULL,43,NULL,0.00,703.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(32,NULL,'2017-07-31 00:00:00',NULL,44,NULL,0.00,470.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(33,NULL,'2017-07-31 00:00:00',NULL,45,NULL,0.00,1257.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(34,NULL,'2017-07-31 00:00:00',NULL,46,NULL,0.00,2445.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(35,NULL,'2017-07-31 00:00:00',NULL,47,NULL,0.00,2087.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(36,NULL,'2017-07-31 00:00:00',NULL,48,NULL,0.00,2928.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(37,NULL,'2017-07-31 00:00:00',NULL,49,NULL,0.00,2347.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(38,NULL,'2017-07-31 00:00:00',NULL,50,NULL,0.00,2135.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(39,NULL,'2017-07-31 00:00:00',NULL,51,NULL,0.00,417.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(40,NULL,'2017-07-31 00:00:00',NULL,53,NULL,0.00,1820.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(41,NULL,'2017-07-31 00:00:00',NULL,54,NULL,0.00,466.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(42,NULL,'2017-07-31 00:00:00',NULL,55,NULL,0.00,475.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(43,NULL,'2017-07-31 00:00:00',NULL,56,NULL,0.00,2839.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(44,NULL,'2017-07-31 00:00:00',NULL,57,NULL,0.00,155.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(45,NULL,'2017-07-31 00:00:00',NULL,58,NULL,0.00,136.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(46,NULL,'2017-07-31 00:00:00',NULL,60,NULL,0.00,2758.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(47,NULL,'2017-07-31 00:00:00',NULL,61,NULL,0.00,1426.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(48,NULL,'2017-07-31 00:00:00',NULL,62,NULL,0.00,126.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(49,NULL,'2017-07-31 00:00:00',NULL,63,NULL,0.00,3424.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(50,NULL,'2017-07-31 00:00:00',NULL,65,NULL,0.00,8600.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(51,NULL,'2017-07-31 00:00:00',NULL,66,NULL,0.00,2066.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(52,NULL,'2017-07-31 00:00:00',NULL,67,NULL,0.00,4156.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(53,NULL,'2017-07-31 00:00:00',NULL,68,NULL,0.00,9356.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(54,NULL,'2017-07-31 00:00:00',NULL,70,NULL,0.00,1926.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(55,NULL,'2017-07-31 00:00:00',NULL,71,NULL,0.00,1683.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(56,NULL,'2017-07-31 00:00:00',NULL,72,NULL,0.00,2468.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(57,NULL,'2017-07-31 00:00:00',NULL,73,NULL,0.00,68.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(58,NULL,'2017-07-31 00:00:00',NULL,74,NULL,0.00,563.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(59,NULL,'2017-07-31 00:00:00',NULL,75,NULL,0.00,539.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(60,NULL,'2017-07-31 00:00:00',NULL,77,NULL,0.00,2334.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(61,NULL,'2017-07-31 00:00:00',NULL,79,NULL,0.00,6035.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(62,NULL,'2017-07-31 00:00:00',NULL,81,NULL,0.00,8477.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(63,NULL,'2017-07-31 00:00:00',NULL,82,NULL,0.00,1286.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(64,NULL,'2017-07-31 00:00:00',NULL,83,NULL,0.00,301.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(65,NULL,'2017-07-31 00:00:00',NULL,84,NULL,0.00,136.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(66,NULL,'2017-07-31 00:00:00',NULL,85,NULL,0.00,339.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(67,NULL,'2017-07-31 00:00:00',NULL,88,NULL,0.00,2425.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(68,NULL,'2017-07-31 00:00:00',NULL,89,NULL,0.00,1256.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(69,NULL,'2017-07-31 00:00:00',NULL,90,NULL,0.00,2791.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(70,NULL,'2017-07-31 00:00:00',NULL,91,NULL,0.00,11634.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(71,NULL,'2017-07-31 00:00:00',NULL,92,NULL,0.00,262.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(72,NULL,'2017-07-31 00:00:00',NULL,93,NULL,0.00,7499.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(73,NULL,'2017-07-31 00:00:00',NULL,94,NULL,0.00,2484.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(74,NULL,'2017-07-31 00:00:00',NULL,96,NULL,0.00,859.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(75,NULL,'2017-07-31 00:00:00',NULL,98,NULL,0.00,3211.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(76,NULL,'2017-07-31 00:00:00',NULL,99,NULL,0.00,3115.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(77,NULL,'2017-07-31 00:00:00',NULL,101,NULL,0.00,1678.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(78,NULL,'2017-07-31 00:00:00',NULL,102,NULL,0.00,170.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(79,NULL,'2017-07-31 00:00:00',NULL,104,NULL,0.00,3717.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(80,NULL,'2017-07-31 00:00:00',NULL,105,NULL,0.00,394.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(81,NULL,'2017-07-31 00:00:00',NULL,106,NULL,0.00,68.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(82,NULL,'2017-07-31 00:00:00',NULL,107,NULL,0.00,1863.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(83,NULL,'2017-07-31 00:00:00',NULL,108,NULL,0.00,514.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(84,NULL,'2017-07-31 00:00:00',NULL,109,NULL,0.00,194.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(85,NULL,'2017-07-31 00:00:00',NULL,110,NULL,0.00,349.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(86,NULL,'2017-07-31 00:00:00',NULL,111,NULL,0.00,2231.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(87,NULL,'2017-07-31 00:00:00',NULL,112,NULL,0.00,2131.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(88,NULL,'2017-07-31 00:00:00',NULL,114,NULL,0.00,2262.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(89,NULL,'2017-07-31 00:00:00',NULL,115,NULL,0.00,6917.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(90,NULL,'2017-07-31 00:00:00',NULL,116,NULL,0.00,752.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(91,NULL,'2017-07-31 00:00:00',NULL,118,NULL,0.00,29.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(92,NULL,'2017-07-31 00:00:00',NULL,119,NULL,0.00,3482.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(93,NULL,'2017-07-31 00:00:00',NULL,122,NULL,0.00,684.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(94,NULL,'2017-07-31 00:00:00',NULL,123,NULL,0.00,1073.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(95,NULL,'2017-07-31 00:00:00',NULL,124,NULL,0.00,2613.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(96,NULL,'2017-07-31 00:00:00',NULL,125,NULL,0.00,2825.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(97,NULL,'2017-07-31 00:00:00',NULL,126,NULL,0.00,533.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(98,NULL,'2017-07-31 00:00:00',NULL,128,NULL,0.00,1629.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(99,NULL,'2017-07-31 00:00:00',NULL,129,NULL,0.00,262.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(100,NULL,'2017-07-31 00:00:00',NULL,130,NULL,0.00,6925.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(101,NULL,'2017-07-31 00:00:00',NULL,131,NULL,0.00,3803.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(102,NULL,'2017-07-31 00:00:00',NULL,132,NULL,0.00,4860.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(103,NULL,'2017-07-31 00:00:00',NULL,133,NULL,0.00,3191.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(104,NULL,'2017-07-31 00:00:00',NULL,135,NULL,0.00,1271.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(105,NULL,'2017-07-31 00:00:00',NULL,136,NULL,0.00,1285.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(106,NULL,'2017-07-31 00:00:00',NULL,137,NULL,0.00,8499.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(107,NULL,'2017-07-31 00:00:00',NULL,138,NULL,0.00,4745.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(108,NULL,'2017-07-31 00:00:00',NULL,139,NULL,0.00,3564.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(109,NULL,'2017-07-31 00:00:00',NULL,140,NULL,0.00,3023.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(110,NULL,'2017-07-31 00:00:00',NULL,141,NULL,0.00,97.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(111,NULL,'2017-07-31 00:00:00',NULL,143,NULL,0.00,12581.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(112,NULL,'2017-07-31 00:00:00',NULL,144,NULL,0.00,3415.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(113,NULL,'2017-07-31 00:00:00',NULL,145,NULL,0.00,1057.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(114,NULL,'2017-07-31 00:00:00',NULL,146,NULL,0.00,340.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(115,NULL,'2017-07-31 00:00:00',NULL,147,NULL,0.00,955.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(116,NULL,'2017-07-31 00:00:00',NULL,148,NULL,0.00,680.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(117,NULL,'2017-07-31 00:00:00',NULL,149,NULL,0.00,5768.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(118,NULL,'2017-07-31 00:00:00',NULL,150,NULL,0.00,3536.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(119,NULL,'2017-07-31 00:00:00',NULL,151,NULL,0.00,1843.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(120,NULL,'2017-07-31 00:00:00',NULL,152,NULL,0.00,2943.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(121,NULL,'2017-07-31 00:00:00',NULL,153,NULL,0.00,4322.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(122,NULL,'2017-07-31 00:00:00',NULL,154,NULL,0.00,2086.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(123,NULL,'2017-07-31 00:00:00',NULL,155,NULL,0.00,969.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(124,NULL,'2017-07-31 00:00:00',NULL,156,NULL,0.00,4007.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(125,NULL,'2017-07-31 00:00:00',NULL,159,NULL,0.00,987.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(126,NULL,'2017-07-31 00:00:00',NULL,160,NULL,0.00,2814.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(127,NULL,'2017-07-31 00:00:00',NULL,163,NULL,0.00,3657.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(128,NULL,'2017-07-31 00:00:00',NULL,166,NULL,0.00,213.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(129,NULL,'2017-07-31 00:00:00',NULL,167,NULL,0.00,2113.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(130,NULL,'2017-07-31 00:00:00',NULL,169,NULL,0.00,514.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(131,NULL,'2017-07-31 00:00:00',NULL,171,NULL,0.00,514.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(132,NULL,'2017-07-31 00:00:00',NULL,173,NULL,0.00,2479.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(133,NULL,'2017-07-31 00:00:00',NULL,174,NULL,0.00,863.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(134,NULL,'2017-07-31 00:00:00',NULL,175,NULL,0.00,2535.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(135,NULL,'2017-07-31 00:00:00',NULL,176,NULL,0.00,11438.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(136,NULL,'2017-07-31 00:00:00',NULL,177,NULL,0.00,146.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(137,NULL,'2017-07-31 00:00:00',NULL,178,NULL,0.00,340.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(138,NULL,'2017-07-31 00:00:00',NULL,180,NULL,0.00,272.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(139,NULL,'2017-07-31 00:00:00',NULL,182,NULL,0.00,427.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(140,NULL,'2017-07-31 00:00:00',NULL,183,NULL,0.00,13217.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(141,NULL,'2017-07-31 00:00:00',NULL,184,NULL,0.00,1343.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(142,NULL,'2017-07-31 00:00:00',NULL,186,NULL,0.00,291.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(143,NULL,'2017-07-31 00:00:00',NULL,187,NULL,0.00,6545.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(144,NULL,'2017-07-31 00:00:00',NULL,188,NULL,0.00,8047.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(145,NULL,'2017-07-31 00:00:00',NULL,191,NULL,0.00,6320.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(146,NULL,'2017-07-31 00:00:00',NULL,192,NULL,0.00,592.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(147,NULL,'2017-07-31 00:00:00',NULL,193,NULL,0.00,4668.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(148,NULL,'2017-07-31 00:00:00',NULL,194,NULL,0.00,194.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(149,NULL,'2017-07-31 00:00:00',NULL,196,NULL,0.00,4644.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(150,NULL,'2017-07-31 00:00:00',NULL,197,NULL,0.00,1605.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(151,NULL,'2017-07-31 00:00:00',NULL,198,NULL,0.00,2479.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(152,NULL,'2017-07-31 00:00:00',NULL,203,NULL,0.00,13487.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(153,NULL,'2017-07-31 00:00:00',NULL,204,NULL,0.00,2008.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(154,NULL,'2017-07-31 00:00:00',NULL,205,NULL,0.00,452.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(155,NULL,'2017-07-31 00:00:00',NULL,206,NULL,0.00,485.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(156,NULL,'2017-07-31 00:00:00',NULL,207,NULL,0.00,1591.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(157,NULL,'2017-07-31 00:00:00',NULL,209,NULL,0.00,5496.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(158,NULL,'2017-07-31 00:00:00',NULL,210,NULL,0.00,2358.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(159,NULL,'2017-07-31 00:00:00',NULL,212,NULL,0.00,6786.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(160,NULL,'2017-07-31 00:00:00',NULL,214,NULL,0.00,491.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(161,NULL,'2017-07-31 00:00:00',NULL,215,NULL,0.00,6205.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(162,NULL,'2017-07-31 00:00:00',NULL,218,NULL,0.00,582.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(163,NULL,'2017-07-31 00:00:00',NULL,219,NULL,0.00,6289.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(164,NULL,'2017-07-31 00:00:00',NULL,220,NULL,0.00,1919.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(165,NULL,'2017-07-31 00:00:00',NULL,221,NULL,0.00,1198.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(166,NULL,'2017-07-31 00:00:00',NULL,222,NULL,0.00,1527.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(167,NULL,'2017-07-31 00:00:00',NULL,223,NULL,0.00,2594.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(168,NULL,'2017-07-31 00:00:00',NULL,224,NULL,0.00,214.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(169,NULL,'2017-07-31 00:00:00',NULL,227,NULL,0.00,1588.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(170,NULL,'2017-07-31 00:00:00',NULL,228,NULL,0.00,277.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(171,NULL,'2017-07-31 00:00:00',NULL,229,NULL,0.00,330.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(172,NULL,'2017-07-31 00:00:00',NULL,230,NULL,0.00,640.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(173,NULL,'2017-07-31 00:00:00',NULL,231,NULL,0.00,4602.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(174,NULL,'2017-07-31 00:00:00',NULL,232,NULL,0.00,1805.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(175,NULL,'2017-07-31 00:00:00',NULL,233,NULL,0.00,2848.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(176,NULL,'2017-07-31 00:00:00',NULL,234,NULL,0.00,660.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(177,NULL,'2017-07-31 00:00:00',NULL,239,NULL,0.00,3528.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(178,NULL,'2017-07-31 00:00:00',NULL,240,NULL,0.00,1901.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(179,NULL,'2017-07-31 00:00:00',NULL,241,NULL,0.00,340.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(180,NULL,'2017-07-31 00:00:00',NULL,244,NULL,0.00,160.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(181,NULL,'2017-07-31 00:00:00',NULL,245,NULL,0.00,437.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(182,NULL,'2017-07-31 00:00:00',NULL,246,NULL,0.00,679.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(183,NULL,'2017-07-31 00:00:00',NULL,247,NULL,0.00,485.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(184,NULL,'2017-07-31 00:00:00',NULL,248,NULL,0.00,611.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(185,NULL,'2017-07-31 00:00:00',NULL,250,NULL,0.00,2173.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(186,NULL,'2017-07-31 00:00:00',NULL,251,NULL,0.00,1732.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(187,NULL,'2017-07-31 00:00:00',NULL,252,NULL,0.00,340.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(188,NULL,'2017-07-31 00:00:00',NULL,253,NULL,0.00,723.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(189,NULL,'2017-07-31 00:00:00',NULL,254,NULL,0.00,776.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(190,NULL,'2017-07-31 00:00:00',NULL,255,NULL,0.00,44.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(191,NULL,'2017-07-31 00:00:00',NULL,257,NULL,0.00,592.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(192,NULL,'2017-07-31 00:00:00',NULL,258,NULL,0.00,2494.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(193,NULL,'2017-07-31 00:00:00',NULL,261,NULL,0.00,1611.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(194,NULL,'2017-07-31 00:00:00',NULL,263,NULL,0.00,747.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(195,NULL,'2017-07-31 00:00:00',NULL,264,NULL,0.00,1349.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(196,NULL,'2017-07-31 00:00:00',NULL,266,NULL,0.00,310.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(197,NULL,'2017-07-31 00:00:00',NULL,267,NULL,0.00,1803.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(198,NULL,'2017-07-31 00:00:00',NULL,268,NULL,0.00,2153.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(199,NULL,'2017-07-31 00:00:00',NULL,269,NULL,0.00,2899.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(200,NULL,'2017-07-31 00:00:00',NULL,270,NULL,0.00,126.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(201,NULL,'2017-07-31 00:00:00',NULL,272,NULL,0.00,1910.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(202,NULL,'2017-07-31 00:00:00',NULL,275,NULL,0.00,320.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(203,NULL,'2017-07-31 00:00:00',NULL,277,NULL,0.00,456.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(204,NULL,'2017-07-31 00:00:00',NULL,279,NULL,0.00,533.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(205,NULL,'2017-07-31 00:00:00',NULL,280,NULL,0.00,1259.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(206,NULL,'2017-07-31 00:00:00',NULL,282,NULL,0.00,466.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(207,NULL,'2017-07-31 00:00:00',NULL,283,NULL,0.00,932.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(208,NULL,'2017-07-31 00:00:00',NULL,284,NULL,0.00,485.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(209,NULL,'2017-07-31 00:00:00',NULL,289,NULL,0.00,873.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(210,NULL,'2017-07-31 00:00:00',NULL,291,NULL,0.00,2162.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(211,NULL,'2017-07-31 00:00:00',NULL,292,NULL,0.00,4778.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(212,NULL,'2017-07-31 00:00:00',NULL,294,NULL,0.00,2541.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(213,NULL,'2017-07-31 00:00:00',NULL,296,NULL,0.00,1252.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(214,NULL,'2017-07-31 00:00:00',NULL,297,NULL,0.00,921.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(215,NULL,'2017-07-31 00:00:00',NULL,298,NULL,0.00,347.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(216,NULL,'2017-07-31 00:00:00',NULL,303,NULL,0.00,660.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(217,NULL,'2017-07-31 00:00:00',NULL,304,NULL,0.00,1325.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(218,NULL,'2017-07-31 00:00:00',NULL,305,NULL,0.00,1062.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(219,NULL,'2017-07-31 00:00:00',NULL,307,NULL,0.00,2308.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(220,NULL,'2017-07-31 00:00:00',NULL,308,NULL,0.00,398.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(221,NULL,'2017-07-31 00:00:00',NULL,309,NULL,0.00,175.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(222,NULL,'2017-07-31 00:00:00',NULL,312,NULL,0.00,597.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(223,NULL,'2017-07-31 00:00:00',NULL,313,NULL,0.00,889.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(224,NULL,'2017-07-31 00:00:00',NULL,314,NULL,0.00,758.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(225,NULL,'2017-07-31 00:00:00',NULL,315,NULL,0.00,155.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(226,NULL,'2017-07-31 00:00:00',NULL,317,NULL,0.00,4379.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(227,NULL,'2017-07-31 00:00:00',NULL,318,NULL,0.00,546.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(228,NULL,'2017-07-31 00:00:00',NULL,320,NULL,0.00,816.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(229,NULL,'2017-07-31 00:00:00',NULL,321,NULL,0.00,1321.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(230,NULL,'2017-07-31 00:00:00',NULL,322,NULL,0.00,1452.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(231,NULL,'2017-07-31 00:00:00',NULL,323,NULL,0.00,660.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(232,NULL,'2017-07-31 00:00:00',NULL,325,NULL,0.00,1950.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(233,NULL,'2017-07-31 00:00:00',NULL,326,NULL,0.00,350.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(234,NULL,'2017-07-31 00:00:00',NULL,327,NULL,0.00,932.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(235,NULL,'2017-07-31 00:00:00',NULL,328,NULL,0.00,1048.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(236,NULL,'2017-07-31 00:00:00',NULL,329,NULL,0.00,359.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(237,NULL,'2017-07-31 00:00:00',NULL,331,NULL,0.00,243.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(238,NULL,'2017-07-31 00:00:00',NULL,333,NULL,0.00,526.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(239,NULL,'2017-07-31 00:00:00',NULL,334,NULL,0.00,257.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(240,NULL,'2017-07-31 00:00:00',NULL,335,NULL,0.00,1730.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(241,NULL,'2017-07-31 00:00:00',NULL,336,NULL,0.00,795.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(242,NULL,'2017-07-31 00:00:00',NULL,337,NULL,0.00,1295.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(243,NULL,'2017-07-31 00:00:00',NULL,342,NULL,0.00,631.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(244,NULL,'2017-07-31 00:00:00',NULL,348,NULL,0.00,209.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(245,NULL,'2017-07-31 00:00:00',NULL,350,NULL,0.00,175.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(246,NULL,'2017-07-31 00:00:00',NULL,351,NULL,0.00,1068.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(247,NULL,'2017-07-31 00:00:00',NULL,353,NULL,0.00,1022.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(248,NULL,'2017-07-31 00:00:00',NULL,354,NULL,0.00,485.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(249,NULL,'2017-07-31 00:00:00',NULL,356,NULL,0.00,175.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(250,NULL,'2017-07-31 00:00:00',NULL,358,NULL,0.00,1456.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(251,NULL,'2017-07-31 00:00:00',NULL,361,NULL,0.00,1209.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(252,NULL,'2017-07-31 00:00:00',NULL,362,NULL,0.00,456.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(253,NULL,'2017-07-31 00:00:00',NULL,363,NULL,0.00,947.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(254,NULL,'2017-07-31 00:00:00',NULL,364,NULL,0.00,1530.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(255,NULL,'2017-07-31 00:00:00',NULL,366,NULL,0.00,2531.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(256,NULL,'2017-07-31 00:00:00',NULL,367,NULL,0.00,572.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(257,NULL,'2017-07-31 00:00:00',NULL,368,NULL,0.00,253.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(258,NULL,'2017-07-31 00:00:00',NULL,370,NULL,0.00,509.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(259,NULL,'2017-07-31 00:00:00',NULL,371,NULL,0.00,87.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(260,NULL,'2017-07-31 00:00:00',NULL,373,NULL,0.00,3195.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(261,NULL,'2017-07-31 00:00:00',NULL,375,NULL,0.00,231.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(262,NULL,'2017-07-31 00:00:00',NULL,376,NULL,0.00,558.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(263,NULL,'2017-07-31 00:00:00',NULL,378,NULL,0.00,807.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(264,NULL,'2017-07-31 00:00:00',NULL,379,NULL,0.00,1039.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(265,NULL,'2017-07-31 00:00:00',NULL,381,NULL,0.00,1108.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(266,NULL,'2017-07-31 00:00:00',NULL,382,NULL,0.00,310.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(267,NULL,'2017-07-31 00:00:00',NULL,383,NULL,0.00,272.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(268,NULL,'2017-07-31 00:00:00',NULL,384,NULL,0.00,504.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(269,NULL,'2017-07-31 00:00:00',NULL,387,NULL,0.00,408.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(270,NULL,'2017-07-31 00:00:00',NULL,388,NULL,0.00,422.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(271,NULL,'2017-07-31 00:00:00',NULL,389,NULL,0.00,87.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(272,NULL,'2017-07-31 00:00:00',NULL,390,NULL,0.00,456.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(273,NULL,'2017-07-31 00:00:00',NULL,393,NULL,0.00,1426.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(274,NULL,'2017-07-31 00:00:00',NULL,394,NULL,0.00,340.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(275,NULL,'2017-07-31 00:00:00',NULL,395,NULL,0.00,417.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(276,NULL,'2017-07-31 00:00:00',NULL,396,NULL,0.00,1523.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(277,NULL,'2017-07-31 00:00:00',NULL,399,NULL,0.00,252.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(278,NULL,'2017-07-31 00:00:00',NULL,400,NULL,0.00,68.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(279,NULL,'2017-07-31 00:00:00',NULL,401,NULL,0.00,854.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(280,NULL,'2017-07-31 00:00:00',NULL,402,NULL,0.00,320.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(281,NULL,'2017-07-31 00:00:00',NULL,403,NULL,0.00,752.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(282,NULL,'2017-07-31 00:00:00',NULL,404,NULL,0.00,175.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(283,NULL,'2017-07-31 00:00:00',NULL,405,NULL,0.00,170.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(284,NULL,'2017-07-31 00:00:00',NULL,408,NULL,0.00,378.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(285,NULL,'2017-07-31 00:00:00',NULL,412,NULL,0.00,209.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(286,NULL,'2017-07-31 00:00:00',NULL,413,NULL,0.00,223.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(287,NULL,'2017-07-31 00:00:00',NULL,415,NULL,0.00,209.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(288,NULL,'2017-07-31 00:00:00',NULL,417,NULL,0.00,315.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(289,NULL,'2017-07-31 00:00:00',NULL,419,NULL,0.00,126.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(290,NULL,'2017-07-31 00:00:00',NULL,423,NULL,0.00,301.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(291,NULL,'2017-07-31 00:00:00',NULL,426,NULL,0.00,252.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(292,NULL,'2017-07-31 00:00:00',NULL,438,NULL,0.00,708.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(293,NULL,'2017-07-31 00:00:00',NULL,439,NULL,0.00,150.00,0.00,'Початкові залишоки перенесені зі старої бази','0000-00-00 00:00:00',0,NULL,'0'),
(294,1,'2017-08-03 10:48:54',3,446,13,0.00,230.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(295,2,'2017-08-03 11:00:08',3,446,13,0.00,0.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'1'),
(296,3,'2017-08-03 11:00:08',3,446,13,0.00,0.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'1'),
(297,4,'2017-08-03 11:00:08',3,446,13,0.00,0.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'1'),
(298,5,'2017-08-03 11:24:14',3,446,13,0.00,50.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'1'),
(299,6,'2017-08-03 11:24:14',3,446,13,0.00,10.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'1'),
(300,10,'2017-08-03 15:26:58',3,448,32,0.00,500.00,0.00,NULL,'0000-00-00 00:00:00',0,1,'0'),
(301,11,'2017-08-03 15:27:10',3,449,5,0.00,270.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(302,12,'2017-08-03 15:37:30',3,2,13,54.00,230.00,0.00,NULL,'0000-00-00 00:00:00',0,1,'1'),
(303,13,'2017-08-03 17:58:48',3,204,5,0.00,300.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(304,15,'2017-08-03 19:15:18',3,450,5,0.00,230.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(305,37,'2017-08-04 08:58:40',5,132,6,0.00,165.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(306,39,'2017-08-04 09:03:14',5,468,6,55.00,17000.00,0.00,NULL,'0000-00-00 00:00:00',0,1,'0'),
(307,24,'2017-08-04 09:09:50',4,464,6,6.00,165.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(308,50,'2017-08-04 09:45:38',6,478,20,85.00,0.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(309,54,'2017-08-04 09:45:38',9,478,19,9.00,350.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(310,23,'2017-08-04 10:09:25',4,463,6,0.00,155.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(317,17,'2017-08-04 12:23:17',3,232,13,0.00,223.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(312,55,'2017-08-04 11:11:14',9,482,25,0.00,50.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(313,40,'2017-08-04 11:12:09',5,469,6,0.00,175.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(314,56,'2017-08-04 11:24:52',9,483,1,0.00,80.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(315,30,'2017-08-04 12:00:40',4,465,35,0.00,330.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(316,41,'2017-08-04 12:01:05',5,470,6,0.00,175.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(318,18,'2017-08-04 12:30:45',3,459,13,0.00,240.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(319,51,'2017-08-04 12:35:09',6,479,2,0.00,360.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(320,60,'2017-08-04 12:35:09',11,479,8,0.00,340.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(321,59,'2017-08-04 12:37:30',11,486,8,0.00,350.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(322,57,'2017-08-04 13:17:47',9,484,1,0.00,80.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(323,31,'2017-08-04 13:54:33',4,25,35,0.00,350.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(324,43,'2017-08-04 13:58:09',5,472,6,0.00,180.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(325,61,'2017-08-04 14:06:19',11,487,39,0.00,200.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(326,19,'2017-08-04 14:45:00',3,460,10,0.00,1000.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(327,44,'2017-08-04 14:59:37',5,473,6,0.00,170.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(328,62,'2017-08-04 15:20:53',11,488,39,0.00,200.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(329,32,'2017-08-04 15:31:06',4,466,4,0.00,230.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(330,45,'2017-08-04 15:56:56',5,474,6,0.00,175.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(331,35,'2017-08-04 16:37:34',4,335,6,0.00,175.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(332,20,'2017-08-04 17:03:03',3,143,5,0.00,280.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(333,33,'2017-08-04 17:53:43',4,467,6,0.00,190.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(334,47,'2017-08-04 17:57:44',5,475,6,0.00,60.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(335,21,'2017-08-04 18:08:38',3,461,10,0.00,1000.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(336,48,'2017-08-04 18:22:58',5,476,6,0.00,185.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(337,22,'2017-08-04 19:52:00',3,462,13,0.00,240.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(338,34,'2017-08-04 20:10:45',4,272,6,0.00,179.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(339,106,'2017-08-04 20:10:57',4,510,6,0.00,165.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(340,53,'2017-08-04 21:04:22',6,481,38,318.00,450.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(341,147,'2017-08-04 23:20:38',11,232,29,0.00,10.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'1'),
(342,NULL,'2017-08-05 00:32:06',3,66,15,99.00,555.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(343,NULL,'2017-08-06 00:53:06',3,179,15,0.00,53.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(344,NULL,'2017-08-08 19:58:34',3,25,9,0.00,3.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(345,NULL,'2017-08-08 19:58:42',3,25,9,0.00,3.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(346,NULL,'2017-08-08 19:59:02',3,12,15,0.00,5.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(347,NULL,'2017-08-08 20:01:02',3,12,15,0.00,6.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(348,NULL,'2017-08-08 20:01:27',3,8,15,0.00,7.00,0.00,NULL,'0000-00-00 00:00:00',0,NULL,'0'),
(349,NULL,'2017-08-08 20:08:33',3,12,15,0.00,96.00,0.00,NULL,'2017-08-08 20:08:33',1,NULL,'0'),
(350,NULL,'0000-00-00 00:00:00',3,7,5,0.00,52.00,0.00,NULL,'2017-08-08 20:11:51',1,NULL,'0'),
(351,NULL,'0000-00-00 00:00:00',3,7,5,0.00,52.00,0.00,NULL,'2017-08-08 20:11:57',1,NULL,'0'),
(352,NULL,'2020-12-13 00:00:00',3,7,5,0.00,52.00,0.00,NULL,'2017-08-08 20:12:13',1,NULL,'0'),
(353,NULL,'0000-00-00 00:00:00',3,7,5,0.00,52.00,0.00,NULL,'2017-08-08 20:12:35',1,NULL,'0'),
(354,NULL,'2017-08-01 20:12:48',3,7,5,0.00,51.00,0.00,NULL,'2017-08-08 20:12:48',1,1,'0'),
(355,NULL,'2017-10-05 23:59:58',NULL,NULL,NULL,0.00,0.00,-97.00,'тест5','2017-10-04 00:27:01',1,1,'0'),
(356,NULL,'2017-10-05 23:59:58',10,NULL,NULL,10.00,0.00,-4000.00,'тест8ннннн','2017-10-04 10:08:58',1,1,'0'),
(357,NULL,'2017-08-01 23:59:58',3,NULL,NULL,0.00,0.00,-200.00,'Аванс за серпень','2017-10-04 10:49:17',1,NULL,'0'),
(358,NULL,'2017-08-01 23:59:58',NULL,NULL,NULL,0.00,0.00,-2000.00,'НА краскиі лаки','2017-10-04 11:20:44',1,NULL,'0');

DROP TABLE IF EXISTS `poslygu`;

CREATE TABLE `poslygu` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `name_uk` varchar(35) collate utf8_unicode_ci default NULL,
  `name_ru` varchar(35) collate utf8_unicode_ci NOT NULL,
  `price` decimal(6,0) unsigned NOT NULL default '0',
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name_uk` (`name_uk`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Довідник Послуг';

INSERT INTO `poslygu` VALUES 
(1,'Корекція брів з фарбуванням','',90,'0'),
(2,'Фарбування однотонне','',150,'0'),
(3,'Стрижка','',60,'0'),
(4,'Повна з г.л однотонним','',270,'0'),
(5,'Акрил (повна корекція)','',220,'0'),
(6,'Гель-лак + зняття','',150,'0'),
(7,'Послуги косметолога','',0,'1'),
(8,'Нарощення вій ','',350,'0'),
(9,'Біозавивка вій','',220,'0'),
(10,'Пудрові брови','',1000,'0'),
(11,'Макіяж ','',250,'0'),
(12,'Воскова депіляція','',0,'1'),
(13,'Акрил (не повна корекція)','',160,'0'),
(14,'Акрил (нарощення)','',300,'0'),
(15,'+ Дизайн простий','',10,'0'),
(16,'Нарощення вій(об\\\'ємне)','',350,'1'),
(17,'Укладка','',100,'0'),
(18,'Фарбування омбре','',350,'0'),
(40,'Гель+г.л','',210,'0'),
(19,'Макіяж з віями','',350,'0'),
(20,'Зачіска','',200,'0'),
(21,'Не повна з г.л','',210,'0'),
(22,'Зняття гель-лаку ','',50,'0'),
(23,'Чистка нігтів','',50,'0'),
(24,'Дизайн нігтя','',10,'0'),
(25,'Корекція брів без фарбування','',70,'0'),
(26,'Сушка+миття','',100,'0'),
(27,'Вирівнювання волосся','',50,'0'),
(28,'Стрижка чолки','',20,'0'),
(29,'Зняття вій ','',50,'0'),
(30,'+Дизайн складний','',20,'0'),
(31,'+г/л','',50,'0'),
(32,'Корекція пудрових брів','',500,'0'),
(33,'Педикюр  г.л однотонний','',130,'0'),
(34,'Чистка стопи','',150,'0'),
(35,'Гелеве нарощення','',330,'0'),
(36,'Однотонна покраска','',300,'1'),
(37,'Полірування волосся','',150,'0'),
(38,'Покраска балаяж','',400,'0'),
(39,'Корекція вій','',200,'0'),
(41,'чистка+г.л','',280,'0');

DROP TABLE IF EXISTS `schedule`;

CREATE TABLE `schedule` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `author_id` smallint(5) unsigned NOT NULL,
  `master_id` smallint(5) unsigned NOT NULL,
  `klient_id` smallint(5) unsigned default NULL,
  `poslyga_id` smallint(5) unsigned default NULL,
  `datetime` datetime NOT NULL,
  `truvalist` smallint(3) unsigned NOT NULL,
  `sprat_scheds` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  `holiday` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  `comment` varchar(255) collate utf8_unicode_ci NOT NULL,
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=703 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Розклад попередніх записів клієнтів до майстрів';

INSERT INTO `schedule` VALUES 
(1,2,3,446,13,'2017-08-03 09:00:00',90,'0','0','','0'),
(2,2,3,446,13,'2017-08-03 09:00:00',90,'0','0','','0'),
(3,2,3,446,13,'2017-08-03 09:00:00',90,'0','0','','0'),
(4,2,3,446,13,'2017-08-03 09:00:00',90,'0','0','','0'),
(5,2,3,446,13,'2017-08-03 09:00:00',90,'0','0','','0'),
(6,2,3,446,13,'2017-08-03 09:00:00',90,'0','0','ф','0'),
(7,2,3,447,13,'2017-08-03 07:30:00',90,'0','0','','1'),
(8,2,3,447,13,'2017-08-03 07:30:00',90,'0','0','','1'),
(9,2,9,1,25,'2017-08-02 09:15:00',45,'0','0','','1'),
(10,2,3,448,32,'2017-08-03 10:30:00',90,'0','0','','0'),
(11,2,3,449,5,'2017-08-03 12:00:00',120,'0','0','','0'),
(12,2,3,2,13,'2017-08-03 14:00:00',90,'0','0','','0'),
(13,2,3,204,5,'2017-08-03 16:00:00',120,'0','0','','0'),
(14,2,3,450,5,'2017-08-03 18:00:00',120,'0','0','','1'),
(15,2,3,450,5,'2017-08-03 18:00:00',120,'0','0','','0'),
(16,2,8,43,33,'2017-08-05 07:30:00',60,'0','0','','1'),
(17,2,3,232,13,'2017-08-04 09:00:00',90,'0','0','','0'),
(18,2,3,459,13,'2017-08-04 10:30:00',90,'0','0','','0'),
(19,2,3,460,10,'2017-08-04 12:00:00',120,'0','0','','0'),
(20,2,3,143,5,'2017-08-04 14:00:00',120,'0','0','','0'),
(21,2,3,461,10,'2017-08-04 16:00:00',120,'0','0','','0'),
(22,2,3,462,13,'2017-08-04 18:00:00',90,'0','0','','0'),
(23,2,4,463,6,'2017-08-04 08:00:00',60,'0','0','','0'),
(24,2,4,464,6,'2017-08-04 09:00:00',60,'0','0','','0'),
(25,2,4,441,6,'2017-08-04 10:00:00',60,'1','0','','1'),
(26,2,9,441,11,'2017-08-04 07:00:00',60,'1','0','','1'),
(27,2,8,441,34,'2017-08-04 08:30:00',90,'1','0','','1'),
(28,2,9,441,1,'2017-08-04 06:00:00',60,'1','0','','1'),
(29,2,3,2,5,'2017-09-01 15:00:00',120,'0','0','','0'),
(30,2,4,465,35,'2017-08-04 10:00:00',120,'0','0','','0'),
(31,2,4,25,35,'2017-08-04 12:00:00',120,'0','0','','0'),
(32,2,4,466,4,'2017-08-04 14:30:00',120,'0','0','','0'),
(33,2,4,467,6,'2017-08-04 16:45:00',60,'0','0','','0'),
(34,2,4,272,6,'2017-08-04 18:00:00',75,'0','0','','0'),
(35,2,4,335,6,'2017-08-04 19:15:00',60,'0','0','','0'),
(36,2,5,132,6,'2017-08-04 08:00:00',90,'1','0','','1'),
(37,2,5,132,6,'2017-08-04 08:00:00',60,'1','0','','0'),
(38,2,3,204,13,'2017-09-05 17:00:00',90,'0','0','','0'),
(39,2,5,468,6,'2017-08-04 09:00:00',60,'0','0','','0'),
(40,2,5,469,6,'2017-08-04 10:00:00',60,'0','0','','0'),
(41,2,5,470,6,'2017-08-04 11:00:00',60,'0','0','','0'),
(42,2,5,471,6,'2017-08-04 12:00:00',60,'0','0','','1'),
(43,2,5,472,6,'2017-08-04 13:00:00',75,'0','0','','0'),
(44,2,5,473,6,'2017-08-04 14:15:00',45,'0','0','','0'),
(45,2,5,474,6,'2017-08-04 15:00:00',60,'0','0','','0'),
(46,2,4,456,21,'2017-09-12 10:00:00',75,'0','0','','0'),
(47,2,5,475,6,'2017-08-04 16:00:00',60,'0','0','','0'),
(48,2,5,476,6,'2017-08-04 17:00:00',60,'0','0','','0'),
(49,2,5,477,22,'2017-08-04 18:00:00',45,'0','0','','0'),
(50,2,6,478,20,'2017-08-04 08:00:00',90,'1','0','','0'),
(51,2,6,479,36,'2017-08-04 09:30:00',120,'1','0','','0'),
(52,2,6,480,37,'2017-08-04 11:30:00',60,'0','0','','1'),
(53,2,6,481,38,'2017-08-04 14:00:00',180,'0','0','','0'),
(54,2,9,478,19,'2017-08-04 07:00:00',75,'1','0','','0'),
(55,2,9,482,1,'2017-08-04 09:00:00',60,'0','0','','0'),
(56,2,9,483,1,'2017-08-04 11:00:00',60,'0','0','','0'),
(57,2,9,484,1,'2017-08-04 13:00:00',60,'0','0','','0'),
(58,2,11,485,39,'2017-08-04 08:00:00',60,'0','0','','1'),
(59,2,11,486,8,'2017-08-04 09:00:00',120,'0','0','','0'),
(60,2,11,479,8,'2017-08-04 11:00:00',120,'1','0','','0'),
(61,2,11,487,39,'2017-08-04 13:00:00',90,'0','0','','0'),
(62,2,11,488,8,'2017-08-04 14:30:00',120,'0','0','','0'),
(63,2,11,489,39,'2017-08-04 16:30:00',90,'0','0','','1'),
(64,2,3,450,5,'2017-09-06 17:30:00',120,'0','0','','0'),
(65,2,7,490,20,'2017-08-05 05:00:00',60,'1','0','завдаток 200','0'),
(66,2,3,490,11,'2017-08-05 06:00:00',60,'1','0','','0'),
(67,2,7,491,20,'2017-08-05 06:00:00',60,'1','0','','0'),
(68,2,3,491,11,'2017-08-05 07:00:00',60,'1','0','завдаток 200','0'),
(69,2,3,388,11,'2017-08-05 08:30:00',60,'1','0','','0'),
(70,2,7,388,20,'2017-08-05 07:30:00',60,'1','0','','0'),
(71,2,3,492,13,'2017-08-05 10:00:00',90,'0','0','','0'),
(72,2,3,493,5,'2017-08-05 11:30:00',120,'0','0','','0'),
(73,2,3,494,11,'2017-08-05 14:00:00',60,'0','0','','0'),
(74,2,4,424,6,'2017-08-05 07:30:00',60,'1','0','','0'),
(75,2,4,495,6,'2017-08-05 08:30:00',60,'1','0','','0'),
(76,2,4,496,6,'2017-08-05 09:45:00',60,'0','0','','0'),
(77,2,4,0,6,'2017-08-05 09:45:00',60,'1','0','','1'),
(78,2,4,497,6,'2017-08-05 11:00:00',60,'0','0','','0'),
(79,2,4,498,6,'2017-08-05 12:15:00',60,'0','0','','0'),
(80,2,4,198,40,'2017-08-05 13:30:00',90,'0','0','','0'),
(81,2,8,499,33,'2017-08-04 08:30:00',60,'0','0','','1'),
(82,2,9,0,1,'2017-08-04 12:00:00',60,'0','0','','1'),
(83,2,4,376,6,'2017-08-05 15:00:00',75,'0','0','','0'),
(84,2,4,15,6,'2017-08-05 16:15:00',60,'1','0','','1'),
(85,2,4,15,40,'2017-08-05 17:30:00',90,'1','0','','0'),
(86,2,4,500,6,'2017-08-05 16:15:00',60,'0','0','','0'),
(87,2,4,407,6,'2017-08-05 19:00:00',60,'0','0','','0'),
(88,2,4,39,40,'2017-08-05 20:00:00',90,'1','0','','0'),
(89,2,4,39,40,'2017-08-05 20:00:00',90,'1','0','','0'),
(90,2,5,501,6,'2017-08-05 08:30:00',90,'0','0','','0'),
(91,2,5,502,35,'2017-08-05 10:00:00',150,'0','0','','0'),
(92,2,5,503,6,'2017-08-05 12:30:00',60,'0','0','','0'),
(93,2,5,504,6,'2017-08-05 13:30:00',90,'1','0','','0'),
(94,2,5,505,6,'2017-08-05 15:00:00',90,'0','0','','1'),
(95,2,5,504,6,'2017-08-05 15:00:00',90,'1','0','','1'),
(96,2,5,223,6,'2017-08-05 15:00:00',75,'0','0','','0'),
(97,2,5,506,6,'2017-08-05 16:30:00',75,'0','0','','0'),
(98,2,5,507,6,'2017-08-05 17:45:00',75,'0','0','','0'),
(99,2,8,499,33,'2017-08-05 08:30:00',75,'0','0','','0'),
(100,2,8,495,41,'2017-08-05 09:45:00',90,'1','0','','0'),
(101,2,8,508,33,'2017-08-05 12:00:00',60,'0','0','','0'),
(102,2,8,313,41,'2017-08-05 13:00:00',90,'0','0','','0'),
(103,2,8,133,41,'2017-08-05 14:30:00',90,'0','0','','0'),
(104,2,8,15,33,'2017-08-05 16:00:00',60,'1','0','','0'),
(105,2,7,509,20,'2017-08-05 08:30:00',90,'1','0','','0'),
(106,2,4,510,6,'2017-08-04 20:15:00',60,'0','0','','0'),
(107,2,12,511,11,'2017-08-05 07:30:00',60,'1','0','','0'),
(108,2,12,454,11,'2017-08-05 08:30:00',90,'1','0','','0'),
(109,2,12,512,11,'2017-08-05 10:00:00',60,'0','0','завдаток 100','0'),
(110,2,12,513,11,'2017-08-05 11:00:00',60,'1','0','','0'),
(111,2,9,0,11,'2017-08-05 06:00:00',60,'1','0','','1'),
(112,2,9,514,11,'2017-08-05 06:00:00',60,'1','0','','0'),
(113,2,9,0,11,'2017-08-05 06:00:00',60,'1','0','','1'),
(114,2,9,516,11,'2017-08-05 07:00:00',60,'0','0','завдаток 250','0'),
(115,2,9,517,11,'2017-08-05 09:00:00',60,'0','0','','0'),
(116,2,9,518,11,'2017-08-05 12:00:00',90,'1','0','','0'),
(117,2,9,519,11,'2017-08-05 13:30:00',60,'1','0','','0'),
(118,2,9,453,11,'2017-08-05 14:30:00',60,'1','0','','0'),
(119,2,10,520,11,'2017-08-05 08:00:00',60,'0','0','','0'),
(120,2,7,454,20,'2017-08-05 10:00:00',60,'1','0','','0'),
(121,2,7,518,20,'2017-08-05 13:15:00',60,'1','0','','1'),
(122,2,7,453,20,'2017-08-05 11:00:00',60,'1','0','','1'),
(123,2,7,0,20,'2017-08-05 11:00:00',60,'1','0','','1'),
(124,2,7,0,20,'2017-08-05 11:00:00',60,'1','0','','1'),
(125,2,7,453,20,'2017-08-05 13:00:00',15,'1','0','','1'),
(126,2,7,0,20,'2017-08-05 11:00:00',60,'1','0','','1'),
(127,2,7,453,20,'2017-08-05 13:30:00',60,'1','0','','0'),
(128,2,7,513,20,'2017-08-05 12:00:00',60,'1','0','','0'),
(129,2,7,518,20,'2017-08-05 13:00:00',15,'1','0','','1'),
(130,2,7,481,20,'2017-08-05 11:00:00',60,'0','0','','0'),
(131,2,7,518,20,'2017-08-05 13:00:00',15,'1','0','завдаток 100','0'),
(132,2,7,518,20,'2017-08-05 13:00:00',15,'1','0','завдаток 100','0'),
(133,2,7,518,20,'2017-08-05 13:00:00',15,'1','0','завдаток 100','0'),
(134,2,6,511,20,'2017-08-05 05:30:00',90,'1','0','завдаток 400','0'),
(135,2,6,514,20,'2017-08-05 07:30:00',90,'1','0','','1'),
(136,2,6,514,20,'2017-08-05 07:30:00',60,'1','0','','0'),
(137,2,6,0,17,'2017-08-05 08:30:00',60,'1','0','','1'),
(138,2,6,509,17,'2017-08-05 08:30:00',60,'1','0','','1'),
(139,2,6,521,17,'2017-08-05 08:30:00',60,'0','0','','0'),
(140,2,6,519,20,'2017-08-05 12:00:00',90,'1','0','','0'),
(141,2,6,462,18,'2017-08-05 14:15:00',180,'0','0','','0'),
(142,2,11,522,39,'2017-08-05 08:30:00',90,'0','0','','0'),
(143,2,11,424,8,'2017-08-05 10:30:00',120,'1','0','','0'),
(144,2,11,459,8,'2017-08-05 12:30:00',120,'0','0','','0'),
(145,2,11,523,8,'2017-08-05 16:00:00',120,'0','0','','0'),
(146,2,3,462,5,'2017-09-02 17:30:00',120,'0','0','','0'),
(147,1,11,232,29,'2017-08-05 19:00:00',45,'0','0','Тест_','0'),
(148,1,12,14,19,'2017-08-05 19:00:00',75,'0','0','','0'),
(149,1,5,31,35,'2017-08-06 05:00:00',480,'0','0','','0'),
(150,0,9,NULL,NULL,'2017-08-06 05:00:00',120,'0','1','','0'),
(702,1,5,2,6,'2017-10-08 11:45:00',75,'0','0','','0'),
(701,1,8,2,23,'2017-10-06 12:00:00',30,'1','0','','0'),
(700,1,8,2,34,'2017-10-06 09:30:00',60,'1','0','','0'),
(699,1,5,25,6,'2017-10-08 08:00:00',75,'0','0','','0'),
(698,1,8,25,34,'2017-10-07 09:00:00',60,'0','0','','0'),
(697,1,6,376,36,'2017-10-06 08:30:00',120,'0','0','','0'),
(696,1,9,302,1,'2017-10-17 07:00:00',60,'0','0','','0'),
(695,1,8,302,23,'2017-10-17 08:00:00',30,'1','0','','1'),
(694,1,10,302,19,'2017-10-17 08:00:00',75,'1','0','','1'),
(693,1,12,376,19,'2017-10-16 09:30:00',75,'0','0','аа','1'),
(692,1,11,25,9,'2017-10-16 08:00:00',135,'0','0','','1'),
(691,1,8,25,23,'2017-10-17 06:15:00',30,'0','0','на удал','1'),
(690,1,6,10,20,'2017-10-16 06:45:00',90,'0','0','пап','0'),
(689,1,5,NULL,NULL,'2017-10-21 07:00:00',840,'0','1','','0'),
(688,1,5,NULL,NULL,'2017-10-21 05:00:00',120,'0','1','','0'),
(687,1,5,NULL,NULL,'2017-10-20 07:00:00',840,'0','1','','1'),
(686,1,5,NULL,NULL,'2017-10-20 05:00:00',120,'0','1','','1'),
(685,1,5,NULL,NULL,'2017-10-19 07:00:00',840,'0','1','','0'),
(684,1,5,NULL,NULL,'2017-10-19 05:00:00',120,'0','1','','0'),
(683,1,5,NULL,NULL,'2017-10-18 07:00:00',840,'0','1','','1'),
(682,1,5,NULL,NULL,'2017-10-18 05:00:00',120,'0','1','','1'),
(681,1,4,NULL,NULL,'2017-10-17 07:00:00',840,'0','1','','1'),
(680,1,4,NULL,NULL,'2017-10-17 05:00:00',120,'0','1','','0'),
(679,1,4,NULL,NULL,'2017-10-16 07:00:00',840,'0','1','','0'),
(678,1,4,NULL,NULL,'2017-10-16 05:00:00',120,'0','1','','0'),
(677,1,9,NULL,NULL,'2017-10-11 07:00:00',840,'0','1','','0'),
(676,1,9,NULL,NULL,'2017-10-11 05:00:00',120,'0','1','','0'),
(675,1,7,NULL,NULL,'2017-10-11 07:00:00',840,'0','1','','0'),
(674,1,7,NULL,NULL,'2017-10-11 05:00:00',120,'0','1','','0'),
(673,1,4,NULL,NULL,'2017-10-11 07:00:00',840,'0','1','','0'),
(672,1,4,NULL,NULL,'2017-10-11 05:00:00',120,'0','1','','0'),
(671,1,5,NULL,NULL,'2017-10-10 07:00:00',840,'0','1','','0'),
(670,1,5,NULL,NULL,'2017-10-10 05:00:00',120,'0','1','','0'),
(669,1,3,NULL,NULL,'2017-10-10 07:00:00',840,'0','1','','0'),
(668,1,3,NULL,NULL,'2017-10-10 05:00:00',120,'0','1','','0'),
(667,1,4,NULL,NULL,'2017-10-09 07:00:00',840,'0','1','','0'),
(666,1,4,NULL,NULL,'2017-10-09 05:00:00',120,'0','1','','0');

DROP TABLE IF EXISTS `sms_log`;

CREATE TABLE `sms_log` (
  `id` smallint(4) unsigned NOT NULL auto_increment,
  `tel` varchar(12) collate utf8_unicode_ci NOT NULL,
  `text` varchar(255) collate utf8_unicode_ci NOT NULL,
  `datetime` datetime NOT NULL,
  `status` varchar(10) collate utf8_unicode_ci default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='тут зберігаються смс, які були відправлені';

DROP TABLE IF EXISTS `sms_schedule`;

CREATE TABLE `sms_schedule` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `date` date NOT NULL,
  `schedule_id` smallint(5) unsigned NOT NULL,
  `klient_id` smallint(5) unsigned NOT NULL,
  `text` varchar(255) collate utf8_unicode_ci NOT NULL,
  `send` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  `delete` enum('0','1') collate utf8_unicode_ci NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Тут записується майбутні смс, які будуть відправлені певної ';

INSERT INTO `sms_schedule` VALUES 
(1,'2017-10-08',702,2,'Нагадуємо Ви записані в Like у неділю о 11:45. 0936329533 0672929804','0','0');

DROP TABLE IF EXISTS `time_vuk_zavdan`;

CREATE TABLE `time_vuk_zavdan` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `admin_id` smallint(5) unsigned NOT NULL,
  `poslyga_id` smallint(5) unsigned NOT NULL,
  `time` smallint(3) unsigned NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Час виконання певної послуги певним працівником';

INSERT INTO `time_vuk_zavdan` VALUES 
(1,3,14,120),
(2,3,13,90),
(3,3,5,120),
(4,10,11,60),
(5,10,19,75),
(6,11,9,60),
(7,11,29,50),
(8,11,8,120),
(9,11,16,120),
(10,3,32,90),
(11,3,10,120),
(12,9,25,45),
(13,9,1,60),
(14,9,11,60),
(15,9,19,75),
(16,4,6,75),
(17,4,22,30),
(18,4,21,90),
(19,4,4,120),
(20,3,11,60),
(21,3,19,75),
(22,4,23,30),
(23,5,23,30),
(24,12,23,30),
(46,7,38,180),
(54,7,20,60),
(27,8,33,60),
(28,8,34,60),
(29,4,35,120),
(30,5,35,180),
(31,5,6,75),
(32,5,22,60),
(33,5,21,120),
(34,5,4,180),
(35,6,27,60),
(36,6,20,90),
(37,6,36,120),
(38,6,38,180),
(39,6,28,30),
(40,6,26,60),
(41,6,17,60),
(42,6,2,120),
(43,6,18,180),
(44,6,37,60),
(45,11,39,90),
(47,7,37,60),
(48,7,3,60),
(49,7,28,30),
(50,7,26,60),
(51,7,17,60),
(52,7,2,120),
(53,7,18,180),
(55,4,40,90),
(56,5,40,120),
(57,8,41,90),
(58,8,23,30),
(59,12,11,60),
(60,12,19,75);

